/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JToolTip;

public class JToolTipFactory {
    private static JToolTipFactory _tooltipFactory;

    public JToolTip createToolTip(JComponent c2) {
        return this.createToolTip(c2, false);
    }

    public JToolTip createToolTip(JComponent c2, boolean overlapping) {
        JToolTip tt = new JToolTip();
        if (c2 != null) {
            tt.setComponent(c2);
            if (overlapping) {
                if (c2.getBackground() != null) {
                    Color bg2 = c2.getBackground();
                    if (bg2.getAlpha() != 255) {
                        bg2 = new Color(bg2.getRed(), bg2.getGreen(), bg2.getBlue());
                    }
                    tt.setBackground(bg2);
                }
                if (c2.getForeground() != null) {
                    tt.setForeground(c2.getForeground());
                }
                if (c2.getFont() != null) {
                    tt.setFont(c2.getFont());
                }
            }
        }
        return tt;
    }

    public static void setSharedInstance(JToolTipFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("JToolTipFactory can not be null");
        }
        _tooltipFactory = factory;
    }

    public static JToolTipFactory getSharedInstance() {
        if (_tooltipFactory == null) {
            _tooltipFactory = new JToolTipFactory();
        }
        return _tooltipFactory;
    }
}

