/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Overlayable;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DefaultOverlayable
extends JPanel
implements Overlayable,
ComponentListener {
    private JComponent _actualComponent;
    private Insets _overlayLocationInsets = new Insets(0, 0, 0, 0);
    private List<JComponent> _overlayComponents;
    private Map<JComponent, Integer> _overlayLocations;

    public DefaultOverlayable() {
        this.initComponents();
    }

    public DefaultOverlayable(JComponent component) {
        this.initComponents();
        this.setActualComponent(component);
    }

    public DefaultOverlayable(JComponent actualComponent, JComponent overlayComponent, int overlayLocation) {
        this.initComponents();
        this.setActualComponent(actualComponent);
        this.addOverlayComponent(overlayComponent, overlayLocation);
    }

    public DefaultOverlayable(JComponent actualComponent, JComponent overlayComponent) {
        this.initComponents();
        this.setActualComponent(actualComponent);
        this.addOverlayComponent(overlayComponent, 0);
    }

    private void initComponents() {
        this.setLayout(null);
        this._overlayComponents = new Vector<JComponent>();
        this._overlayLocations = new Hashtable<JComponent, Integer>();
    }

    public Dimension getPreferredSize() {
        Dimension size = this.getActualComponent() == null ? new Dimension(0, 0) : this.getActualComponent().getPreferredSize();
        Insets insets = this.getOverlayLocationInsets();
        if (insets != null) {
            size.width += Math.max(0, insets.left) + Math.max(0, insets.right);
            size.height += Math.max(0, insets.top) + Math.max(0, insets.bottom);
        }
        return size;
    }

    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
        if (this.getActualComponent() != null) {
            Insets insets;
            if (preferredSize != null && (insets = this.getOverlayLocationInsets()) != null) {
                preferredSize.width -= Math.max(0, insets.left) + Math.max(0, insets.right);
                preferredSize.width = Math.max(0, preferredSize.width);
                preferredSize.height -= Math.max(0, insets.top) + Math.max(0, insets.bottom);
                preferredSize.height = Math.max(0, preferredSize.height);
            }
            this.getActualComponent().setPreferredSize(preferredSize);
        }
    }

    public Dimension getMinimumSize() {
        Dimension size = this.getActualComponent() == null ? new Dimension(0, 0) : this.getActualComponent().getMinimumSize();
        Insets insets = this.getOverlayLocationInsets();
        if (insets != null) {
            size.width += Math.max(0, insets.left) + Math.max(0, insets.right);
            size.height += Math.max(0, insets.top) + Math.max(0, insets.bottom);
        }
        return size;
    }

    public void setMinimumSize(Dimension minimumSize) {
        super.setMinimumSize(minimumSize);
        if (this.getActualComponent() != null) {
            Insets insets;
            if (minimumSize != null && (insets = this.getOverlayLocationInsets()) != null) {
                minimumSize.width -= Math.max(0, insets.left) + Math.max(0, insets.right);
                minimumSize.width = Math.max(0, minimumSize.width);
                minimumSize.height -= Math.max(0, insets.top) + Math.max(0, insets.bottom);
                minimumSize.height = Math.max(0, minimumSize.height);
            }
            this.getActualComponent().setMinimumSize(minimumSize);
        }
    }

    public void setBounds(int x2, int y2, int width, int height) {
        super.setBounds(x2, y2, width, height);
        Insets insets = this.getOverlayLocationInsets();
        if (insets != null) {
            x2 = Math.max(0, insets.left);
            y2 = Math.max(0, insets.top);
            width -= Math.max(0, insets.left) + Math.max(0, insets.right);
            height -= Math.max(0, insets.top) + Math.max(0, insets.bottom);
        }
        if (this.getActualComponent() != null) {
            this.getActualComponent().setBounds(x2, y2, width, height);
        }
        this.updateLocation();
    }

    private void updateLocation() {
        JComponent[] components;
        for (JComponent c2 : components = this.getOverlayComponents()) {
            if (c2 == null) {
                return;
            }
            Rectangle r2 = this.getOverlayComponentBounds(c2);
            c2.setBounds(r2);
        }
    }

    protected Rectangle getOverlayComponentBounds(JComponent component) {
        JComponent relativeComponent = this.getActualComponent();
        Rectangle bounds = relativeComponent.getBounds();
        if (relativeComponent != this.getActualComponent()) {
            bounds = SwingUtilities.convertRectangle(relativeComponent.getParent(), bounds, this.getActualComponent());
        }
        Rectangle overlayBounds = new Rectangle(bounds);
        Insets insets = this.getOverlayLocationInsets();
        overlayBounds.x -= insets.left;
        overlayBounds.y -= insets.top;
        overlayBounds.width += insets.left + insets.right;
        overlayBounds.height += insets.top + insets.bottom;
        int cx2 = 0;
        int cy2 = 0;
        Dimension size = component.getPreferredSize();
        int cw2 = size.width;
        int ch2 = size.height;
        int overlayLocation = this.getOverlayLocation(component);
        if (overlayLocation == 10) {
            if (component.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
                overlayLocation = 7;
            } else if (component.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                overlayLocation = 3;
            }
        } else if (overlayLocation == 11) {
            if (component.getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
                overlayLocation = 3;
            } else if (component.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                overlayLocation = 7;
            }
        }
        switch (overlayLocation) {
            case 0: {
                cx2 = bounds.x + (bounds.width - cw2) / 2;
                cy2 = bounds.y + (bounds.height - ch2) / 2;
                break;
            }
            case 1: {
                cx2 = bounds.x + (bounds.width - cw2) / 2;
                cy2 = overlayBounds.y;
                break;
            }
            case 5: {
                cx2 = bounds.x + (bounds.width - cw2) / 2;
                cy2 = overlayBounds.y + overlayBounds.height - ch2;
                break;
            }
            case 7: {
                cx2 = overlayBounds.x;
                cy2 = bounds.y + (bounds.height - ch2) / 2;
                break;
            }
            case 3: {
                cx2 = overlayBounds.x + overlayBounds.width - cw2;
                cy2 = bounds.y + (bounds.height - ch2) / 2;
                break;
            }
            case 8: {
                cx2 = overlayBounds.x;
                cy2 = overlayBounds.y;
                break;
            }
            case 2: {
                cx2 = overlayBounds.x + overlayBounds.width - cw2;
                cy2 = overlayBounds.y;
                break;
            }
            case 6: {
                cx2 = overlayBounds.x;
                cy2 = overlayBounds.y + overlayBounds.height - ch2;
                break;
            }
            case 4: {
                cx2 = overlayBounds.x + overlayBounds.width - cw2;
                cy2 = overlayBounds.y + overlayBounds.height - ch2;
            }
        }
        return new Rectangle(cx2, cy2, cw2, ch2);
    }

    public int getOverlayLocation(JComponent component) {
        Integer location = this._overlayLocations.get(component);
        if (location != null) {
            return location;
        }
        return -1;
    }

    public void setOverlayLocation(JComponent component, int location) {
        this.setOverlayLocation(component, null, location);
    }

    private void setOverlayLocation(JComponent component, Component relativeComponent, int location) {
        boolean updated = false;
        int old = this.getOverlayLocation(component);
        if (old != location) {
            this._overlayLocations.put(component, location);
            updated = true;
        }
        if (updated) {
            this.updateLocation();
        }
    }

    public void addOverlayComponent(JComponent component) {
        this.addOverlayComponent(component, 0, -1);
    }

    public void addOverlayComponent(JComponent component, int location) {
        this.addOverlayComponent(component, location, -1);
    }

    public void addOverlayComponent(JComponent component, int location, int index) {
        this.addOverlayComponent(component, null, location, index);
    }

    private void addOverlayComponent(JComponent component, Component relativeComponent, int location, int index) {
        if (this._overlayComponents.contains(component)) {
            this._overlayComponents.remove(component);
        }
        if (index == -1) {
            this._overlayComponents.add(component);
            this.add((Component)component, this.getComponentCount() - 1);
        } else {
            this._overlayComponents.add(index, component);
            this.add((Component)component, index);
        }
        this.setOverlayLocation(component, relativeComponent, location);
    }

    public void removeOverlayComponent(JComponent component) {
        if (this._overlayComponents.contains(component)) {
            this._overlayComponents.remove(component);
            this._overlayLocations.remove(component);
            this.remove(component);
        }
    }

    public JComponent[] getOverlayComponents() {
        return this._overlayComponents.toArray(new JComponent[this._overlayComponents.size()]);
    }

    public JComponent getActualComponent() {
        return this._actualComponent;
    }

    public void setActualComponent(JComponent actualComponent) {
        if (this._actualComponent != null) {
            this.remove(this._actualComponent);
            this._actualComponent.putClientProperty("Overlayable.overlayable", null);
        }
        this._actualComponent = actualComponent;
        this._actualComponent.putClientProperty("Overlayable.overlayable", this);
        this.add(this._actualComponent);
        Container container = this.getParent();
        if (container != null) {
            this.invalidate();
            container.validate();
        }
    }

    public Insets getOverlayLocationInsets() {
        return this._overlayLocationInsets;
    }

    public void setOverlayLocationInsets(Insets overlayLocationInsets) {
        this._overlayLocationInsets = overlayLocationInsets;
        Container container = this.getParent();
        if (container != null) {
            this.invalidate();
            container.validate();
        }
    }

    public void setOverlayVisible(boolean visible) {
        JComponent[] components;
        for (JComponent component : components = this.getOverlayComponents()) {
            component.setVisible(visible);
        }
    }

    public void componentResized(ComponentEvent e2) {
        this.updateLocation();
    }

    public void componentMoved(ComponentEvent e2) {
        this.updateLocation();
    }

    public void componentShown(ComponentEvent e2) {
        this.updateLocation();
    }

    public void componentHidden(ComponentEvent e2) {
        this.updateLocation();
    }
}

