/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.spinner;

import com.jidesoft.spinner.PointFormatter;
import com.jidesoft.spinner.SpinnerPointModel;
import com.jidesoft.spinner.SpinnerWheelSupport;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.text.DefaultFormatterFactory;

public class PointSpinner
extends JSpinner {
    public PointSpinner(SpinnerPointModel model) {
        super(model);
        this.customizeSpinner();
    }

    public PointSpinner() {
        this(new SpinnerPointModel());
    }

    protected JComponent createEditor(SpinnerModel model) {
        return new PointEditor(this);
    }

    private void updateField() {
        JComponent editor = this.getEditor();
        if (editor instanceof PointEditor && this.getModel() instanceof SpinnerPointModel) {
            JFormattedTextField ftf = ((PointEditor)editor).getTextField();
            SpinnerPointModel model = (SpinnerPointModel)this.getModel();
            int comma = ftf.getText().indexOf(44);
            int caret = ftf.getCaretPosition();
            model.setField(caret <= comma ? 0 : 1);
        }
    }

    public Point getNextValue() {
        this.updateField();
        return (Point)super.getNextValue();
    }

    public Point getPreviousValue() {
        this.updateField();
        return (Point)super.getPreviousValue();
    }

    public Point getValue() {
        return (Point)super.getValue();
    }

    protected void customizeSpinner() {
        SpinnerWheelSupport.installMouseWheelSupport(this);
    }

    public static class PointEditor
    extends JSpinner.DefaultEditor {
        public PointEditor(JSpinner spinner) {
            super(spinner);
            if (!(spinner.getModel() instanceof SpinnerPointModel)) {
                throw new IllegalArgumentException("model not a SpinnerPointModel");
            }
            final SpinnerPointModel model = (SpinnerPointModel)spinner.getModel();
            JFormattedTextField.AbstractFormatter formatter2 = PointFormatter.getInstance();
            DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter2);
            final JFormattedTextField ftf = this.getTextField();
            ftf.setEditable(true);
            ftf.setFormatterFactory(factory);
            ftf.setHorizontalAlignment(4);
            String min = Integer.toString(Integer.MIN_VALUE);
            ftf.setColumns(4 + 2 * min.length());
            ftf.addPropertyChangeListener("value", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    int number;
                    String digit;
                    String text2 = ftf.getText();
                    int comma = text2.indexOf(44);
                    if (model.getField() == 0) {
                        digit = text2.substring(text2.indexOf(40) + 1, comma).trim();
                        number = text2.indexOf(digit);
                    } else {
                        digit = text2.substring(comma + 1, text2.indexOf(41)).trim();
                        number = text2.lastIndexOf(digit);
                    }
                    ftf.select(number, number + digit.length());
                }
            });
        }
    }
}

