/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.CategoryRange;
import com.jidesoft.range.Positionable;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Category<T>
implements Positionable,
Serializable {
    private static final long serialVersionUID = -273502456506105902L;
    private String _name;
    private T _value;
    private CategoryRange<T> _range;

    public Category(String name, T value) {
        this.setName(name);
        this._value = value;
    }

    public Category(String name, T value, CategoryRange<T> range) {
        this.setName(name);
        this._value = value;
        this._range = range;
    }

    public Category(T value) {
        this._value = value;
    }

    public Category(T value, CategoryRange<T> range) {
        this._value = value;
        this._range = range;
    }

    public CategoryRange<T> getRange() {
        return this._range;
    }

    public void setRange(CategoryRange<T> range) {
        this._range = range;
    }

    @Override
    public double position() {
        if (this._range == null) {
            throw new IllegalStateException("Cannot compute position for a category that does not belong to a range");
        }
        return this._range.position(this._value);
    }

    public T getValue() {
        return this._value;
    }

    public String getName() {
        if (this._name == null) {
            return this._value.toString();
        }
        return this._name;
    }

    private void setName(String name) {
        this._name = name;
    }

    @Override
    public int compareTo(Positionable o2) {
        double otherPosition = o2.position();
        double position = this.position();
        if (position < otherPosition) {
            return -1;
        }
        if (position > otherPosition) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Category other = (Category)obj;
        if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
            return false;
        }
        return !(this._value == null ? other._value != null : !this._value.equals(other._value));
    }

    public String toString() {
        return String.format("#<Category name='%s' value='%s'>", this._name, this._value.toString());
    }
}

