/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanRange
extends AbstractRange<Boolean> {
    private Boolean _lower = false;
    private Boolean _upper = true;

    public BooleanRange(boolean lower, boolean upper) {
        this.adjust(lower, upper);
    }

    @Override
    public Range<Boolean> createIntermediate(Range<Boolean> targetRange, double position) {
        return null;
    }

    @Override
    public Boolean lower() {
        return this._lower;
    }

    @Override
    public Boolean upper() {
        return this._lower;
    }

    @Override
    public void adjust(Boolean lower, Boolean upper) {
        this.setMin(lower);
        this.setMax(upper);
    }

    protected void setMin(boolean lower) {
        boolean old = this._lower;
        this._lower = lower;
        this.firePropertyChange("min", old, this._lower);
    }

    protected void setMax(boolean upper) {
        boolean old = this._upper;
        this._upper = upper;
        this.firePropertyChange("max", old, this._upper);
    }

    @Override
    public double minimum() {
        throw new UnsupportedOperationException("minimum() is not implemented in StringRange");
    }

    @Override
    public double maximum() {
        throw new UnsupportedOperationException("maximum() is not implemented in StringRange");
    }

    @Override
    public double size() {
        return this._lower.compareTo(this._upper);
    }

    @Override
    public boolean contains(Boolean x2) {
        if (x2 == null) {
            return false;
        }
        return x2.compareTo(this.lower()) >= 0 && x2.compareTo(this.upper()) <= 0;
    }

    public String toString() {
        return "BooleanRange{lower='" + this._lower + '\'' + ", upper='" + this._upper + '\'' + '}';
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof BooleanRange)) {
            return false;
        }
        BooleanRange that = (BooleanRange)o2;
        if (this._lower != null ? !this._lower.equals(that._lower) : that._lower != null) {
            return false;
        }
        return !(this._upper != null ? !this._upper.equals(that._upper) : that._upper != null);
    }

    public int hashCode() {
        int result = this._lower != null ? this._lower.hashCode() : 0;
        result = 31 * result + (this._upper != null ? this._upper.hashCode() : 0);
        return result;
    }
}

