/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.xerto;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.xerto.XertoUtils;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class XertoPainter
extends BasicPainter {
    private static XertoPainter _instance;
    private static final ImageIcon SELECTED;
    private static final ImageIcon SELECTED_C;
    private static final ImageIcon ROLLOVER;
    private static final ImageIcon ROLLOVER_C;
    private static final ImageIcon PRESSED;
    private static final ImageIcon PRESSED_C;

    public static ThemePainter getInstance() {
        if (_instance == null) {
            _instance = new XertoPainter();
        }
        return _instance;
    }

    protected XertoPainter() {
    }

    public void paintCollapsiblePaneTitlePaneBackground(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        Graphics2D g2d = (Graphics2D)g2;
        Color gradientBot = XertoUtils.getHighlightColor(c2.getBackground());
        Color gradientTop = XertoUtils.getLighterColor(c2.getBackground());
        JideSwingUtilities.fillGradient(g2d, rect, gradientTop, gradientBot, true);
    }

    public void paintCollapsiblePaneTitlePaneBackgroundEmphasized(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        Graphics2D g2d = (Graphics2D)g2;
        Color gradientBot = XertoUtils.getEmBaseColor(c2.getBackground());
        Color gradientTop = c2.getBackground();
        JideSwingUtilities.fillGradient(g2d, rect, gradientTop, gradientBot, true);
    }

    public void paintMenuItemBackground(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state, boolean showBorder) {
        super.paintMenuItemBackground(c2, g2, rect, orientation, state, showBorder);
    }

    public void paintButtonBackground(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        if (state == 0) {
            super.paintButtonBackground(c2, g2, rect, orientation, state);
        } else if (state == 2) {
            this.paintImageBorder(g2, rect, ROLLOVER, ROLLOVER_C, null);
        } else if (state == 3) {
            this.paintImageBorder(g2, rect, SELECTED, SELECTED_C, Color.WHITE);
        } else if (state == 1) {
            this.paintImageBorder(g2, rect, PRESSED, PRESSED_C, null);
        }
    }

    private void paintImageBorder(Graphics g2, Rectangle rect, ImageIcon icon, ImageIcon center, Color background) {
        JideSwingUtilities.drawImageBorder(g2, icon, rect, new Insets(4, 4, 4, 4), false);
        if (center == null) {
            Color oldColor = g2.getColor();
            g2.setColor(background);
            g2.fillRect(rect.x + 4, rect.y + 4, rect.width - 8, rect.height - 8);
            g2.setColor(oldColor);
        } else {
            g2.drawImage(center.getImage(), rect.x + 4, rect.y + 4, rect.x + rect.width - 4, rect.y + rect.height - 4, 0, 0, center.getIconWidth(), center.getIconHeight(), background, null);
        }
    }

    public void paintGripper(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        if (rect.width > 30) {
            orientation = 1;
        }
        int h2 = orientation == 0 ? rect.height : rect.width;
        int count = Math.min(9, (h2 - 6) / 4);
        int y2 = rect.y;
        int x2 = rect.x;
        if (orientation == 0) {
            y2 += rect.height / 2 - count * 2;
            x2 += rect.width / 2 - 1;
        } else {
            x2 += rect.width / 2 - count * 2;
            y2 += rect.height / 2 - 1;
        }
        for (int i2 = 0; i2 < count; ++i2) {
            g2.setColor(this.getGripperForegroundLt());
            g2.fillRect(x2 + 1, y2 + 1, 2, 2);
            g2.setColor(XertoUtils.getControlMidShadowColor());
            g2.fillRect(x2, y2, 2, 2);
            g2.setColor(XertoUtils.getControlLightShadowColor());
            g2.fillRect(x2, y2, 1, 1);
            g2.setColor(XertoUtils.getControlDarkShadowColor());
            g2.fillRect(x2 + 1, y2 + 1, 1, 1);
            if (orientation == 0) {
                y2 += 4;
                continue;
            }
            x2 += 4;
        }
    }

    public void paintDockableFrameTitlePane(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        Graphics2D g2d = (Graphics2D)g2;
        if (3 == state) {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height), XertoUtils.getFrameActiveTitleTopColor(), XertoUtils.getFrameActiveTitleBottomColor(), orientation == 0);
        } else {
            JideSwingUtilities.fillGradient(g2d, new Rectangle(rect.x, rect.y, rect.width, rect.height), XertoUtils.getFrameInactiveTitleTopColor(), XertoUtils.getFrameInactiveTitleBottomColor(), orientation == 0);
        }
    }

    public void paintStatusBarSeparator(JComponent c2, Graphics g2, Rectangle rect, int orientation, int state) {
        int h2 = orientation == 0 ? c2.getHeight() : c2.getWidth();
        h2 -= 3;
        if (orientation == 0) {
            int x2 = rect.x;
            int y2 = rect.y + 1;
            g2.setColor(UIDefaultsLookup.getColor("controlShadow"));
            g2.drawLine(x2, y2, x2, y2 + h2);
            g2.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
            g2.drawLine(x2 + 1, y2, x2 + 1, y2 + h2);
        } else {
            int x3 = rect.x + 1;
            int y3 = rect.y;
            g2.setColor(UIDefaultsLookup.getColor("controlShadow"));
            g2.drawLine(x3, y3, x3 + h2, y3);
            g2.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
            g2.drawLine(x3, y3 + 1, x3 + h2, y3 + 1);
        }
    }

    public Color getGripperForeground() {
        return XertoUtils.getControlLightShadowColor();
    }

    public Color getGripperForegroundLt() {
        return Color.WHITE;
    }

    public Color getSelectionSelectedDk() {
        return XertoUtils.getControlMidShadowColor();
    }

    public Color getSelectionSelectedLt() {
        return XertoUtils.getControlLightShadowColor();
    }

    static {
        SELECTED = IconsFactory.getImageIcon(XertoPainter.class, "icons/selected.gif");
        SELECTED_C = IconsFactory.getImageIcon(XertoPainter.class, "icons/selected_c.gif");
        ROLLOVER = IconsFactory.getImageIcon(XertoPainter.class, "icons/rollover.gif");
        ROLLOVER_C = IconsFactory.getImageIcon(XertoPainter.class, "icons/rollover_c.gif");
        PRESSED = IconsFactory.getImageIcon(XertoPainter.class, "icons/pressed.gif");
        PRESSED_C = IconsFactory.getImageIcon(XertoPainter.class, "icons/pressed_c.gif");
    }
}

