/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TopLevelMenuContainer;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class MetalMenuItemUI
extends MenuItemUI {
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    private String acceleratorDelimiter;
    protected int defaultTextIconGap;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    private PropertyChangeListener propertyChangeListener;
    protected Icon arrowIcon = null;
    protected Icon checkIcon = null;
    protected boolean oldBorderPainted;
    InputMap windowInputMap;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    static final String MAX_TEXT_WIDTH = "maxTextWidth";
    static final String MAX_ACC_WIDTH = "maxAccWidth";
    protected ThemePainter _painter;
    static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();

    public static ComponentUI createUI(JComponent c2) {
        return new MetalMenuItemUI();
    }

    public void installUI(JComponent c2) {
        this.menuItem = (JMenuItem)c2;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        String prefix = this.getPropertyPrefix();
        this.acceleratorFont = UIDefaultsLookup.getFont("MenuItem.acceleratorFont");
        if (this.acceleratorFont == null) {
            this.acceleratorFont = UIManager.getFont("MenuItem.font");
        }
        this.menuItem.setOpaque(true);
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIDefaultsLookup.getInsets(prefix + ".margin"));
        }
        this.defaultTextIconGap = 4;
        LookAndFeel.installBorder(this.menuItem, prefix + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        this.menuItem.setBorderPainted((Boolean)UIDefaultsLookup.get(prefix + ".borderPainted"));
        LookAndFeel.installColorsAndFont(this.menuItem, prefix + ".background", prefix + ".foreground", prefix + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIDefaultsLookup.getColor(prefix + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIDefaultsLookup.getColor(prefix + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIDefaultsLookup.getColor(prefix + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIDefaultsLookup.getColor(prefix + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIDefaultsLookup.getColor(prefix + ".acceleratorSelectionForeground");
        }
        this.acceleratorDelimiter = UIDefaultsLookup.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIDefaultsLookup.getIcon(prefix + ".arrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIDefaultsLookup.getIcon(prefix + ".checkIcon");
        }
    }

    protected void installComponents(JMenuItem menuItem) {
        BasicHTML.updateRenderer(menuItem, menuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        if (this.mouseInputListener != null) {
            this.menuItem.addMouseListener(this.mouseInputListener);
            this.menuItem.addMouseMotionListener(this.mouseInputListener);
        }
        if ((this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem)) != null) {
            this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        }
        if ((this.menuKeyListener = this.createMenuKeyListener(this.menuItem)) != null) {
            this.menuItem.addMenuKeyListener(this.menuKeyListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem)) != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.menuItem, actionMap);
        this.updateAcceleratorBinding();
    }

    public void uninstallUI(JComponent c2) {
        this.menuItem = (JMenuItem)c2;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        Container parent = this.menuItem.getParent();
        if (!(parent == null || !(parent instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            JComponent p2 = (JComponent)parent;
            p2.putClientProperty(MAX_ACC_WIDTH, null);
            p2.putClientProperty(MAX_TEXT_WIDTH, null);
        }
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        this._painter = null;
        LookAndFeel.uninstallBorder(this.menuItem);
        this.menuItem.setBorderPainted(this.oldBorderPainted);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallComponents(JMenuItem menuItem) {
        BasicHTML.updateRenderer(menuItem, "");
    }

    protected void uninstallListeners() {
        if (this.mouseInputListener != null) {
            this.menuItem.removeMouseListener(this.mouseInputListener);
            this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        }
        if (this.menuDragMouseListener != null) {
            this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        }
        if (this.menuKeyListener != null) {
            this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        if (this.windowInputMap != null) {
            SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
            this.windowInputMap = null;
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent c2) {
        return new MouseInputHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c2) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c2) {
        return new MenuKeyHandler();
    }

    private PropertyChangeListener createPropertyChangeListener(JComponent c2) {
        return new PropertyChangeHandler();
    }

    protected ActionMap getActionMap() {
        String propertyPrefix = this.getPropertyPrefix();
        String uiKey = propertyPrefix + ".actionMap";
        ActionMap am2 = (ActionMap)UIDefaultsLookup.get(uiKey);
        if (am2 == null) {
            am2 = this.createActionMap();
            UIManager.getLookAndFeelDefaults().put(uiKey, am2);
        }
        return am2;
    }

    protected ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("doClick", new ClickAction());
        return map;
    }

    protected InputMap createInputMap(int condition) {
        if (condition == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void updateAcceleratorBinding() {
        KeyStroke accelerator = this.menuItem.getAccelerator();
        if (this.windowInputMap != null) {
            this.windowInputMap.clear();
        }
        if (accelerator != null) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            this.windowInputMap.put(accelerator, "doClick");
        }
    }

    public Dimension getMinimumSize(JComponent c2) {
        Dimension d2 = null;
        View v2 = (View)c2.getClientProperty("html");
        if (v2 != null) {
            d2 = this.getPreferredSize(c2);
            d2.width = (int)((float)d2.width - (v2.getPreferredSpan(0) - v2.getMinimumSpan(0)));
        }
        return d2;
    }

    public Dimension getPreferredSize(JComponent c2) {
        return this.getPreferredMenuItemSize(c2, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    public Dimension getMaximumSize(JComponent c2) {
        Dimension d2 = null;
        View v2 = (View)c2.getClientProperty("html");
        if (v2 != null) {
            d2 = this.getPreferredSize(c2);
            d2.width = (int)((float)d2.width + (v2.getMaximumSpan(0) - v2.getPreferredSpan(0)));
        }
        return d2;
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    protected Dimension getPreferredMenuItemSize(JComponent c2, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        JMenuItem b2 = (JMenuItem)c2;
        Icon icon = b2.getIcon();
        String text2 = b2.getText();
        KeyStroke accelerator = b2.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + this.acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        Font font = b2.getFont();
        FontMetrics fm = b2.getFontMetrics(font);
        FontMetrics fmAccel = b2.getFontMetrics(this.acceleratorFont);
        this.resetRects();
        this.layoutMenuItem(fm, text2, fmAccel, acceleratorText, icon, checkIcon, arrowIcon, b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, text2 == null ? 0 : defaultTextIconGap, defaultTextIconGap, this.getIconPaddings(b2));
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(MetalMenuItemUI.iconRect.x, MetalMenuItemUI.iconRect.y, MetalMenuItemUI.iconRect.width, MetalMenuItemUI.iconRect.height, r);
        Container parent = this.menuItem.getParent();
        if (!(parent == null || !(parent instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            int maxAccValue;
            JComponent p2 = (JComponent)parent;
            Integer maxTextWidth = (Integer)p2.getClientProperty(MAX_TEXT_WIDTH);
            Integer maxAccWidth = (Integer)p2.getClientProperty(MAX_ACC_WIDTH);
            int maxTextValue = maxTextWidth != null ? maxTextWidth : 0;
            int n2 = maxAccValue = maxAccWidth != null ? maxAccWidth : 0;
            if (MetalMenuItemUI.r.width < maxTextValue) {
                MetalMenuItemUI.r.width = maxTextValue;
            } else {
                p2.putClientProperty(MAX_TEXT_WIDTH, MetalMenuItemUI.r.width);
            }
            if (MetalMenuItemUI.acceleratorRect.width > maxAccValue) {
                maxAccValue = MetalMenuItemUI.acceleratorRect.width;
                p2.putClientProperty(MAX_ACC_WIDTH, MetalMenuItemUI.acceleratorRect.width);
            }
            MetalMenuItemUI.r.width += maxAccValue;
            MetalMenuItemUI.r.width += defaultTextIconGap;
        }
        if (this.useCheckAndArrow()) {
            MetalMenuItemUI.r.width += MetalMenuItemUI.checkIconRect.width;
            MetalMenuItemUI.r.width += defaultTextIconGap;
            MetalMenuItemUI.r.width += defaultTextIconGap;
            MetalMenuItemUI.r.width += MetalMenuItemUI.arrowIconRect.width;
        }
        MetalMenuItemUI.r.width += 2 * defaultTextIconGap;
        Insets insets = b2.getInsets();
        if (insets != null) {
            MetalMenuItemUI.r.width += insets.left + insets.right;
            MetalMenuItemUI.r.height += insets.top + insets.bottom;
        }
        if (MetalMenuItemUI.r.width % 2 == 0) {
            ++MetalMenuItemUI.r.width;
        }
        if (MetalMenuItemUI.r.height % 2 == 0) {
            ++MetalMenuItemUI.r.height;
        }
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
            return r.getSize();
        }
        return new Dimension(MetalMenuItemUI.r.height, MetalMenuItemUI.r.width);
    }

    public void update(Graphics g2, JComponent c2) {
        this.paint(g2, c2);
    }

    public void paint(Graphics g2, JComponent c2) {
        this.paintMenuItem(g2, c2, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap);
    }

    protected void paintMenuItem(Graphics g2, JComponent c2, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        JMenuItem b2 = (JMenuItem)c2;
        ButtonModel model = b2.getModel();
        int menuWidth = 0;
        int menuHeight = 0;
        if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
            menuWidth = b2.getWidth();
            menuHeight = b2.getHeight();
        } else {
            menuWidth = b2.getHeight();
            menuHeight = b2.getWidth();
            Graphics2D g2d = (Graphics2D)g2;
            AffineTransform oldAt = g2d.getTransform();
            g2d.rotate(1.5707963267948966);
            g2d.translate(0, -menuHeight + 1);
        }
        Insets i2 = c2.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, menuWidth, menuHeight);
        MetalMenuItemUI.viewRect.x += i2.left;
        MetalMenuItemUI.viewRect.y += i2.top;
        MetalMenuItemUI.viewRect.width -= i2.right + MetalMenuItemUI.viewRect.x;
        MetalMenuItemUI.viewRect.height -= i2.bottom + MetalMenuItemUI.viewRect.y;
        Font holdf = g2.getFont();
        Font f2 = c2.getFont();
        g2.setFont(f2);
        FontMetrics fm = g2.getFontMetrics(f2);
        FontMetrics fmAccel = g2.getFontMetrics(this.acceleratorFont);
        KeyStroke accelerator = b2.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = acceleratorText + this.acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? acceleratorText + KeyEvent.getKeyText(keyCode) : acceleratorText + accelerator.getKeyChar();
        }
        String text2 = this.layoutMenuItem(fm, b2.getText(), fmAccel, acceleratorText, b2.getIcon(), checkIcon, arrowIcon, b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, b2.getText() == null ? 0 : defaultTextIconGap, defaultTextIconGap, this.getIconPaddings(b2));
        this.paintBackground(g2, b2, background);
        Color holdc = g2.getColor();
        if (checkIcon != null) {
            if (model.isArmed() || c2 instanceof JMenu && model.isSelected()) {
                g2.setColor(foreground);
            } else {
                g2.setColor(holdc);
            }
            if (this.useCheckAndArrow()) {
                checkIcon.paintIcon(c2, g2, MetalMenuItemUI.checkIconRect.x, MetalMenuItemUI.checkIconRect.y);
            }
            g2.setColor(holdc);
        }
        if (b2.getIcon() != null) {
            Icon icon;
            if (!model.isEnabled()) {
                icon = b2.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = b2.getPressedIcon();
                if (icon == null) {
                    icon = b2.getIcon();
                }
            } else {
                icon = b2.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(c2, g2, MetalMenuItemUI.iconRect.x, MetalMenuItemUI.iconRect.y);
            }
        }
        if (text2 != null) {
            View v2 = (View)c2.getClientProperty("html");
            if (v2 != null) {
                v2.paint(g2, textRect);
            } else {
                this.paintText(g2, b2, textRect, text2);
            }
        }
        if (acceleratorText != null && !acceleratorText.equals("")) {
            int accOffset = 0;
            Container parent = this.menuItem.getParent();
            if (parent != null && parent instanceof JComponent) {
                JComponent p2 = (JComponent)parent;
                Integer maxValueInt = (Integer)p2.getClientProperty(MAX_ACC_WIDTH);
                int maxValue = maxValueInt != null ? maxValueInt : MetalMenuItemUI.acceleratorRect.width;
                accOffset = maxValue - MetalMenuItemUI.acceleratorRect.width;
            }
            g2.setFont(this.acceleratorFont);
            if (!model.isEnabled()) {
                if (this.disabledForeground != null) {
                    g2.setColor(this.disabledForeground);
                    JideSwingUtilities.drawString(this.menuItem, g2, acceleratorText, MetalMenuItemUI.acceleratorRect.x - accOffset, MetalMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
                } else {
                    g2.setColor(b2.getBackground().brighter());
                    JideSwingUtilities.drawString(this.menuItem, g2, acceleratorText, MetalMenuItemUI.acceleratorRect.x - accOffset, MetalMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
                    g2.setColor(b2.getBackground().darker());
                    JideSwingUtilities.drawString(this.menuItem, g2, acceleratorText, MetalMenuItemUI.acceleratorRect.x - accOffset - 1, MetalMenuItemUI.acceleratorRect.y + fmAccel.getAscent() - 1);
                }
            } else {
                if (model.isArmed() || c2 instanceof JMenu && model.isSelected()) {
                    g2.setColor(this.acceleratorSelectionForeground);
                } else {
                    g2.setColor(this.acceleratorForeground);
                }
                JideSwingUtilities.drawString(this.menuItem, g2, acceleratorText, MetalMenuItemUI.acceleratorRect.x - accOffset, MetalMenuItemUI.acceleratorRect.y + fmAccel.getAscent());
            }
        }
        if (arrowIcon != null) {
            if (model.isArmed() || c2 instanceof JMenu && model.isSelected()) {
                g2.setColor(foreground);
            }
            if (this.useCheckAndArrow()) {
                arrowIcon.paintIcon(c2, g2, MetalMenuItemUI.arrowIconRect.x, MetalMenuItemUI.arrowIconRect.y);
            }
        }
        g2.setColor(holdc);
        g2.setFont(holdf);
    }

    private int[] getIconPaddings(JMenuItem b2) {
        int[] subFlags = new int[]{0, 0};
        if (b2 != null && b2.getParent() instanceof JPopupMenu) {
            JPopupMenu parentMenu = (JPopupMenu)b2.getParent();
            for (MenuElement item : parentMenu.getSubElements()) {
                if (item instanceof JCheckBoxMenuItem) {
                    subFlags[0] = 10;
                }
                if (!(item instanceof JMenuItem) || ((JMenuItem)item).getIcon() == null) continue;
                subFlags[1] = Math.max(subFlags[1], ((JMenuItem)item).getIcon().getIconWidth());
            }
        }
        return subFlags;
    }

    protected void paintBackground(Graphics g2, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g2.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        if (menuItem.isOpaque()) {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g2.setColor(bgColor);
                g2.fillRect(0, 0, menuWidth, menuHeight);
            } else {
                g2.setColor(menuItem.getBackground());
                g2.fillRect(0, 0, menuWidth, menuHeight);
            }
            g2.setColor(oldColor);
        }
    }

    protected void paintText(Graphics g2, JMenuItem menuItem, Rectangle textRect, String text2) {
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = g2.getFontMetrics();
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        if (!model.isEnabled()) {
            if (UIDefaultsLookup.get("MenuItem.disabledForeground") instanceof Color) {
                g2.setColor(UIDefaultsLookup.getColor("MenuItem.disabledForeground"));
                JideSwingUtilities.drawStringUnderlineCharAt(menuItem, g2, text2, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            } else {
                g2.setColor(menuItem.getBackground().brighter());
                JideSwingUtilities.drawStringUnderlineCharAt(menuItem, g2, text2, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                g2.setColor(menuItem.getBackground().darker());
                JideSwingUtilities.drawStringUnderlineCharAt(menuItem, g2, text2, mnemIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
            }
        } else {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g2.setColor(this.selectionForeground);
            }
            JideSwingUtilities.drawStringUnderlineCharAt(menuItem, g2, text2, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    private String layoutMenuItem(FontMetrics fm, String text2, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int menuItemGap, int[] iconPaddings) {
        if (icon != null && (icon.getIconHeight() == 0 || icon.getIconWidth() == 0)) {
            icon = null;
        }
        viewRect.width -= this.getRightMargin();
        String newText = SwingUtilities.layoutCompoundLabel(this.menuItem, fm, text2, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewRect, iconRect, textRect, textIconGap);
        if (this.getRightMargin() > 0) {
            text2 = newText;
        }
        viewRect.width += this.getRightMargin();
        if (acceleratorText == null || acceleratorText.equals("")) {
            acceleratorRect.height = 0;
            acceleratorRect.width = 0;
            acceleratorText = "";
        } else {
            acceleratorRect.width = SwingUtilities.computeStringWidth(fmAccel, acceleratorText);
            acceleratorRect.height = fmAccel.getHeight();
        }
        if (this.useCheckAndArrow()) {
            if (checkIcon != null) {
                checkIconRect.width = checkIcon.getIconWidth();
                checkIconRect.height = checkIcon.getIconHeight();
            } else {
                checkIconRect.height = 0;
                checkIconRect.width = 0;
            }
            if (arrowIcon != null) {
                arrowIconRect.width = arrowIcon.getIconWidth();
                arrowIconRect.height = arrowIcon.getIconHeight();
            } else {
                arrowIconRect.height = 0;
                arrowIconRect.width = 0;
            }
        }
        Rectangle labelRect = iconRect.union(textRect);
        if (this.menuItem.getComponentOrientation().isLeftToRight()) {
            if (this.getRightMargin() == 0) {
                textRect.x += menuItemGap;
                iconRect.x += menuItemGap;
            }
            acceleratorRect.x = viewRect.x + viewRect.width - arrowIconRect.width - menuItemGap - acceleratorRect.width;
            if (this.useCheckAndArrow()) {
                checkIconRect.x = viewRect.x + menuItemGap;
                textRect.x += menuItemGap + checkIconRect.width;
                iconRect.x += menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + viewRect.width - menuItemGap - arrowIconRect.width;
            }
        } else {
            if (this.getRightMargin() == 0) {
                textRect.x -= menuItemGap;
                iconRect.x -= menuItemGap;
            }
            acceleratorRect.x = viewRect.x + arrowIconRect.width + menuItemGap;
            if (this.useCheckAndArrow()) {
                checkIconRect.x = viewRect.x + viewRect.width - menuItemGap - checkIconRect.width;
                textRect.x -= menuItemGap + checkIconRect.width;
                iconRect.x -= menuItemGap + checkIconRect.width;
                arrowIconRect.x = viewRect.x + menuItemGap;
            }
        }
        acceleratorRect.y = labelRect.y + labelRect.height / 2 - acceleratorRect.height / 2;
        if (this.useCheckAndArrow()) {
            arrowIconRect.y = labelRect.y + labelRect.height / 2 - arrowIconRect.height / 2;
            checkIconRect.y = labelRect.y + labelRect.height / 2 - checkIconRect.height / 2;
        }
        if (checkIcon == null && iconPaddings[0] > 0) {
            iconRect.x += iconPaddings[0];
            textRect.x += iconPaddings[0];
            acceleratorRect.x += iconPaddings[0];
        }
        if (icon == null && iconPaddings[1] > 0) {
            textRect.x += iconPaddings[1] + this.defaultTextIconGap;
            acceleratorRect.x += iconPaddings[1] + this.defaultTextIconGap;
        }
        return text2;
    }

    private boolean useCheckAndArrow() {
        boolean b2 = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            b2 = false;
        }
        return b2;
    }

    public MenuElement[] getPath() {
        MenuElement[] newPath;
        MenuSelectionManager m2 = MenuSelectionManager.defaultManager();
        MenuElement[] oldPath = m2.getSelectedPath();
        int i2 = oldPath.length;
        if (i2 == 0) {
            return new MenuElement[0];
        }
        Container parent = this.menuItem.getParent();
        if (oldPath[i2 - 1].getComponent() == parent) {
            newPath = new MenuElement[i2 + 1];
            System.arraycopy(oldPath, 0, newPath, 0, i2);
            newPath[i2] = this.menuItem;
        } else {
            int j2;
            for (j2 = oldPath.length - 1; j2 >= 0 && oldPath[j2].getComponent() != parent; --j2) {
            }
            newPath = new MenuElement[j2 + 2];
            System.arraycopy(oldPath, 0, newPath, 0, j2 + 1);
            newPath[j2 + 1] = this.menuItem;
        }
        return newPath;
    }

    void printMenuElementArray(MenuElement[] path, boolean dumpStack) {
        System.out.println("Path is(");
        int j2 = path.length;
        for (int i2 = 0; i2 < j2; ++i2) {
            for (int k2 = 0; k2 <= i2; ++k2) {
                System.out.print("  ");
            }
            MenuElement me = path[i2];
            if (me instanceof JMenuItem) {
                System.out.println(((JMenuItem)me).getText() + ", ");
                continue;
            }
            if (me == null) {
                System.out.println("NULL , ");
                continue;
            }
            System.out.println("" + me + ", ");
        }
        System.out.println(")");
        if (dumpStack) {
            Thread.dumpStack();
        }
    }

    protected void doClick(MenuSelectionManager msm) {
        if (msm == null) {
            msm = MenuSelectionManager.defaultManager();
        }
        msm.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    private boolean isInternalFrameSystemMenu() {
        String actionCommand = this.menuItem.getActionCommand();
        return actionCommand.equals("Close") || actionCommand.equals("Minimize") || actionCommand.equals("Restore") || actionCommand.equals("Maximize");
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    protected boolean isDownArrowVisible(Container c2) {
        if (c2 instanceof TopLevelMenuContainer && ((TopLevelMenuContainer)((Object)c2)).isMenuBar()) {
            return false;
        }
        if (c2 instanceof TopLevelMenuContainer && !((TopLevelMenuContainer)((Object)c2)).isMenuBar()) {
            return true;
        }
        return !(c2 instanceof JMenuBar);
    }

    protected int getRightMargin() {
        return 0;
    }

    private static class ClickAction
    extends AbstractAction {
        private ClickAction() {
        }

        public void actionPerformed(ActionEvent e2) {
            JMenuItem mi = (JMenuItem)e2.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            mi.doClick();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e2) {
            String name = e2.getPropertyName();
            if (name.equals("labelFor") || name.equals("displayedMnemonic") || name.equals("accelerator")) {
                MetalMenuItemUI.this.updateAcceleratorBinding();
            } else if (name.equals("text") || "font".equals(name) || "foreground".equals(name)) {
                JMenuItem lbl = (JMenuItem)e2.getSource();
                String text2 = lbl.getText();
                BasicHTML.updateRenderer(lbl, text2);
            }
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private MenuKeyHandler() {
        }

        public void menuKeyTyped(MenuKeyEvent e2) {
            if (MetalMenuItemUI.this.menuItem != null && MetalMenuItemUI.this.menuItem.isEnabled()) {
                int key = MetalMenuItemUI.this.menuItem.getMnemonic();
                if (key == 0 || e2.getPath().length != 2) {
                    return;
                }
                if (this.lower((char)key) == this.lower(e2.getKeyChar())) {
                    MenuSelectionManager manager = e2.getMenuSelectionManager();
                    MetalMenuItemUI.this.doClick(manager);
                    e2.consume();
                }
            }
        }

        public void menuKeyPressed(MenuKeyEvent e2) {
        }

        public void menuKeyReleased(MenuKeyEvent e2) {
        }

        private char lower(char keyChar) {
            return Character.toLowerCase(keyChar);
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent e2) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent e2) {
            if (MetalMenuItemUI.this.menuItem != null && MetalMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager manager = e2.getMenuSelectionManager();
                MenuElement[] path = e2.getPath();
                manager.setSelectedPath(path);
            }
        }

        public void menuDragMouseExited(MenuDragMouseEvent e2) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e2) {
            if (MetalMenuItemUI.this.menuItem != null && MetalMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager manager = e2.getMenuSelectionManager();
                Point p2 = e2.getPoint();
                if (p2.x >= 0 && p2.x < MetalMenuItemUI.this.menuItem.getWidth() && p2.y >= 0 && p2.y < MetalMenuItemUI.this.menuItem.getHeight()) {
                    MetalMenuItemUI.this.doClick(manager);
                } else {
                    manager.clearSelectedPath();
                }
            }
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e2) {
        }

        public void mousePressed(MouseEvent e2) {
        }

        public void mouseReleased(MouseEvent e2) {
            if (!SwingUtilities.isLeftMouseButton(e2)) {
                return;
            }
            if (MetalMenuItemUI.this.menuItem != null && MetalMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                Point p2 = e2.getPoint();
                if (p2.x >= 0 && p2.x < MetalMenuItemUI.this.menuItem.getWidth() && p2.y >= 0 && p2.y < MetalMenuItemUI.this.menuItem.getHeight()) {
                    MetalMenuItemUI.this.doClick(manager);
                } else {
                    manager.processMouseEvent(e2);
                }
            }
        }

        public void mouseEntered(MouseEvent e2) {
            if (MetalMenuItemUI.this.menuItem != null && MetalMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                int modifiers = e2.getModifiers();
                if ((modifiers & 0x1C) != 0) {
                    MenuSelectionManager.defaultManager().processMouseEvent(e2);
                } else {
                    manager.setSelectedPath(MetalMenuItemUI.this.getPath());
                }
            }
        }

        public void mouseExited(MouseEvent e2) {
            if (MetalMenuItemUI.this.menuItem != null && MetalMenuItemUI.this.menuItem.isEnabled()) {
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                int modifiers = e2.getModifiers();
                if ((modifiers & 0x1C) != 0) {
                    MenuSelectionManager.defaultManager().processMouseEvent(e2);
                } else {
                    MenuElement[] path = manager.getSelectedPath();
                    if (path.length > 1) {
                        MenuElement[] newPath = new MenuElement[path.length - 1];
                        int c2 = path.length - 1;
                        for (int i2 = 0; i2 < c2; ++i2) {
                            newPath[i2] = path[i2];
                        }
                        manager.setSelectedPath(newPath);
                    }
                }
            }
        }

        public void mouseDragged(MouseEvent e2) {
            MenuSelectionManager.defaultManager().processMouseEvent(e2);
        }

        public void mouseMoved(MouseEvent e2) {
        }
    }
}

