/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import com.jidesoft.plaf.metal.MetalUtils;
import com.jidesoft.swing.TristateButtonModel;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

public class MetalIconFactory
implements Serializable {
    private static Icon checkBoxIcon;

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxIcon() {
        }

        protected int getControlSize() {
            return 13;
        }

        private void paintOceanIcon(Component c2, Graphics g2, int x2, int y2) {
            ButtonModel model = ((JCheckBox)c2).getModel();
            g2.translate(x2, y2);
            int w2 = this.getIconWidth();
            int h2 = this.getIconHeight();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed()) {
                    g2.setColor(MetalLookAndFeel.getControlShadow());
                    g2.fillRect(0, 0, w2, h2);
                    g2.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g2.fillRect(0, 0, w2, 2);
                    g2.fillRect(0, 2, 2, h2 - 2);
                    g2.fillRect(w2 - 1, 1, 1, h2 - 1);
                    g2.fillRect(1, h2 - 1, w2 - 2, 1);
                } else if (model.isRollover()) {
                    MetalUtils.drawGradient(c2, g2, "CheckBox.gradient", 0, 0, w2, h2, true);
                    g2.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g2.drawRect(0, 0, w2 - 1, h2 - 1);
                    g2.setColor(MetalLookAndFeel.getPrimaryControl());
                    g2.drawRect(1, 1, w2 - 3, h2 - 3);
                    g2.drawRect(2, 2, w2 - 5, h2 - 5);
                } else {
                    MetalUtils.drawGradient(c2, g2, "CheckBox.gradient", 0, 0, w2, h2, true);
                    g2.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g2.drawRect(0, 0, w2 - 1, h2 - 1);
                }
                g2.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                g2.setColor(MetalLookAndFeel.getControlDarkShadow());
                g2.drawRect(0, 0, w2 - 1, h2 - 1);
            }
            g2.translate(-x2, -y2);
            if (model instanceof TristateButtonModel && ((TristateButtonModel)model).isMixed()) {
                this.drawSquare(c2, g2, x2, y2);
            } else if (model.isSelected()) {
                this.drawCheck(c2, g2, x2, y2);
            }
        }

        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
                this.paintOceanIcon(c2, g2, x2, y2);
                return;
            }
            ButtonModel model = ((JCheckBox)c2).getModel();
            int controlSize = this.getControlSize();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed()) {
                    g2.setColor(MetalLookAndFeel.getControlShadow());
                    g2.fillRect(x2, y2, controlSize - 1, controlSize - 1);
                    MetalUtils.drawPressed3DBorder(g2, x2, y2, controlSize, controlSize);
                } else {
                    MetalUtils.drawFlush3DBorder(g2, x2, y2, controlSize, controlSize);
                }
                g2.setColor(c2.getForeground());
            } else {
                g2.setColor(MetalLookAndFeel.getControlShadow());
                g2.drawRect(x2, y2, controlSize - 2, controlSize - 2);
            }
            if (model instanceof TristateButtonModel && ((TristateButtonModel)model).isMixed()) {
                this.drawSquare(c2, g2, x2, y2);
            } else if (model.isSelected()) {
                this.drawCheck(c2, g2, x2, y2);
            }
        }

        protected void drawCheck(Component c2, Graphics g2, int x2, int y2) {
            int controlSize = this.getControlSize();
            g2.fillRect(x2 + 3, y2 + 5, 2, controlSize - 8);
            g2.drawLine(x2 + (controlSize - 4), y2 + 3, x2 + 5, y2 + (controlSize - 6));
            g2.drawLine(x2 + (controlSize - 4), y2 + 4, x2 + 5, y2 + (controlSize - 5));
        }

        protected void drawSquare(Component c2, Graphics g2, int x2, int y2) {
            int controlSize = this.getControlSize();
            g2.fillRect(x2 + 3, y2 + 3, controlSize - 6, controlSize - 6);
        }

        public int getIconWidth() {
            return this.getControlSize();
        }

        public int getIconHeight() {
            return this.getControlSize();
        }
    }
}

