/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import com.jidesoft.plaf.metal.MetalBumps;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;

class BumpBuffer {
    static final int IMAGE_SIZE = 64;
    static Dimension imageSize = new Dimension(64, 64);
    transient Image image;
    Color topColor;
    Color shadowColor;
    Color backColor;
    private GraphicsConfiguration gc;

    public BumpBuffer(GraphicsConfiguration gc2, Color aTopColor, Color aShadowColor, Color aBackColor) {
        this.gc = gc2;
        this.topColor = aTopColor;
        this.shadowColor = aShadowColor;
        this.backColor = aBackColor;
        this.createImage();
        this.fillBumpBuffer();
    }

    public boolean hasSameConfiguration(GraphicsConfiguration gc2, Color aTopColor, Color aShadowColor, Color aBackColor) {
        if (this.gc != null ? !this.gc.equals(gc2) : gc2 != null) {
            return false;
        }
        if (this.backColor != null ? !this.backColor.equals(aBackColor) : aBackColor != null) {
            return false;
        }
        if (this.shadowColor != null ? !this.shadowColor.equals(aShadowColor) : aShadowColor != null) {
            return false;
        }
        return !(this.topColor != null ? !this.topColor.equals(aTopColor) : aTopColor != null);
    }

    public Image getImage() {
        return this.image;
    }

    public Dimension getImageSize() {
        return imageSize;
    }

    private void fillBumpBuffer() {
        int y2;
        int x2;
        Graphics g2 = this.image.getGraphics();
        g2.setColor(this.backColor);
        g2.fillRect(0, 0, 64, 64);
        g2.setColor(this.topColor);
        for (x2 = 0; x2 < 64; x2 += 4) {
            for (y2 = 0; y2 < 64; y2 += 4) {
                g2.drawLine(x2, y2, x2, y2);
                g2.drawLine(x2 + 2, y2 + 2, x2 + 2, y2 + 2);
            }
        }
        g2.setColor(this.shadowColor);
        for (x2 = 0; x2 < 64; x2 += 4) {
            for (y2 = 0; y2 < 64; y2 += 4) {
                g2.drawLine(x2 + 1, y2 + 1, x2 + 1, y2 + 1);
                g2.drawLine(x2 + 3, y2 + 3, x2 + 3, y2 + 3);
            }
        }
        g2.dispose();
    }

    private void createImage() {
        if (this.gc != null) {
            this.image = this.gc.createCompatibleImage(64, 64, this.backColor != MetalBumps.ALPHA ? 1 : 2);
        } else {
            int[] cmap = new int[]{this.backColor.getRGB(), this.topColor.getRGB(), this.shadowColor.getRGB()};
            IndexColorModel icm = new IndexColorModel(8, 3, cmap, 0, false, this.backColor == MetalBumps.ALPHA ? 0 : -1, 0);
            this.image = new BufferedImage(64, 64, 13, icm);
        }
    }
}

