/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideButtonUI;
import com.jidesoft.plaf.basic.LazyActionMap;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.basic.UIAction;
import com.jidesoft.plaf.vsnet.VsnetMenuUI;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.DefaultSplitButtonModel;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SplitButtonModel;
import com.jidesoft.utils.SecurityUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;

public class BasicJideSplitButtonUI
extends VsnetMenuUI {
    protected ThemePainter _painter;
    protected Color _shadowColor;
    protected Color _darkShadowColor;
    protected Color _highlight;
    protected Color _lightHighlightColor;
    protected int _splitButtonMargin = 12;
    protected int _splitButtonMarginOnMenu = 20;
    protected boolean _isFloatingIcon = false;
    private FocusListener _focusListener;
    private static final String propertyPrefix = "JideSplitButton";

    public static ComponentUI createUI(JComponent x2) {
        return new BasicJideSplitButtonUI();
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._isFloatingIcon = UIDefaultsLookup.getBoolean("Icon.floating");
        this._shadowColor = UIDefaultsLookup.getColor("JideButton.shadow");
        this._darkShadowColor = UIDefaultsLookup.getColor("JideButton.darkShadow");
        this._highlight = UIDefaultsLookup.getColor("JideButton.highlight");
        this._lightHighlightColor = UIDefaultsLookup.getColor("JideButton.light");
        this.menuItem.setRolloverEnabled(true);
        super.installDefaults();
    }

    protected void uninstallDefaults() {
        this._painter = null;
        this._shadowColor = null;
        this._highlight = null;
        this._lightHighlightColor = null;
        this._darkShadowColor = null;
        super.uninstallDefaults();
    }

    protected void installListeners() {
        super.installListeners();
        if (this._focusListener == null) {
            this._focusListener = new FocusListener(){

                public void focusGained(FocusEvent e2) {
                    BasicJideSplitButtonUI.this.menuItem.repaint();
                }

                public void focusLost(FocusEvent e2) {
                    BasicJideSplitButtonUI.this.menuItem.repaint();
                }
            };
        }
        this.menuItem.addFocusListener(this._focusListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this._focusListener != null) {
            this.menuItem.removeFocusListener(this._focusListener);
        }
    }

    static Object getUIOfType(ComponentUI ui, Class clazz) {
        if (clazz.isInstance(ui)) {
            return ui;
        }
        return null;
    }

    public InputMap getInputMap(int condition, JComponent c2) {
        BasicJideSplitButtonUI ui;
        if (condition == 0 && (ui = (BasicJideSplitButtonUI)BasicJideSplitButtonUI.getUIOfType(((JideSplitButton)c2).getUI(), BasicJideSplitButtonUI.class)) != null) {
            return (InputMap)UIDefaultsLookup.get(ui.getPropertyPrefix() + ".focusInputMap");
        }
        return null;
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        JMenuItem b2 = this.menuItem;
        LazyActionMap.installLazyActionMap(b2, BasicJideSplitButtonUI.class, "JideSplitButton.actionMap");
        InputMap km = this.getInputMap(0, b2);
        SwingUtilities.replaceUIInputMap(b2, 0, km);
    }

    protected void uninstallKeyboardActions() {
        JMenuItem b2 = this.menuItem;
        SwingUtilities.replaceUIInputMap(b2, 2, null);
        SwingUtilities.replaceUIInputMap(b2, 0, null);
        SwingUtilities.replaceUIActionMap(b2, null);
        super.uninstallKeyboardActions();
    }

    protected MouseInputListener createMouseInputListener(JComponent c2) {
        return new MouseInputHandler();
    }

    protected void paintBackground(Graphics g2, JMenuItem menuItem, Color bgColor) {
        JideSplitButton b2;
        int menuHeight;
        int menuWidth;
        ButtonModel model = menuItem.getModel();
        int orientation = JideSwingUtilities.getOrientationOf(menuItem);
        if (orientation == 0) {
            menuWidth = menuItem.getWidth();
            menuHeight = menuItem.getHeight();
        } else {
            menuWidth = menuItem.getHeight();
            menuHeight = menuItem.getWidth();
        }
        orientation = 0;
        Object o2 = menuItem.getClientProperty("JideSplitButton.alwaysPaintBackground");
        boolean paintBackground = o2 instanceof Boolean ? ((Boolean)o2).booleanValue() : menuItem.isOpaque();
        if (!((JMenu)menuItem).isTopLevelMenu()) {
            super.paintBackground(g2, menuItem, bgColor);
            if (menuItem.isEnabled()) {
                if (model.isArmed() || model.isPressed() || this.isMouseOver()) {
                    g2.setColor(this.selectionForeground);
                    g2.drawLine(menuWidth - this._splitButtonMarginOnMenu, 0, menuWidth - this._splitButtonMarginOnMenu, menuHeight - 2);
                    JideSwingUtilities.paintArrow(g2, this.selectionForeground, menuWidth - this._splitButtonMarginOnMenu / 2 - 2, menuHeight / 2 - 3, 7, 1);
                } else {
                    g2.setColor(this.getForegroundOfState(menuItem));
                    g2.drawLine(menuWidth - this._splitButtonMarginOnMenu, 0, menuWidth - this._splitButtonMarginOnMenu, menuHeight - 2);
                    JideSwingUtilities.paintArrow(g2, this.getForegroundOfState(menuItem), menuWidth - this._splitButtonMarginOnMenu / 2 - 2, menuHeight / 2 - 3, 7, 1);
                }
            } else {
                g2.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
                g2.drawLine(menuWidth - this._splitButtonMarginOnMenu, 0, menuWidth - this._splitButtonMarginOnMenu, menuHeight - 2);
                JideSwingUtilities.paintArrow(g2, UIDefaultsLookup.getColor("controlDkShadow"), menuWidth - this._splitButtonMarginOnMenu / 2 - 2, menuHeight / 2 - 3, 7, 1);
            }
            return;
        }
        if (paintBackground) {
            if (menuItem.getParent() != null) {
                g2.setColor(menuItem.getParent().getBackground());
            } else {
                g2.setColor(menuItem.getBackground());
            }
            g2.fillRect(0, 0, menuWidth, menuHeight);
        }
        if ((b2 = (JideSplitButton)menuItem).getButtonStyle() == 0) {
            if (model.isSelected()) {
                if (this.isAlwaysDropdown(b2)) {
                    Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 3);
                } else if (b2.getClientProperty("JButton.segmentPosition") != null) {
                    Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    if (b2.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 6);
                    }
                    rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 1);
                } else {
                    Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    if (b2.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 3);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 5);
                    }
                    rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 3);
                    this.getPainter().paintSelectedMenu(b2, g2, new Rectangle(0, 0, menuWidth, menuHeight), orientation, 3);
                }
            } else if (model.isArmed() || model.isPressed()) {
                Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                if (b2.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 1);
                } else if (paintBackground) {
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 4);
                }
                rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
            } else if (model instanceof SplitButtonModel && ((DefaultSplitButtonModel)model).isButtonSelected()) {
                if ((this.isMouseOver() || b2.hasFocus()) && model.isEnabled()) {
                    Rectangle rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    if (b2.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 1);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 4);
                    }
                } else {
                    Rectangle rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 0);
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    if (b2.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 3);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 5);
                    }
                }
            } else if ((b2.isRolloverEnabled() && this.isMouseOver() || b2.hasFocus()) && model.isEnabled()) {
                if (this.isAlwaysDropdown(b2)) {
                    Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                } else {
                    Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    if (b2.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                    } else if (paintBackground) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 6);
                    }
                    rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                }
            } else if (paintBackground) {
                Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                if (b2.isEnabled() && b2.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b2, g2, rect, 0, 0);
                } else {
                    this.getPainter().paintButtonBackground(b2, g2, rect, 0, 4);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillGradient(g2, rect, 0);
                }
                rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                if (b2.isEnabled()) {
                    this.getPainter().paintButtonBackground(b2, g2, rect, 0, 0);
                } else {
                    this.getPainter().paintButtonBackground(b2, g2, rect, 0, 4);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillGradient(g2, rect, 0);
                }
            }
        } else if (b2.getButtonStyle() == 2) {
            if (model.isSelected()) {
                this.getPainter().paintSelectedMenu(b2, g2, new Rectangle(0, 0, menuWidth, menuHeight), orientation, 3);
            } else if (model.isArmed() || model.isPressed()) {
                Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                if (b2.isButtonEnabled()) {
                    JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                }
                rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                if (!b2.isOpaque()) {
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    this.paintSunkenBorder(g2, rect);
                    rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g2, rect);
                }
            } else if (model instanceof SplitButtonModel && ((DefaultSplitButtonModel)model).isButtonSelected()) {
                if ((this.isMouseOver() || b2.hasFocus()) && model.isEnabled()) {
                    Rectangle rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    if (b2.isButtonEnabled()) {
                        JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                    }
                    if (!b2.isOpaque()) {
                        rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                        this.paintSunkenBorder(g2, rect);
                        rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                        this.paintRaisedBorder(g2, rect);
                    }
                } else {
                    Rectangle rect;
                    if (b2.isOpaque()) {
                        rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                        JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                    }
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                    if (!b2.isOpaque()) {
                        rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                        this.paintSunkenBorder(g2, rect);
                    }
                }
            } else if ((b2.isRolloverEnabled() && this.isMouseOver() || b2.hasFocus()) && model.isEnabled()) {
                Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                if (b2.isButtonEnabled()) {
                    JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                }
                rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                if (this.isAlwaysDropdown(b2)) {
                    rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.paintRaisedBorder(g2, rect);
                } else {
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g2, rect);
                    rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g2, rect);
                }
            } else if (b2.isOpaque()) {
                Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                if (b2.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 0);
                }
                rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 0);
            }
        } else if (b2.getButtonStyle() == 1) {
            if (model.isSelected()) {
                this.getPainter().paintSelectedMenu(b2, g2, new Rectangle(0, 0, menuWidth, menuHeight), orientation, 3);
            } else if (model.isArmed() || model.isPressed()) {
                Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                if (b2.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 1);
                }
                rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                if (!b2.isOpaque()) {
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    this.paintSunken2Border(g2, rect);
                    rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.paintRaisedBorder(g2, rect);
                }
            } else if (model instanceof SplitButtonModel && ((DefaultSplitButtonModel)model).isButtonSelected()) {
                if (this.isMouseOver() && model.isEnabled()) {
                    Rectangle rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    if (b2.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 1);
                    }
                    if (!b2.isOpaque()) {
                        rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                        this.paintSunken2Border(g2, rect);
                        rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                        this.paintRaisedBorder(g2, rect);
                    }
                } else {
                    Rectangle rect;
                    if (b2.isOpaque()) {
                        rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 0);
                    }
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 3);
                    if (!b2.isOpaque()) {
                        rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                        this.paintSunken2Border(g2, rect);
                        rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                        this.paintRaisedBorder(g2, rect);
                    }
                }
            } else if (b2.isRolloverEnabled() && this.isMouseOver() && model.isEnabled()) {
                if (this.isAlwaysDropdown(b2)) {
                    Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                    this.paintRaised2Border(g2, rect);
                } else {
                    Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    if (b2.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                    }
                    rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 2);
                    rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                    this.paintRaised2Border(g2, rect);
                    rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                    this.paintRaised2Border(g2, rect);
                }
            } else if (b2.isOpaque()) {
                Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                if (b2.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 0);
                }
                rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                this.getPainter().paintButtonBackground(b2, g2, rect, orientation, 0);
            } else if (this.isAlwaysDropdown(b2)) {
                Rectangle rect = new Rectangle(0, 0, menuWidth, menuHeight);
                this.paintRaisedBorder(g2, rect);
            } else {
                Rectangle rect = this.getButtonRect(b2, orientation, menuWidth, menuHeight);
                this.paintRaisedBorder(g2, rect);
                rect = this.getDropDownRect(b2, orientation, menuWidth, menuHeight);
                this.paintRaisedBorder(g2, rect);
            }
        }
        this.paintArrow(menuItem, g2);
    }

    protected void paintArrow(JMenuItem menuItem, Graphics g2) {
        int menuHeight;
        int menuWidth;
        int orientation = JideSwingUtilities.getOrientationOf(menuItem);
        if (orientation == 0) {
            menuWidth = menuItem.getWidth();
            menuHeight = menuItem.getHeight();
        } else {
            menuWidth = menuItem.getHeight();
            menuHeight = menuItem.getWidth();
        }
        int startX = menuItem.getComponentOrientation().isLeftToRight() ? menuWidth - 9 : 4;
        if (menuItem.isEnabled()) {
            JideSwingUtilities.paintArrow(g2, this.getForegroundOfState(menuItem), startX, menuHeight / 2 - 1, 5, 0);
        } else {
            JideSwingUtilities.paintArrow(g2, UIDefaultsLookup.getColor("controlShadow"), startX, menuHeight / 2 - 1, 5, 0);
        }
    }

    protected Rectangle getDropDownRect(JComponent c2, int orientation, int width, int height) {
        Object position = c2.getClientProperty("JButton.segmentPosition");
        Rectangle rect = c2.getComponentOrientation().isLeftToRight() ? new Rectangle(width - this._splitButtonMargin - 1 + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), height) : new Rectangle(0, 0, this._splitButtonMargin - this.getOffset(), height);
        if (position != null && !"only".equals(position)) {
            if ("first".equals(position)) {
                if (orientation == 0) {
                    ++rect.width;
                } else {
                    ++rect.height;
                }
            } else if ("middle".equals(position)) {
                if (orientation == 0) {
                    ++rect.width;
                } else {
                    ++rect.height;
                }
            } else if ("last".equals(position)) {
                // empty if block
            }
        }
        return rect;
    }

    protected Rectangle getButtonRect(JComponent c2, int orientation, int width, int height) {
        Rectangle rect = orientation == 0 && c2.getComponentOrientation().isLeftToRight() ? new Rectangle(0, 0, width - this._splitButtonMargin, height) : new Rectangle(this._splitButtonMargin - 1, 0, width - this._splitButtonMargin, height);
        return rect;
    }

    protected void paintSunkenBorder(Graphics g2, Rectangle b2) {
        Color old = g2.getColor();
        g2.setColor(this._shadowColor);
        g2.drawLine(b2.x, b2.y, b2.x + b2.width - 1, b2.y);
        g2.drawLine(b2.x, b2.y, b2.x, b2.y + b2.height - 1);
        g2.setColor(this._lightHighlightColor);
        g2.drawLine(b2.x, b2.y + b2.height - 1, b2.x + b2.width - 1, b2.y + b2.height - 1);
        g2.drawLine(b2.x + b2.width - 1, b2.y, b2.x + b2.width - 1, b2.y + b2.height - 1);
        g2.setColor(old);
    }

    protected void paintSunken2Border(Graphics g2, Rectangle b2) {
        Color old = g2.getColor();
        g2.setColor(this._darkShadowColor);
        g2.drawLine(b2.x, b2.y, b2.x + b2.width - 2, b2.y);
        g2.drawLine(b2.x, b2.y, b2.x, b2.y + b2.height - 2);
        g2.setColor(this._shadowColor);
        g2.drawLine(b2.x + 1, b2.y + 1, b2.x + b2.width - 3, b2.y + 1);
        g2.drawLine(b2.x + 1, b2.y + 1, b2.x + 1, b2.y + b2.height - 3);
        g2.setColor(this._lightHighlightColor);
        g2.drawLine(b2.x, b2.y + b2.height - 1, b2.x + b2.width - 1, b2.y + b2.height - 1);
        g2.drawLine(b2.x + b2.width - 1, b2.x, b2.x + b2.width - 1, b2.y + b2.height - 1);
        g2.setColor(old);
    }

    protected void paintRaised2Border(Graphics g2, Rectangle b2) {
        Color old = g2.getColor();
        g2.setColor(this._lightHighlightColor);
        g2.drawLine(b2.x, b2.y, b2.x + b2.width - 1, b2.y);
        g2.drawLine(b2.x, b2.y, b2.x, b2.y + b2.height - 1);
        g2.setColor(this._shadowColor);
        g2.drawLine(b2.x + 1, b2.y + b2.height - 2, b2.x + b2.width - 2, b2.y + b2.height - 2);
        g2.drawLine(b2.x + b2.width - 2, 1, b2.x + b2.width - 2, b2.y + b2.height - 2);
        g2.setColor(this._darkShadowColor);
        g2.drawLine(b2.x, b2.y + b2.height - 1, b2.x + b2.width - 1, b2.y + b2.height - 1);
        g2.drawLine(b2.x + b2.width - 1, b2.y, b2.x + b2.width - 1, b2.y + b2.height - 1);
        g2.setColor(old);
    }

    protected void paintRaisedBorder(Graphics g2, Rectangle b2) {
        Color old = g2.getColor();
        g2.setColor(this._lightHighlightColor);
        g2.drawLine(b2.x, b2.y, b2.x + b2.width - 1, b2.y);
        g2.drawLine(b2.x, b2.y, b2.x, b2.y + b2.height - 1);
        g2.setColor(this._shadowColor);
        g2.drawLine(b2.x, b2.y + b2.height - 1, b2.x + b2.width - 1, b2.y + b2.height - 1);
        g2.drawLine(b2.x + b2.width - 1, b2.y, b2.x + b2.width - 1, b2.y + b2.height - 1);
        g2.setColor(old);
    }

    public Dimension getPreferredSize(JComponent c2) {
        if (!(c2 instanceof JMenu) || !((JMenu)c2).isTopLevelMenu()) {
            return super.getPreferredSize(c2);
        }
        AbstractButton b2 = (AbstractButton)c2;
        boolean isHorizontal = JideSwingUtilities.getOrientationOf(c2) == 0;
        Dimension d2 = JideSwingUtilities.getPreferredButtonSize(b2, this.defaultTextIconGap, true);
        if (BasicJideButtonUI.shouldWrapText(c2)) {
            if (c2 instanceof JideSplitButton) {
                d2.width += BasicJideSplitButtonUI.getAdjustExtraWidth(b2, b2.getText(), 8);
            }
        } else {
            d2.width += this.getRightMargin();
            if (this.isDownArrowVisible(b2.getParent())) {
                ++d2.width;
            }
        }
        if (isHorizontal) {
            return d2;
        }
        return new Dimension(d2.height, d2.width);
    }

    public Dimension getMinimumSize(JComponent c2) {
        if (!(c2 instanceof JMenu) || !((JMenu)c2).isTopLevelMenu()) {
            return super.getMinimumSize(c2);
        }
        Dimension d2 = this.getPreferredSize(c2);
        View v2 = (View)c2.getClientProperty("html");
        if (v2 != null) {
            if (JideSwingUtilities.getOrientationOf(c2) == 0) {
                d2.width = (int)((float)d2.width - (v2.getPreferredSpan(0) - v2.getMinimumSpan(0)));
            } else {
                d2.height = (int)((float)d2.height - (v2.getPreferredSpan(0) - v2.getMinimumSpan(0)));
            }
        }
        return d2;
    }

    public Dimension getMaximumSize(JComponent c2) {
        if (!(c2 instanceof JMenu) || !((JMenu)c2).isTopLevelMenu()) {
            return super.getMaximumSize(c2);
        }
        Dimension d2 = this.getPreferredSize(c2);
        View v2 = (View)c2.getClientProperty("html");
        if (v2 != null) {
            if (JideSwingUtilities.getOrientationOf(c2) == 0) {
                d2.width = (int)((float)d2.width + (v2.getMaximumSpan(0) - v2.getPreferredSpan(0)));
            } else {
                d2.height = (int)((float)d2.height + (v2.getMaximumSpan(0) - v2.getPreferredSpan(0)));
            }
        }
        return d2;
    }

    protected void paintText(Graphics g2, JMenuItem menuItem, Rectangle textRect, String text2) {
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = g2.getFontMetrics();
        if (!(menuItem instanceof JMenu) || !((JMenu)menuItem).isTopLevelMenu()) {
            int defaultTextIconGap = UIDefaultsLookup.getInt("MenuItem.textIconGap");
            int defaultShadowWidth = UIDefaultsLookup.getInt("MenuItem.shadowWidth");
            if (menuItem.getComponentOrientation().isLeftToRight()) {
                textRect.x = defaultShadowWidth + defaultTextIconGap;
            } else {
                Rectangle2D rectText = fm.getStringBounds(text2, g2);
                textRect.x = (int)((double)(menuItem.getWidth() - defaultShadowWidth - defaultTextIconGap) + rectText.getWidth() + (double)(4 + menuItem.getHeight() / 2 - 1));
            }
        } else if (!menuItem.getComponentOrientation().isLeftToRight() && menuItem.getComponentOrientation().isHorizontal()) {
            Rectangle2D rectText = fm.getStringBounds(text2, g2);
            textRect.x = (int)((double)(menuItem.getWidth() - textRect.x) - rectText.getWidth() + (double)(4 + menuItem.getHeight() / 2 - 1));
        }
        int mnemonicIndex = menuItem.getDisplayedMnemonicIndex();
        if (WindowsLookAndFeel.isMnemonicHidden()) {
            mnemonicIndex = -1;
        }
        Color oldColor = g2.getColor();
        if (!model.isEnabled() || menuItem instanceof JideSplitButton && !((JideSplitButton)menuItem).isButtonEnabled()) {
            if (menuItem.getParent() != null) {
                g2.setColor(menuItem.getParent().getBackground().brighter());
                this.drawStringUnderlineCharAt(menuItem, g2, text2, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
                g2.setColor(menuItem.getParent().getBackground().darker());
            }
            this.drawStringUnderlineCharAt(menuItem, g2, text2, mnemonicIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
        } else {
            Color color = this.getForegroundOfState(menuItem);
            if (color == null || color instanceof UIResource) {
                if (model.isSelected()) {
                    g2.setColor(this.selectionForeground);
                } else {
                    g2.setColor(color);
                }
            } else {
                g2.setColor(color);
            }
            this.drawStringUnderlineCharAt(menuItem, g2, text2, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
        }
        g2.setColor(oldColor);
    }

    private Color getForegroundOfState(JMenuItem menuItem) {
        int state = JideSwingUtilities.getButtonState(menuItem);
        Color foreground = null;
        if (menuItem instanceof ComponentStateSupport) {
            foreground = ((ComponentStateSupport)((Object)menuItem)).getForegroundOfState(state);
        }
        if (foreground == null || foreground instanceof UIResource) {
            foreground = menuItem.getForeground();
        }
        return foreground;
    }

    protected void drawStringUnderlineCharAt(JComponent c2, Graphics g2, String text2, int underlinedIndex, int x2, int y2) {
        JideSwingUtilities.drawStringUnderlineCharAt(c2, g2, text2, underlinedIndex, x2, y2);
    }

    protected void paintIcon(JMenuItem b2, Graphics g2) {
        Icon icon;
        ButtonModel model = b2.getModel();
        if (b2.getIcon() != null && (icon = this.getIcon(b2)) != null) {
            boolean enabled;
            if (!b2.getComponentOrientation().isLeftToRight() && b2.getComponentOrientation().isHorizontal()) {
                BasicJideSplitButtonUI.iconRect.x = b2.getWidth() - BasicJideSplitButtonUI.iconRect.x - icon.getIconWidth() + (4 + b2.getHeight() / 2 - 1);
            }
            boolean bl2 = enabled = model.isEnabled() && (!(model instanceof SplitButtonModel) || ((SplitButtonModel)model).isButtonEnabled());
            if (this.isFloatingIcon() && enabled) {
                if (model.isRollover() && !model.isPressed() && !model.isSelected()) {
                    if (!"true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                        if (icon instanceof ImageIcon) {
                            ImageIcon shadow = IconsFactory.createGrayImage(((ImageIcon)icon).getImage());
                            shadow.paintIcon(b2, g2, BasicJideSplitButtonUI.iconRect.x + 1, BasicJideSplitButtonUI.iconRect.y + 1);
                        } else {
                            ImageIcon shadow = IconsFactory.createGrayImage(b2, icon);
                            shadow.paintIcon(b2, g2, BasicJideSplitButtonUI.iconRect.x + 1, BasicJideSplitButtonUI.iconRect.y + 1);
                        }
                        icon.paintIcon(b2, g2, BasicJideSplitButtonUI.iconRect.x - 1, BasicJideSplitButtonUI.iconRect.y - 1);
                    } else {
                        icon.paintIcon(b2, g2, BasicJideSplitButtonUI.iconRect.x, BasicJideSplitButtonUI.iconRect.y);
                    }
                } else {
                    icon.paintIcon(b2, g2, BasicJideSplitButtonUI.iconRect.x, BasicJideSplitButtonUI.iconRect.y);
                }
            } else {
                icon.paintIcon(b2, g2, BasicJideSplitButtonUI.iconRect.x, BasicJideSplitButtonUI.iconRect.y);
            }
        }
    }

    protected boolean isFloatingIcon() {
        return this._isFloatingIcon;
    }

    protected Icon getIcon(AbstractButton b2) {
        ButtonModel model = b2.getModel();
        Icon icon = b2.getIcon();
        Icon tmpIcon = null;
        if (!model.isEnabled() || !((JideSplitButton)this.menuItem).isButtonEnabled()) {
            tmpIcon = model.isSelected() ? b2.getDisabledSelectedIcon() : b2.getDisabledIcon();
            if (tmpIcon == null) {
                icon = icon instanceof ImageIcon ? IconsFactory.createGrayImage(((ImageIcon)icon).getImage()) : IconsFactory.createGrayImage(b2, icon);
            }
        } else if (model.isPressed() && model.isArmed()) {
            tmpIcon = b2.getPressedIcon();
            if (tmpIcon != null) {
                // empty if block
            }
        } else if (b2.isRolloverEnabled() && model.isRollover()) {
            tmpIcon = model.isSelected() ? b2.getRolloverSelectedIcon() : b2.getRolloverIcon();
        } else if (model.isSelected()) {
            tmpIcon = b2.getSelectedIcon();
        }
        if (tmpIcon != null) {
            icon = tmpIcon;
        }
        return icon;
    }

    protected int getOffset() {
        return 0;
    }

    protected boolean isAlwaysDropdown(JMenuItem menuItem) {
        return menuItem instanceof JideSplitButton && ((JideSplitButton)menuItem).isAlwaysDropdown();
    }

    protected int getRightMargin() {
        return this._splitButtonMargin - 1;
    }

    public static void loadActionMap(LazyActionMap map) {
        map.put(new Actions("pressed"));
        map.put(new Actions("released"));
        map.put(new Actions("downPressed"));
        map.put(new Actions("downReleased"));
    }

    protected void updateMnemonicBinding() {
        super.updateMnemonicBinding();
        int mnemonic = this.menuItem.getModel().getMnemonic();
        if (mnemonic != 0 && this.windowInputMap != null) {
            int[] shortcutKeys = (int[])UIDefaultsLookup.get("Menu.shortcutKeys");
            if (shortcutKeys == null) {
                shortcutKeys = new int[]{8};
            }
            for (int shortcutKey : shortcutKeys) {
                this.windowInputMap.put(KeyStroke.getKeyStroke(mnemonic, shortcutKey, false), "pressed");
                this.windowInputMap.put(KeyStroke.getKeyStroke(mnemonic, shortcutKey, true), "released");
            }
        }
    }

    protected static void downButtonPressed(JMenu menu) {
        MenuElement[] selectedPath;
        MenuSelectionManager manager = MenuSelectionManager.defaultManager();
        if (menu.isTopLevelMenu()) {
            if (menu.isSelected()) {
                manager.clearSelectedPath();
            } else {
                Container cnt = BasicJideSplitButtonUI.getFirstParentMenuElement(menu);
                if (cnt != null && cnt instanceof MenuElement) {
                    ArrayList<Container> parents = new ArrayList<Container>();
                    while (cnt instanceof MenuElement) {
                        parents.add(0, cnt);
                        if (cnt instanceof JPopupMenu) {
                            cnt = (Container)((JPopupMenu)cnt).getInvoker();
                            continue;
                        }
                        cnt = BasicJideSplitButtonUI.getFirstParentMenuElement(cnt);
                    }
                    MenuElement[] me = new MenuElement[parents.size() + 1];
                    for (int i2 = 0; i2 < parents.size(); ++i2) {
                        Container container = (Container)parents.get(i2);
                        me[i2] = (MenuElement)((Object)container);
                    }
                    me[parents.size()] = menu;
                    manager.setSelectedPath(me);
                } else {
                    MenuElement[] me = new MenuElement[]{menu};
                    manager.setSelectedPath(me);
                }
            }
        }
        if ((selectedPath = manager.getSelectedPath()).length > 0 && selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
            if (menu.isTopLevelMenu() || menu.getDelay() == 0) {
                BasicJideSplitButtonUI.appendPath(selectedPath, menu.getPopupMenu());
            } else {
                BasicJideSplitButtonUI.setupPostTimer(menu);
            }
        }
    }

    protected static Container getFirstParentMenuElement(Component comp) {
        for (Container parent = comp.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof MenuElement)) continue;
            return parent;
        }
        return null;
    }

    public static int getAdjustExtraWidth(Component c2, String text2, int extraWidth) {
        String[] lines = BasicJideSplitButtonUI.getWrappedText(text2);
        Font font = c2.getFont();
        FontMetrics fm = c2.getFontMetrics(font);
        int line1Width = fm.stringWidth(lines[0]);
        int line2Width = lines.length <= 1 ? 0 : fm.stringWidth(lines[1]);
        int oldMaxWidth = Math.max(line1Width, line2Width);
        int maxWidth = Math.max(line1Width, line2Width += extraWidth);
        return maxWidth - oldMaxWidth;
    }

    public static String getMaxLengthWord(String text2) {
        if (text2.indexOf(32) == -1) {
            return text2;
        }
        int minDiff = text2.length();
        int minPos = -1;
        int mid = text2.length() / 2;
        int pos = -1;
        while ((pos = text2.indexOf(32, pos + 1)) != -1) {
            int diff = Math.abs(pos - mid);
            if (diff >= minDiff) continue;
            minDiff = diff;
            minPos = pos;
        }
        return minPos >= mid ? text2.substring(0, minPos) : text2.substring(minPos + 1);
    }

    public static String[] getWrappedText(String text2) {
        String[] words = text2.split(" ");
        if (words.length <= 2) {
            return words;
        }
        if (words.length >= 3) {
            int minDiff = text2.length();
            int minPos = -1;
            int pos = -1;
            int mid = text2.length() / 2;
            while ((pos = text2.indexOf(32, pos + 1)) != -1) {
                int diff = Math.abs(pos - mid);
                if (diff >= minDiff) continue;
                minDiff = diff;
                minPos = pos;
            }
            return new String[]{text2.substring(0, minPos), text2.substring(minPos + 1)};
        }
        return words;
    }

    private static class Actions
    extends UIAction {
        private static final String PRESS = "pressed";
        private static final String RELEASE = "released";
        private static final String DOWN_PRESS = "downPressed";
        private static final String DOWN_RELEASE = "downReleased";

        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e2) {
            AbstractButton b2 = (AbstractButton)e2.getSource();
            String key = this.getName();
            if (PRESS.equals(key) && ((JideSplitButton)b2).isAlwaysDropdown()) {
                key = DOWN_PRESS;
            }
            if (PRESS.equals(key)) {
                ButtonModel model = b2.getModel();
                model.setArmed(true);
                model.setPressed(true);
                if (!b2.hasFocus()) {
                    b2.requestFocus();
                }
            } else if (RELEASE.equals(key)) {
                ButtonModel model = b2.getModel();
                model.setPressed(false);
                model.setArmed(false);
            } else if (DOWN_PRESS.equals(key)) {
                BasicJideSplitButtonUI.downButtonPressed((JMenu)b2);
            } else if (DOWN_RELEASE.equals(key)) {
                // empty if block
            }
        }

        public boolean isEnabled(Object sender) {
            return sender == null || !(sender instanceof AbstractButton) || ((AbstractButton)sender).getModel().isEnabled();
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e2) {
            this.cancelMenuIfNecessary(e2);
        }

        public void mousePressed(MouseEvent e2) {
            JMenu menu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            BasicJideSplitButtonUI.this.setMouseOver(true);
            if (!SwingUtilities.isLeftMouseButton(e2)) {
                return;
            }
            if (this.isClickOnButton(e2, menu)) {
                if (((JideSplitButton)BasicJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                    menu.getModel().setArmed(true);
                    menu.getModel().setPressed(true);
                }
                if (!menu.hasFocus() && menu.isRequestFocusEnabled()) {
                    menu.requestFocus();
                }
            } else {
                BasicJideSplitButtonUI.downButtonPressed(menu);
            }
        }

        private boolean isClickOnButton(MouseEvent e2, JMenu menu) {
            if (((JideSplitButton)menu).isAlwaysDropdown()) {
                return false;
            }
            boolean clickOnDropDown = false;
            if (BasicJideButtonUI.shouldWrapText(BasicJideSplitButtonUI.this.menuItem)) {
                int size = 27;
                if (JideSwingUtilities.getOrientationOf(BasicJideSplitButtonUI.this.menuItem) == 0) {
                    if (e2.getPoint().getY() < (double)(menu.getHeight() - size)) {
                        clickOnDropDown = true;
                    }
                } else if (e2.getPoint().getY() < (double)(menu.getHeight() - size)) {
                    clickOnDropDown = true;
                }
            } else {
                int size;
                int n2 = size = ((JMenu)BasicJideSplitButtonUI.this.menuItem).isTopLevelMenu() ? BasicJideSplitButtonUI.this._splitButtonMargin : BasicJideSplitButtonUI.this._splitButtonMarginOnMenu;
                if (JideSwingUtilities.getOrientationOf(BasicJideSplitButtonUI.this.menuItem) == 0) {
                    if (menu.getComponentOrientation().isLeftToRight()) {
                        if (e2.getPoint().getX() < (double)(menu.getWidth() - size)) {
                            clickOnDropDown = true;
                        }
                    } else if (e2.getPoint().getX() >= (double)size) {
                        clickOnDropDown = true;
                    }
                } else if (e2.getPoint().getY() < (double)(menu.getHeight() - size)) {
                    clickOnDropDown = true;
                }
            }
            return clickOnDropDown;
        }

        public void mouseReleased(MouseEvent e2) {
            JMenu menu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            if (!this.isClickOnButton(e2, menu)) {
                BasicJideSplitButtonUI.this.menuItem.getModel().setArmed(false);
                BasicJideSplitButtonUI.this.menuItem.getModel().setPressed(false);
            }
            this.cancelMenuIfNecessary(e2);
        }

        private void cancelMenuIfNecessary(MouseEvent e2) {
            JMenu menu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            if (this.isClickOnButton(e2, menu) && ((JideSplitButton)BasicJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                if (SwingUtilities.isLeftMouseButton(e2)) {
                    menu.getModel().setPressed(false);
                    menu.getModel().setArmed(false);
                } else {
                    menu.getModel().setArmed(false);
                    menu.getModel().setPressed(false);
                }
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                MenuElement[] menuElements = manager.getSelectedPath();
                for (int i2 = menuElements.length - 1; i2 >= 0; --i2) {
                    MenuElement menuElement = menuElements[i2];
                    if (!(menuElement instanceof JPopupMenu) || !((JPopupMenu)menuElement).isAncestorOf(menu)) continue;
                    menu.getModel().setRollover(false);
                    BasicJideSplitButtonUI.this.setMouseOver(false);
                    manager.clearSelectedPath();
                }
            }
        }

        public void mouseEntered(MouseEvent e2) {
            JMenu menu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = manager.getSelectedPath();
            if (!menu.isTopLevelMenu()) {
                if (selectedPath.length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                    if (menu.getDelay() == 0) {
                        BasicJideSplitButtonUI.appendPath(BasicJideSplitButtonUI.this.getPath(), menu.getPopupMenu());
                    } else {
                        manager.setSelectedPath(BasicJideSplitButtonUI.this.getPath());
                        BasicJideSplitButtonUI.setupPostTimer(menu);
                    }
                }
            } else if (selectedPath.length > 0 && selectedPath[0] == menu.getParent()) {
                MenuElement[] newPath = new MenuElement[]{(MenuElement)((Object)menu.getParent()), menu, menu.getPopupMenu()};
                manager.setSelectedPath(newPath);
            }
            if (!SwingUtilities.isLeftMouseButton(e2)) {
                BasicJideSplitButtonUI.this.setMouseOver(true);
            }
            BasicJideSplitButtonUI.this.menuItem.repaint();
        }

        public void mouseExited(MouseEvent e2) {
            BasicJideSplitButtonUI.this.setMouseOver(false);
            BasicJideSplitButtonUI.this.menuItem.repaint();
        }

        public void mouseDragged(MouseEvent e2) {
            JMenu menu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(e2);
        }

        public void mouseMoved(MouseEvent e2) {
            JMenu menu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            if (BasicJideSplitButtonUI.this.menuItem instanceof JideSplitButton) {
                if (this.isClickOnButton(e2, (JMenu)BasicJideSplitButtonUI.this.menuItem)) {
                    ((SplitButtonModel)((JideSplitButton)BasicJideSplitButtonUI.this.menuItem).getModel()).setButtonRollover(true);
                } else {
                    ((SplitButtonModel)((JideSplitButton)BasicJideSplitButtonUI.this.menuItem).getModel()).setButtonRollover(false);
                }
            }
        }
    }
}

