/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.JideButtonUI;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideButtonListener;
import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;

public class BasicJideButtonUI
extends JideButtonUI {
    protected int defaultTextIconGap;
    private int shiftOffset = 0;
    protected int defaultTextShiftOffset;
    private boolean defaults_initialized = false;
    private static final String propertyPrefix = "JideButton.";
    protected ThemePainter _painter;
    protected Color _shadowColor;
    protected Color _darkShadowColor;
    protected Color _highlight;
    protected Color _lightHighlightColor;
    protected Color _focusColor;
    protected boolean _isFloatingIcon = false;
    protected static Rectangle viewRect = new Rectangle();
    protected static Rectangle textRect = new Rectangle();
    protected static Rectangle iconRect = new Rectangle();

    public static ComponentUI createUI(JComponent c2) {
        return new BasicJideButtonUI();
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    public void installUI(JComponent c2) {
        this.installDefaults((AbstractButton)c2);
        this.installListeners((AbstractButton)c2);
        this.installKeyboardActions((AbstractButton)c2);
        BasicHTML.updateRenderer(c2, ((AbstractButton)c2).getText());
    }

    protected void installDefaults(AbstractButton b2) {
        Object o2 = UIDefaultsLookup.get("Theme.painter");
        this._painter = o2 instanceof ThemePainter ? (ThemePainter)o2 : new BasicPainter();
        String pp = this.getPropertyPrefix();
        if (!this.defaults_initialized) {
            this.defaultTextIconGap = UIDefaultsLookup.getInt(pp + "textIconGap");
            this.defaultTextShiftOffset = UIDefaultsLookup.getInt(pp + "textShiftOffset");
            this._focusColor = UIDefaultsLookup.getColor("Button.focus");
            this._shadowColor = UIDefaultsLookup.getColor("JideButton.shadow");
            this._darkShadowColor = UIDefaultsLookup.getColor("JideButton.darkShadow");
            this._highlight = UIDefaultsLookup.getColor("JideButton.highlight");
            this._lightHighlightColor = UIDefaultsLookup.getColor("JideButton.light");
            this.defaults_initialized = true;
        }
        this.updateMargin(b2);
        LookAndFeel.installColorsAndFont(b2, pp + "background", pp + "foreground", pp + "font");
        LookAndFeel.installBorder(b2, pp + "border");
        this._isFloatingIcon = UIDefaultsLookup.getBoolean("Icon.floating");
    }

    protected void installListeners(AbstractButton b2) {
        BasicButtonListener listener = this.createButtonListener(b2);
        if (listener != null) {
            b2.putClientProperty(this, listener);
            b2.addMouseListener(listener);
            b2.addMouseMotionListener(listener);
            b2.addFocusListener(listener);
            b2.addPropertyChangeListener(listener);
            b2.addChangeListener(listener);
        }
    }

    protected void installKeyboardActions(AbstractButton b2) {
        BasicButtonListener listener = (BasicButtonListener)b2.getClientProperty(this);
        if (listener != null) {
            listener.installKeyboardActions(b2);
        }
    }

    public void uninstallUI(JComponent c2) {
        this.uninstallKeyboardActions((AbstractButton)c2);
        this.uninstallListeners((AbstractButton)c2);
        this.uninstallDefaults((AbstractButton)c2);
        BasicHTML.updateRenderer(c2, "");
    }

    protected void uninstallKeyboardActions(AbstractButton b2) {
        BasicButtonListener listener = (BasicButtonListener)b2.getClientProperty(this);
        if (listener != null) {
            listener.uninstallKeyboardActions(b2);
        }
    }

    protected void uninstallListeners(AbstractButton b2) {
        BasicButtonListener listener = (BasicButtonListener)b2.getClientProperty(this);
        b2.putClientProperty(this, null);
        if (listener != null) {
            b2.removeMouseListener(listener);
            b2.removeMouseMotionListener(listener);
            b2.removeFocusListener(listener);
            b2.removeChangeListener(listener);
            b2.removePropertyChangeListener(listener);
        }
    }

    protected void uninstallDefaults(AbstractButton b2) {
        this._painter = null;
        this._focusColor = null;
        this._shadowColor = null;
        this._highlight = null;
        this._lightHighlightColor = null;
        this._darkShadowColor = null;
        this.defaults_initialized = false;
    }

    protected BasicButtonListener createButtonListener(AbstractButton b2) {
        return new BasicJideButtonListener(b2);
    }

    public int getDefaultTextIconGap(AbstractButton b2) {
        return this.defaultTextIconGap;
    }

    protected Color getFocusColor() {
        return this._focusColor;
    }

    public void paint(Graphics g2, JComponent c2) {
        AbstractButton b2 = (AbstractButton)c2;
        boolean isHorizontal = true;
        if (JideSwingUtilities.getOrientationOf(c2) == 1) {
            isHorizontal = false;
        }
        FontMetrics fm = g2.getFontMetrics();
        Insets i2 = c2.getInsets();
        BasicJideButtonUI.viewRect.x = i2.left;
        BasicJideButtonUI.viewRect.y = i2.top;
        BasicJideButtonUI.viewRect.width = b2.getWidth() - (i2.right + BasicJideButtonUI.viewRect.x);
        BasicJideButtonUI.viewRect.height = b2.getHeight() - (i2.bottom + BasicJideButtonUI.viewRect.y);
        BasicJideButtonUI.textRect.height = 0;
        BasicJideButtonUI.textRect.width = 0;
        BasicJideButtonUI.textRect.y = 0;
        BasicJideButtonUI.textRect.x = 0;
        BasicJideButtonUI.iconRect.height = 0;
        BasicJideButtonUI.iconRect.width = 0;
        BasicJideButtonUI.iconRect.y = 0;
        BasicJideButtonUI.iconRect.x = 0;
        this.paintBackground(g2, b2);
        Font f2 = c2.getFont();
        g2.setFont(f2);
        String text2 = JideSwingUtilities.layoutCompoundLabel(c2, fm, b2.getText(), b2.getIcon(), isHorizontal, b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, b2.getText() == null ? 0 : b2.getIconTextGap());
        this.clearTextShiftOffset();
        this.paintIcon(b2, g2);
        Boolean highContrast = UIManager.getBoolean("Theme.highContrast");
        if (highContrast.booleanValue() && JideSwingUtilities.getButtonState(b2) == 1) {
            ++BasicJideButtonUI.textRect.x;
            ++BasicJideButtonUI.textRect.y;
        }
        if (text2 != null && !text2.equals("")) {
            View v2 = (View)c2.getClientProperty("html");
            if (v2 != null) {
                v2.paint(g2, textRect);
            } else {
                this.paintText(g2, b2, textRect, text2);
            }
        }
    }

    protected void paintIcon(AbstractButton b2, Graphics g2) {
        if (b2.getIcon() != null) {
            Icon icon = this.getIcon(b2);
            ButtonModel model = b2.getModel();
            if (icon != null) {
                if (this.isFloatingIcon() && model.isEnabled()) {
                    if (model.isRollover() && !model.isPressed() && !model.isSelected()) {
                        if (!"true".equals(SecurityUtils.getProperty("shadingtheme", "false")) && b2 instanceof JideButton && ((JideButton)b2).getButtonStyle() == 0) {
                            if (icon instanceof ImageIcon) {
                                ImageIcon shadow = IconsFactory.createGrayImage(((ImageIcon)icon).getImage());
                                shadow.paintIcon(b2, g2, BasicJideButtonUI.iconRect.x + 1, BasicJideButtonUI.iconRect.y + 1);
                            } else {
                                ImageIcon shadow = IconsFactory.createGrayImage(b2, icon);
                                shadow.paintIcon(b2, g2, BasicJideButtonUI.iconRect.x + 1, BasicJideButtonUI.iconRect.y + 1);
                            }
                            icon.paintIcon(b2, g2, BasicJideButtonUI.iconRect.x - 1, BasicJideButtonUI.iconRect.y - 1);
                        } else {
                            icon.paintIcon(b2, g2, BasicJideButtonUI.iconRect.x, BasicJideButtonUI.iconRect.y);
                        }
                    } else {
                        icon.paintIcon(b2, g2, BasicJideButtonUI.iconRect.x, BasicJideButtonUI.iconRect.y);
                    }
                } else {
                    icon.paintIcon(b2, g2, BasicJideButtonUI.iconRect.x, BasicJideButtonUI.iconRect.y);
                }
            }
        }
    }

    protected Icon getIcon(AbstractButton b2) {
        ButtonModel model = b2.getModel();
        Icon icon = b2.getIcon();
        Icon tmpIcon = null;
        if (!model.isEnabled()) {
            tmpIcon = model.isSelected() ? b2.getDisabledSelectedIcon() : b2.getDisabledIcon();
            if (tmpIcon == null) {
                icon = icon instanceof ImageIcon ? IconsFactory.createGrayImage(((ImageIcon)icon).getImage()) : IconsFactory.createGrayImage(b2, icon);
            }
        } else if (model.isPressed() && model.isArmed()) {
            tmpIcon = b2.getPressedIcon();
            if (tmpIcon != null) {
                this.clearTextShiftOffset();
            }
        } else if (b2.isRolloverEnabled() && model.isRollover()) {
            tmpIcon = model.isSelected() ? b2.getRolloverSelectedIcon() : b2.getRolloverIcon();
        } else if (model.isSelected()) {
            tmpIcon = b2.getSelectedIcon();
        }
        if (tmpIcon != null) {
            icon = tmpIcon;
        }
        return icon;
    }

    protected boolean isFloatingIcon() {
        return this._isFloatingIcon;
    }

    protected void paintText(Graphics g2, JComponent c2, Rectangle textRect, String text2) {
        AbstractButton b2 = (AbstractButton)c2;
        boolean isHorizontal = true;
        if (JideSwingUtilities.getOrientationOf(c2) == 1) {
            isHorizontal = false;
        }
        ButtonModel model = b2.getModel();
        FontMetrics fm = g2.getFontMetrics();
        int mnemonicIndex = b2.getDisplayedMnemonicIndex();
        if (!isHorizontal) {
            Graphics2D g2d = (Graphics2D)g2.create();
            g2d.rotate(1.5707963267948966);
            g2d.translate(0, -c2.getWidth() + 1);
            if (model.isEnabled()) {
                g2d.setColor(this.getForegroundOfState(b2));
                JideSwingUtilities.drawStringUnderlineCharAt(b2, g2d, text2, mnemonicIndex, textRect.y + this.getTextShiftOffset(), textRect.x + fm.getAscent() + this.getTextShiftOffset());
            } else {
                Color color = UIDefaultsLookup.getColor("Button.disabledForeground");
                g2d.setColor(color == null ? b2.getBackground().darker() : color);
                JideSwingUtilities.drawStringUnderlineCharAt(b2, g2d, text2, mnemonicIndex, textRect.y, textRect.x + fm.getAscent());
            }
            if (b2 instanceof JideButton && ((JideButton)b2).getButtonStyle() == 3 && (((JideButton)b2).isAlwaysShowHyperlink() || b2.getModel().isRollover())) {
                g2.drawLine(textRect.x, textRect.y, textRect.x, textRect.y + textRect.height);
            }
            g2d.dispose();
        } else {
            Color old = g2.getColor();
            if (model.isEnabled()) {
                g2.setColor(this.getForegroundOfState(b2));
                JideSwingUtilities.drawStringUnderlineCharAt(b2, g2, text2, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
            } else {
                Color color = UIDefaultsLookup.getColor("Button.disabledForeground");
                g2.setColor(color == null ? b2.getBackground().darker() : color);
                JideSwingUtilities.drawStringUnderlineCharAt(b2, g2, text2, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            }
            if (b2 instanceof JideButton && ((JideButton)b2).getButtonStyle() == 3 && (((JideButton)b2).isAlwaysShowHyperlink() || b2.getModel().isRollover())) {
                g2.drawLine(textRect.x, textRect.y + textRect.height - 2, textRect.x + textRect.width, textRect.y + textRect.height - 2);
            }
            g2.setColor(old);
        }
    }

    protected Color getForegroundOfState(AbstractButton b2) {
        int state = JideSwingUtilities.getButtonState(b2);
        Color foreground = null;
        if (b2 instanceof ComponentStateSupport) {
            foreground = ((ComponentStateSupport)((Object)b2)).getForegroundOfState(state);
        }
        if (foreground == null || foreground instanceof UIResource) {
            foreground = b2.getForeground();
        }
        return foreground;
    }

    protected void paintText(Graphics g2, AbstractButton b2, Rectangle textRect, String text2) {
        this.paintText(g2, (JComponent)b2, textRect, text2);
    }

    protected void paintBackground(Graphics g2, AbstractButton b2) {
        boolean paintBackground;
        boolean paintDefaultBorder = true;
        Object o2 = b2.getClientProperty("JideButton.paintDefaultBorder");
        if (o2 instanceof Boolean) {
            paintDefaultBorder = (Boolean)o2;
        }
        if (paintBackground = (o2 = b2.getClientProperty("JideButton.alwaysPaintBackground")) instanceof Boolean ? ((Boolean)o2).booleanValue() : b2.isOpaque()) {
            g2.setColor(b2.getBackground());
            g2.fillRect(0, 0, b2.getWidth(), b2.getHeight());
        }
        if (b2.isContentAreaFilled()) {
            if (b2 instanceof JideButton && ((JideButton)b2).getButtonStyle() == 0) {
                Rectangle rect = new Rectangle(0, 0, b2.getWidth(), b2.getHeight());
                int state = JideSwingUtilities.getButtonState(b2);
                if (state != 0) {
                    this.getPainter().paintButtonBackground(b2, g2, rect, 0, state);
                } else if (paintBackground) {
                    this.getPainter().paintButtonBackground(b2, g2, rect, JideSwingUtilities.getOrientationOf(b2), state);
                    if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                        JideSwingUtilities.fillGradient(g2, rect, JideSwingUtilities.getOrientationOf(b2));
                    }
                }
            } else if (b2 instanceof JideButton && ((JideButton)b2).getButtonStyle() == 2) {
                this.paintBackgroundInFlatStyle(g2, b2, paintBackground);
            } else if (b2 instanceof JideButton && ((JideButton)b2).getButtonStyle() == 1) {
                this.paintBackgroundInToolboxStyle(g2, b2, paintBackground, paintDefaultBorder);
            }
        }
    }

    private void paintBackgroundInFlatStyle(Graphics g2, AbstractButton b2, boolean paintBackground) {
        Rectangle rect = new Rectangle(0, 0, b2.getWidth(), b2.getHeight());
        int state = JideSwingUtilities.getButtonState(b2);
        switch (state) {
            case 3: {
                JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                g2.setColor(this._shadowColor);
                g2.drawLine(rect.x, rect.y, rect.width - 1, rect.y);
                g2.drawLine(rect.x, rect.y, rect.x, rect.height - 1);
                g2.setColor(this._lightHighlightColor);
                g2.drawLine(rect.x, rect.height - 1, rect.width - 1, rect.height - 1);
                g2.drawLine(rect.width - 1, rect.y, rect.width - 1, rect.height - 1);
                break;
            }
            case 1: {
                JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                g2.setColor(this._shadowColor);
                g2.drawLine(rect.x, rect.y, rect.width - 1, rect.y);
                g2.drawLine(rect.x, rect.y, rect.x, rect.height - 1);
                g2.setColor(this._lightHighlightColor);
                g2.drawLine(rect.x, rect.height - 1, rect.width - 1, rect.height - 1);
                g2.drawLine(rect.width - 1, rect.y, rect.width - 1, rect.height - 1);
                break;
            }
            case 2: {
                JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                g2.setColor(this._lightHighlightColor);
                g2.drawLine(rect.x, rect.y, rect.width - 1, rect.y);
                g2.drawLine(rect.x, rect.y, rect.x, rect.height - 1);
                g2.setColor(this._shadowColor);
                g2.drawLine(rect.x, rect.height - 1, rect.width - 1, rect.height - 1);
                g2.drawLine(rect.width - 1, rect.y, rect.width - 1, rect.height - 1);
                break;
            }
            case 4: 
            case 5: {
                if (!paintBackground) break;
                JideSwingUtilities.paintBackground(g2, rect, this._highlight, this._highlight);
                g2.setColor(this._lightHighlightColor);
                g2.drawLine(rect.x, rect.y, rect.width - 1, rect.y);
                g2.drawLine(rect.x, rect.y, rect.x, rect.height - 1);
                g2.setColor(this._shadowColor);
                g2.drawLine(rect.x, rect.height - 1, rect.width - 1, rect.height - 1);
                g2.drawLine(rect.width - 1, rect.y, rect.width - 1, rect.height - 1);
                break;
            }
            case 0: {
                if (!paintBackground) break;
                this.getPainter().paintButtonBackground(b2, g2, rect, JideSwingUtilities.getOrientationOf(b2), state);
            }
        }
    }

    private void paintBackgroundInToolboxStyle(Graphics g2, AbstractButton b2, boolean paintBackground, boolean paintDefaultBorder) {
        Rectangle rect = new Rectangle(0, 0, b2.getWidth(), b2.getHeight());
        if (b2.getModel().isPressed()) {
            this.getPainter().paintButtonBackground(b2, g2, rect, JideSwingUtilities.getOrientationOf(b2), 1);
            if (paintDefaultBorder) {
                g2.setColor(this._darkShadowColor);
                g2.drawLine(0, 0, b2.getWidth() - 2, 0);
                g2.drawLine(0, 0, 0, b2.getHeight() - 2);
                g2.setColor(this._shadowColor);
                g2.drawLine(1, 1, b2.getWidth() - 3, 1);
                g2.drawLine(1, 1, 1, b2.getHeight() - 3);
                g2.setColor(this._lightHighlightColor);
                g2.drawLine(0, b2.getHeight() - 1, b2.getWidth() - 1, b2.getHeight() - 1);
                g2.drawLine(b2.getWidth() - 1, 0, b2.getWidth() - 1, b2.getHeight() - 1);
            }
        } else if (b2.getModel().isSelected() && b2.getModel().isRollover()) {
            this.getPainter().paintButtonBackground(b2, g2, rect, JideSwingUtilities.getOrientationOf(b2), 1);
            if (paintDefaultBorder) {
                g2.setColor(this._darkShadowColor);
                g2.drawLine(0, 0, b2.getWidth() - 2, 0);
                g2.drawLine(0, 0, 0, b2.getHeight() - 2);
                g2.setColor(this._shadowColor);
                g2.drawLine(1, 1, b2.getWidth() - 3, 1);
                g2.drawLine(1, 1, 1, b2.getHeight() - 3);
                g2.setColor(this._lightHighlightColor);
                g2.drawLine(0, b2.getHeight() - 1, b2.getWidth() - 1, b2.getHeight() - 1);
                g2.drawLine(b2.getWidth() - 1, 0, b2.getWidth() - 1, b2.getHeight() - 1);
            }
        } else if (b2.getModel().isSelected()) {
            this.getPainter().paintButtonBackground(b2, g2, rect, JideSwingUtilities.getOrientationOf(b2), 3);
            if (paintDefaultBorder) {
                g2.setColor(this._darkShadowColor);
                g2.drawLine(0, 0, b2.getWidth() - 2, 0);
                g2.drawLine(0, 0, 0, b2.getHeight() - 2);
                g2.setColor(this._shadowColor);
                g2.drawLine(1, 1, b2.getWidth() - 3, 1);
                g2.drawLine(1, 1, 1, b2.getHeight() - 3);
                g2.setColor(this._lightHighlightColor);
                g2.drawLine(0, b2.getHeight() - 1, b2.getWidth() - 1, b2.getHeight() - 1);
                g2.drawLine(b2.getWidth() - 1, 0, b2.getWidth() - 1, b2.getHeight() - 1);
            }
        } else if (b2.getModel().isRollover() || b2.hasFocus() && b2.isFocusPainted()) {
            this.getPainter().paintButtonBackground(b2, g2, rect, JideSwingUtilities.getOrientationOf(b2), 2);
            if (paintDefaultBorder) {
                g2.setColor(this._lightHighlightColor);
                g2.drawLine(0, 0, b2.getWidth() - 1, 0);
                g2.drawLine(0, 0, 0, b2.getHeight() - 1);
                g2.setColor(this._shadowColor);
                g2.drawLine(1, b2.getHeight() - 2, b2.getWidth() - 2, b2.getHeight() - 2);
                g2.drawLine(b2.getWidth() - 2, 1, b2.getWidth() - 2, b2.getHeight() - 2);
                g2.setColor(this._darkShadowColor);
                g2.drawLine(0, b2.getHeight() - 1, b2.getWidth() - 1, b2.getHeight() - 1);
                g2.drawLine(b2.getWidth() - 1, 0, b2.getWidth() - 1, b2.getHeight() - 1);
            }
        } else if (paintBackground) {
            this.getPainter().paintButtonBackground(b2, g2, rect, JideSwingUtilities.getOrientationOf(b2), 0);
        } else {
            g2.setColor(this._lightHighlightColor);
            g2.drawLine(0, 0, b2.getWidth() - 1, 0);
            g2.drawLine(0, 0, 0, b2.getHeight() - 1);
            g2.setColor(this._shadowColor);
            g2.drawLine(0, b2.getHeight() - 1, b2.getWidth() - 1, b2.getHeight() - 1);
            g2.drawLine(b2.getWidth() - 1, 0, b2.getWidth() - 1, b2.getHeight() - 1);
        }
        if (paintBackground) {
            g2.setColor(this._lightHighlightColor);
            g2.drawLine(0, 0, b2.getWidth() - 1, 0);
            g2.drawLine(0, 0, 0, b2.getHeight() - 1);
            g2.setColor(this._shadowColor);
            g2.drawLine(0, b2.getHeight() - 1, b2.getWidth() - 1, b2.getHeight() - 1);
            g2.drawLine(b2.getWidth() - 1, 0, b2.getWidth() - 1, b2.getHeight() - 1);
        }
    }

    protected void clearTextShiftOffset() {
        this.shiftOffset = 0;
    }

    protected void setTextShiftOffset() {
        this.shiftOffset = this.defaultTextShiftOffset;
    }

    protected int getTextShiftOffset() {
        return this.shiftOffset;
    }

    public Dimension getMinimumSize(JComponent c2) {
        Dimension d2 = this.getPreferredSize(c2);
        View v2 = (View)c2.getClientProperty("html");
        if (v2 != null) {
            if (JideSwingUtilities.getOrientationOf(c2) == 0) {
                d2.width = (int)((float)d2.width - (v2.getPreferredSpan(0) - v2.getMinimumSpan(0)));
            } else {
                d2.height = (int)((float)d2.height - (v2.getPreferredSpan(0) - v2.getMinimumSpan(0)));
            }
        }
        return d2;
    }

    public Dimension getPreferredSize(JComponent c2) {
        AbstractButton b2 = (AbstractButton)c2;
        Dimension d2 = BasicGraphicsUtils.getPreferredButtonSize(b2, b2.getIconTextGap());
        if (JideSwingUtilities.getOrientationOf(c2) == 0) {
            return d2;
        }
        return new Dimension(d2.height, d2.width);
    }

    public Dimension getMaximumSize(JComponent c2) {
        Dimension d2 = this.getPreferredSize(c2);
        View v2 = (View)c2.getClientProperty("html");
        if (v2 != null) {
            d2.width = (int)((float)d2.width + (v2.getMaximumSpan(0) - v2.getPreferredSpan(0)));
        }
        return d2;
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    protected void updateMargin(AbstractButton b2) {
        String pp = this.getPropertyPrefix();
        if (LookAndFeelFactory.isLnfInUse("javax.swing.plaf.synth.SynthLookAndFeel")) {
            SynthContext sc;
            SynthStyle ss = SynthLookAndFeel.getStyle(b2, Region.BUTTON);
            Insets insets = ss.getInsets(sc = new SynthContext(b2, Region.BUTTON, ss, 0), new InsetsUIResource(0, 0, 0, 0));
            if (insets != null) {
                b2.setMargin(insets);
            }
        } else if (b2.getMargin() == null || b2.getMargin() instanceof UIResource) {
            if (BasicJideButtonUI.shouldWrapText(b2)) {
                b2.setMargin(UIDefaultsLookup.getInsets(pp + "margin.vertical"));
            } else {
                b2.setMargin(UIDefaultsLookup.getInsets(pp + "margin"));
            }
        }
    }

    public static boolean shouldWrapText(Component c2) {
        return false;
    }
}

