/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.hints.FileIntelliHints;
import com.jidesoft.plaf.FolderChooserUI;
import com.jidesoft.plaf.basic.BasicFileSystemTree;
import com.jidesoft.plaf.basic.BasicFileSystemTreeModel;
import com.jidesoft.plaf.basic.BasicFileSystemTreeNode;
import com.jidesoft.plaf.basic.FolderChooserResource;
import com.jidesoft.plaf.basic.FolderToolBar;
import com.jidesoft.plaf.basic.FolderToolBarListener;
import com.jidesoft.plaf.basic.LazyMutableTreeNode;
import com.jidesoft.swing.FolderChooser;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.SelectAllUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import sun.awt.shell.ShellFolder;

public class BasicFolderChooserUI
extends BasicFileChooserUI
implements FolderChooserUI {
    private FolderChooser _folderChooser;
    protected FolderToolBar _toolbar;
    protected JTree _fileSystemTree;
    protected JScrollPane _treeScrollPane;
    protected JButton _approveButton;
    protected JButton _cancelButton;
    protected JTextField _navigationTextField;
    protected JPanel _buttonPanel;
    protected JPanel _navigationPanel;
    private Action _approveSelectionAction = new ApproveSelectionAction();
    public FolderChooserSelectionListener _selectionListener;
    private FolderToolBarListener _folderToolbarListener;

    public BasicFolderChooserUI(FolderChooser chooser) {
        super(chooser);
        BasicFileSystemTreeNode.clearCache();
    }

    public static ComponentUI createUI(JComponent c2) {
        return new BasicFolderChooserUI((FolderChooser)c2);
    }

    public void installComponents(JFileChooser chooser) {
        this._folderChooser = (FolderChooser)chooser;
        JPanel toolBarPanel = new JPanel(new BorderLayout(6, 6));
        toolBarPanel.add((Component)this.createToolbar(), "First");
        toolBarPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JPanel holdingPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(7);
        holdingPanel.setLayout(borderLayout);
        holdingPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 6, 6));
        this._navigationPanel = this.createNavigationPanel();
        holdingPanel.add((Component)this._navigationPanel, "North");
        holdingPanel.add((Component)this.createFileSystemTreePanel(), "Center");
        this._buttonPanel = this.createButtonPanel();
        holdingPanel.add((Component)this._buttonPanel, "South");
        JComponent accessory = chooser.getAccessory();
        if (accessory != null) {
            chooser.add((Component)chooser.getAccessory(), "First");
        }
        chooser.setLayout(new JideBoxLayout(chooser, 1));
        chooser.add((Component)toolBarPanel, "fix");
        chooser.add((Component)holdingPanel, "vary");
        chooser.setFileSelectionMode(1);
        if (this._folderChooser.isNavigationFieldVisible()) {
            this.setNavigationFieldVisible(true);
        } else {
            this.setNavigationFieldVisible(false);
        }
        this.updateView(chooser);
        Runnable runnable = new Runnable(){

            public void run() {
                BasicFolderChooserUI.this._fileSystemTree.requestFocusInWindow();
            }
        };
        SwingUtilities.invokeLater(runnable);
        this._folderChooser.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e2) {
                if (BasicFolderChooserUI.this._folderChooser.getRootPane() != null) {
                    BasicFolderChooserUI.this._folderChooser.getRootPane().setDefaultButton(BasicFolderChooserUI.this._approveButton);
                }
            }
        });
    }

    public Component getDefaultFocusComponent() {
        return this._fileSystemTree;
    }

    protected JPanel createButtonPanel() {
        this._approveButton = new JButton();
        this._approveButton.setAction(this.getApproveSelectionAction());
        this._cancelButton = new JButton();
        this._cancelButton.addActionListener(this.getCancelSelectionAction());
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 0, 0));
        buttonPanel.addButton((AbstractButton)this._approveButton, "AFFIRMATIVE");
        buttonPanel.addButton((AbstractButton)this._cancelButton, "CANCEL");
        return buttonPanel;
    }

    protected JPanel createNavigationPanel() {
        NavigationTextFieldListener navigationTextFieldListener = new NavigationTextFieldListener();
        this._navigationTextField = new JTextField(24);
        SelectAllUtils.install(this._navigationTextField);
        FileIntelliHints fileIntelliHints = new FileIntelliHints(this._navigationTextField);
        fileIntelliHints.setFolderOnly(true);
        fileIntelliHints.setShowFullPath(false);
        fileIntelliHints.setFollowCaret(true);
        this._navigationTextField.addActionListener(navigationTextFieldListener);
        JPanel panel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        panel.setLayout(borderLayout);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        panel.add((Component)this._navigationTextField, "Center");
        return panel;
    }

    public void setNavigationFieldVisible(boolean navigationFieldVisible) {
        this._navigationPanel.setVisible(navigationFieldVisible);
    }

    public void rescanCurrentDirectory(JFileChooser fc) {
        super.rescanCurrentDirectory(fc);
    }

    public void ensureFileIsVisible(JFileChooser fc, File f2) {
        super.ensureFileIsVisible(fc, f2);
        this.ensureFileIsVisible(f2, true);
    }

    protected JComponent createToolbar() {
        this._toolbar = new FolderToolBar(true, this._folderChooser.getRecentList());
        this._folderToolbarListener = new FolderToolBarListener(){
            private Cursor m_oldCursor;

            public void deleteFolderButtonClicked() {
                TreePath path = BasicFolderChooserUI.this._fileSystemTree.getSelectionPaths()[0];
                List selection = this.getSelectedFolders(new TreePath[]{path});
                ResourceBundle resourceBundle = FolderChooserResource.getResourceBundle(Locale.getDefault());
                String text2 = selection.size() > 1 ? MessageFormat.format(resourceBundle.getString("FolderChooser.delete.message2"), selection.size()) : resourceBundle.getString("FolderChooser.delete.message1");
                String title = resourceBundle.getString("FolderChooser.delete.title");
                int result = JOptionPane.showConfirmDialog(BasicFolderChooserUI.this._folderChooser, text2, title, 2, 2);
                if (result == 0) {
                    TreePath parentPath = path.getParentPath();
                    Object parentObject = parentPath.getLastPathComponent();
                    Object deletedObject = path.getLastPathComponent();
                    int index = BasicFolderChooserUI.this._fileSystemTree.getModel().getIndexOfChild(parentObject, deletedObject);
                    for (Object s2 : selection) {
                        File f2 = (File)s2;
                        this.recursiveDelete(f2);
                    }
                    ((BasicFileSystemTreeModel)BasicFolderChooserUI.this._fileSystemTree.getModel()).removePath(path, index, deletedObject);
                    TreePath pathToSelect = parentPath;
                    if (index >= ((MutableTreeNode)parentObject).getChildCount()) {
                        index = ((MutableTreeNode)parentObject).getChildCount() - 1;
                    }
                    if (index > 0) {
                        pathToSelect = parentPath.pathByAddingChild(((MutableTreeNode)parentObject).getChildAt(index));
                    }
                    BasicFolderChooserUI.this._fileSystemTree.setSelectionPath(pathToSelect);
                    BasicFolderChooserUI.this._fileSystemTree.scrollPathToVisible(pathToSelect);
                }
            }

            public final boolean recursiveDelete(File file) {
                if (BasicFolderChooserUI.isFileSystem(file)) {
                    if (file.isDirectory()) {
                        File[] children;
                        for (File f2 : children = FileSystemView.getFileSystemView().getFiles(file, false)) {
                            if (this.recursiveDelete(f2)) continue;
                            return false;
                        }
                        return file.delete();
                    }
                    return file.delete();
                }
                return false;
            }

            public void newFolderButtonClicked() {
                TreePath[] paths = BasicFolderChooserUI.this._fileSystemTree.getSelectionPaths();
                List selection = this.getSelectedFolders(paths);
                if (selection.size() > 1 || selection.size() == 0) {
                    return;
                }
                File parent = (File)selection.get(0);
                ResourceBundle resourceBundle = FolderChooserResource.getResourceBundle(Locale.getDefault());
                String folderName = JOptionPane.showInputDialog(BasicFolderChooserUI.this._folderChooser, resourceBundle.getString("FolderChooser.new.folderName"), resourceBundle.getString("FolderChooser.new.title"), 3);
                if (folderName != null && folderName.trim().length() > 0) {
                    folderName = this.eraseBlankInTheEnd(folderName);
                    File newFolder = new File(parent, folderName);
                    boolean success = newFolder.mkdir();
                    TreePath parentPath = paths[0];
                    boolean isExpanded = BasicFolderChooserUI.this._fileSystemTree.isExpanded(parentPath);
                    if (!isExpanded) {
                        BasicFolderChooserUI.this._fileSystemTree.expandPath(parentPath);
                    }
                    LazyMutableTreeNode parentTreeNode = (LazyMutableTreeNode)parentPath.getLastPathComponent();
                    BasicFileSystemTreeNode child = BasicFileSystemTreeNode.createFileSystemTreeNode(newFolder, BasicFolderChooserUI.this._folderChooser);
                    if (success) {
                        parentTreeNode.clear();
                        int insertIndex = BasicFolderChooserUI.this._fileSystemTree.getModel().getIndexOfChild(parentTreeNode, child);
                        if (insertIndex != -1) {
                            ((BasicFileSystemTreeModel)BasicFolderChooserUI.this._fileSystemTree.getModel()).nodeStructureChanged(parentTreeNode);
                        }
                    }
                    TreePath newPath = parentPath.pathByAddingChild(child);
                    BasicFolderChooserUI.this._fileSystemTree.setSelectionPath(newPath);
                    BasicFolderChooserUI.this._fileSystemTree.scrollPathToVisible(newPath);
                }
            }

            private String eraseBlankInTheEnd(String folderName) {
                char c2;
                int i2;
                for (i2 = folderName.length() - 1; i2 >= 0 && ((c2 = folderName.charAt(i2)) == ' ' || c2 == '\t'); --i2) {
                }
                if (i2 < 0) {
                    return null;
                }
                return folderName.substring(0, i2 + 1);
            }

            public void myDocumentsButtonClicked() {
                File myDocuments = FileSystemView.getFileSystemView().getDefaultDirectory();
                BasicFolderChooserUI.this.ensureFileIsVisible(myDocuments, true);
            }

            public void desktopButtonClicked() {
                File desktop = FileSystemView.getFileSystemView().getHomeDirectory();
                BasicFolderChooserUI.this.ensureFileIsVisible(desktop, true);
            }

            public void refreshButtonClicked() {
                File folder = BasicFolderChooserUI.this._folderChooser.getSelectedFolder();
                BasicFolderChooserUI.this._folderChooser.updateUI();
                while (folder != null) {
                    if (folder.exists()) {
                        BasicFolderChooserUI.this._folderChooser.getUI().ensureFileIsVisible(BasicFolderChooserUI.this._folderChooser, folder);
                        break;
                    }
                    if ((folder = folder.getParentFile()) != null) continue;
                    break;
                }
            }

            public void recentFolderSelected(final File file) {
                new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        this.setWaitCursor(true);
                        try {
                            BasicFolderChooserUI.this.ensureFileIsVisible(file, true);
                        }
                        finally {
                            this.setWaitCursor(false);
                        }
                    }
                }).start();
            }

            private void setWaitCursor(boolean isWait) {
                Window parentWindow = SwingUtilities.getWindowAncestor(BasicFolderChooserUI.this._folderChooser);
                if (isWait) {
                    Cursor hourglassCursor = new Cursor(3);
                    this.m_oldCursor = parentWindow.getCursor();
                    parentWindow.setCursor(hourglassCursor);
                } else if (this.m_oldCursor != null) {
                    parentWindow.setCursor(this.m_oldCursor);
                    this.m_oldCursor = null;
                }
            }

            public List getSelectedFolders() {
                TreePath[] paths = BasicFolderChooserUI.this._fileSystemTree.getSelectionPaths();
                return this.getSelectedFolders(paths);
            }

            public List getSelectedFolders(TreePath[] paths) {
                if (paths == null || paths.length == 0) {
                    return new ArrayList();
                }
                ArrayList<File> folders = new ArrayList<File>(paths.length);
                for (TreePath path : paths) {
                    BasicFileSystemTreeNode f2 = (BasicFileSystemTreeNode)path.getLastPathComponent();
                    folders.add(f2.getFile());
                }
                return folders;
            }
        };
        this._toolbar.addListener(this._folderToolbarListener);
        this.updateToolbarButtons();
        return this._toolbar;
    }

    protected void updateToolbarButtons() {
        TreePath[] selectedFiles;
        TreePath[] treePathArray = selectedFiles = this._fileSystemTree == null ? new TreePath[]{} : this._fileSystemTree.getSelectionPaths();
        if (selectedFiles != null && selectedFiles.length > 0) {
            this._toolbar.enableDelete();
        } else {
            this._toolbar.disableDelete();
        }
        if (selectedFiles != null && selectedFiles.length == 1) {
            this._toolbar.enableNewFolder();
        } else {
            this._toolbar.disableNewFolder();
        }
    }

    private JComponent createFileSystemTreePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this._fileSystemTree = new BasicFileSystemTree(this._folderChooser);
        this.updateMultiSelectionEnabled();
        this._treeScrollPane = new JScrollPane(this._fileSystemTree);
        panel.add(this._treeScrollPane);
        return panel;
    }

    private void updateMultiSelectionEnabled() {
        if (this._folderChooser.isMultiSelectionEnabled()) {
            this._fileSystemTree.getSelectionModel().setSelectionMode(4);
        } else {
            this._fileSystemTree.getSelectionModel().setSelectionMode(1);
        }
    }

    public void uninstallComponents(JFileChooser chooser) {
        chooser.remove(this._treeScrollPane);
        chooser.remove(this._buttonPanel);
    }

    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        this._selectionListener = new FolderChooserSelectionListener();
        this._fileSystemTree.addTreeSelectionListener(this._selectionListener);
        this._fileSystemTree.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -2758050378982771174L;

            public void actionPerformed(ActionEvent e2) {
                if (BasicFolderChooserUI.this._folderToolbarListener != null) {
                    BasicFolderChooserUI.this._folderToolbarListener.refreshButtonClicked();
                }
            }
        }, KeyStroke.getKeyStroke(116, 0), 0);
    }

    protected void uninstallListeners(JFileChooser fc) {
        super.uninstallListeners(fc);
        this._fileSystemTree.removeTreeSelectionListener(this._selectionListener);
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new FolderChooserPropertyChangeListener();
    }

    private void updateView(JFileChooser chooser) {
        if (chooser.getApproveButtonText() != null) {
            this._approveButton.setText(chooser.getApproveButtonText());
            this._approveButton.setMnemonic(chooser.getApproveButtonMnemonic());
        } else if (0 == chooser.getDialogType()) {
            this._approveButton.setText(this.openButtonText);
            this._approveButton.setToolTipText(this.openButtonToolTipText);
            this._approveButton.setMnemonic(this.openButtonMnemonic);
        } else {
            this._approveButton.setText(this.saveButtonText);
            this._approveButton.setToolTipText(this.saveButtonToolTipText);
            this._approveButton.setMnemonic(this.saveButtonMnemonic);
        }
        this._cancelButton.setText(this.cancelButtonText);
        this._cancelButton.setMnemonic(this.cancelButtonMnemonic);
        this._buttonPanel.setVisible(chooser.getControlButtonsAreShown());
        if (this._toolbar != null) {
            Component[] components;
            for (Component component : components = this._toolbar.getComponents()) {
                if (component instanceof JButton) {
                    String name = component.getName();
                    int buttons = this._folderChooser.getAvailableButtons();
                    boolean visible = this._toolbar.isButtonVisible(name, buttons);
                    component.setVisible(visible);
                    continue;
                }
                if (!(component instanceof JComboBox) && !(component instanceof JLabel)) continue;
                component.setVisible(this._folderChooser.isRecentListVisible());
            }
        }
    }

    public static boolean isFileSystem(File f2) {
        if (f2 instanceof ShellFolder) {
            ShellFolder sf = (ShellFolder)f2;
            return sf.isFileSystem() && (!sf.isLink() || !sf.isDirectory());
        }
        return true;
    }

    private TreePath getTreePathForFile(File file) {
        File[] roots;
        if (!file.isDirectory()) {
            return null;
        }
        Stack<File> stack = new Stack<File>();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this._fileSystemTree.getModel().getRoot());
        FileSystemView view = this._folderChooser.getFileSystemView();
        File[] alternativeRoots = null;
        File root = null;
        if (SystemInfo.isWindows() && BasicFolderChooserUI.isFileSystem(root = (roots = view.getRoots())[0]) && root.isDirectory()) {
            alternativeRoots = root.listFiles();
        }
        File parent = file;
        block0: do {
            stack.push(parent);
            if (alternativeRoots == null) continue;
            for (File r2 : alternativeRoots) {
                if (!r2.equals(parent)) continue;
                stack.push(root);
                break block0;
            }
        } while ((parent = this._folderChooser.getFileSystemView().getParentDirectory(parent)) != null);
        while (!stack.empty()) {
            list.add(BasicFileSystemTreeNode.createFileSystemTreeNode((File)stack.pop(), this._folderChooser));
        }
        return new TreePath(list.toArray());
    }

    private void ensureFileIsVisible(File file, boolean scroll) {
        TreePath path;
        TreePath treePath = path = file == null ? new TreePath(this._fileSystemTree.getModel().getRoot()) : this.getTreePathForFile(file);
        if (path != null) {
            this._fileSystemTree.setSelectionPath(path);
            this._fileSystemTree.expandPath(path);
            if (scroll) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        BasicFolderChooserUI.this._fileSystemTree.scrollPathToVisible(path);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    private void setSelectedFiles() {
        TreePath[] selectedPaths = this._fileSystemTree.getSelectionPaths();
        if (selectedPaths == null || selectedPaths.length == 0) {
            this._folderChooser.setSelectedFile(null);
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        int c2 = selectedPaths.length;
        for (int i2 = 0; i2 < c2; ++i2) {
            File f2 = ((BasicFileSystemTreeNode)selectedPaths[i2].getLastPathComponent()).getFile();
            files.add(f2);
        }
        this._folderChooser.setSelectedFiles(files.toArray(new File[files.size()]));
    }

    public Action getApproveSelectionAction() {
        return this._approveSelectionAction;
    }

    private class ApproveSelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = -3465282473768757260L;

        public ApproveSelectionAction() {
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e2) {
            BasicFolderChooserUI.this.setSelectedFiles();
            BasicFolderChooserUI.this._folderChooser.approveSelection();
        }
    }

    private class FolderChooserSelectionListener
    implements TreeSelectionListener {
        private FolderChooserSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e2) {
            TreePath path;
            BasicFolderChooserUI.this.getApproveSelectionAction().setEnabled(BasicFolderChooserUI.this._fileSystemTree.getSelectionCount() > 0);
            if (BasicFolderChooserUI.this._toolbar != null) {
                BasicFolderChooserUI.this.updateToolbarButtons();
            }
            if (BasicFolderChooserUI.this._fileSystemTree.getSelectionCount() > 0 && (path = e2.getNewLeadSelectionPath()) != null) {
                String folderPath = path.getLastPathComponent().toString();
                File folder = new File(folderPath);
                BasicFolderChooserUI.this._folderChooser.setSelectedFolder(folder);
                TreePath treePath = BasicFolderChooserUI.this._fileSystemTree.getSelectionPath();
                if (treePath != null) {
                    BasicFolderChooserUI.this._navigationTextField.setText("" + treePath.getLastPathComponent());
                }
            }
        }
    }

    private class FolderChooserPropertyChangeListener
    implements PropertyChangeListener {
        private FolderChooserPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            block7: {
                Component[] components;
                block15: {
                    Component[] components2;
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block8: {
                                                block6: {
                                                    if (!"recentList".equals(evt.getPropertyName())) break block6;
                                                    BasicFolderChooserUI.this._toolbar.setRecentList((List)evt.getNewValue());
                                                    break block7;
                                                }
                                                if (!"ApproveButtonTextChangedProperty".equals(evt.getPropertyName())) break block8;
                                                BasicFolderChooserUI.this.updateView(BasicFolderChooserUI.this._folderChooser);
                                                break block7;
                                            }
                                            if (!"DialogTypeChangedProperty".equals(evt.getPropertyName())) break block9;
                                            BasicFolderChooserUI.this.updateView(BasicFolderChooserUI.this._folderChooser);
                                            break block7;
                                        }
                                        if (!"MultiSelectionEnabledChangedProperty".equals(evt.getPropertyName())) break block10;
                                        BasicFolderChooserUI.this.updateMultiSelectionEnabled();
                                        break block7;
                                    }
                                    if (!"directoryChanged".equals(evt.getPropertyName())) break block11;
                                    BasicFolderChooserUI.this.ensureFileIsVisible(BasicFolderChooserUI.this._folderChooser.getCurrentDirectory(), true);
                                    break block7;
                                }
                                if (!"AccessoryChangedProperty".equals(evt.getPropertyName())) break block12;
                                Component oldValue = (Component)evt.getOldValue();
                                Component newValue = (Component)evt.getNewValue();
                                if (oldValue != null) {
                                    BasicFolderChooserUI.this._folderChooser.remove(oldValue);
                                }
                                if (newValue != null) {
                                    BasicFolderChooserUI.this._folderChooser.add(newValue, "First");
                                }
                                BasicFolderChooserUI.this._folderChooser.revalidate();
                                BasicFolderChooserUI.this._folderChooser.repaint();
                                break block7;
                            }
                            if (!"ControlButtonsAreShownChangedProperty".equals(evt.getPropertyName())) break block13;
                            BasicFolderChooserUI.this.updateView(BasicFolderChooserUI.this._folderChooser);
                            break block7;
                        }
                        if (!"navigationFieldVisible".equals(evt.getPropertyName())) break block14;
                        if (BasicFolderChooserUI.this._folderChooser.isNavigationFieldVisible()) {
                            BasicFolderChooserUI.this.setNavigationFieldVisible(true);
                        } else {
                            BasicFolderChooserUI.this.setNavigationFieldVisible(false);
                        }
                        break block7;
                    }
                    if (!"availableButtons".equals(evt.getPropertyName())) break block15;
                    for (Component component : components2 = BasicFolderChooserUI.this._toolbar.getComponents()) {
                        if (!(component instanceof JButton)) continue;
                        String name = component.getName();
                        int buttons = BasicFolderChooserUI.this._folderChooser.getAvailableButtons();
                        boolean visible = BasicFolderChooserUI.this._toolbar.isButtonVisible(name, buttons);
                        component.setVisible(visible);
                    }
                    break block7;
                }
                if (!"recentListVisible".equals(evt.getPropertyName())) break block7;
                for (Component component : components = BasicFolderChooserUI.this._toolbar.getComponents()) {
                    if (!(component instanceof JComboBox) && !(component instanceof JLabel)) continue;
                    component.setVisible(BasicFolderChooserUI.this._folderChooser.isRecentListVisible());
                }
            }
        }
    }

    public class NavigationTextFieldListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e2) {
            File file;
            String text2 = BasicFolderChooserUI.this._navigationTextField.getText();
            if (text2 == null || text2.equals("")) {
                return;
            }
            TreePath treePath = BasicFolderChooserUI.this._fileSystemTree.getSelectionPath();
            if (treePath != null && text2.equals("" + treePath.getLastPathComponent())) {
                BasicFolderChooserUI.this._approveButton.doClick(200);
            }
            if ((file = new File(text2)).exists()) {
                BasicFolderChooserUI.this.ensureFileIsVisible(file, true);
                BasicFolderChooserUI.this._folderChooser.setSelectedFolder(file);
            }
        }
    }
}

