/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import com.jidesoft.plaf.aqua.XMLElement;
import com.jidesoft.utils.Base64;
import com.jidesoft.utils.SecurityUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

class BinaryPListParser {
    private int refCount;
    private int offsetCount;
    private int objectCount;
    private int topLevelOffset;
    private ArrayList objectTable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLElement parse(File file) throws IOException {
        RandomAccessFile raf = null;
        byte[] buf = null;
        try {
            raf = new RandomAccessFile(file, "r");
            int bpli = raf.readInt();
            int st00 = raf.readInt();
            if (bpli != 1651534953 || st00 != 1936994352) {
                throw new IOException("parseHeader: File does not start with 'bplist00' magic.");
            }
            raf.seek(raf.length() - 32L);
            this.offsetCount = (int)raf.readLong();
            this.refCount = (int)raf.readLong();
            this.objectCount = (int)raf.readLong();
            this.topLevelOffset = (int)raf.readLong();
            buf = new byte[this.topLevelOffset - 8];
            raf.seek(8L);
            raf.readFully(buf);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
        this.objectTable = new ArrayList();
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new ByteArrayInputStream(buf));
            this.parseObjectTable((DataInputStream)in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        XMLElement root = new XMLElement(new HashMap(), false, false);
        root.setName("plist");
        root.setAttribute("version", "1.0");
        this.convertObjectTableToXML(root, this.objectTable.get(0));
        return root;
    }

    private void convertObjectTableToXML(XMLElement parent, Object object) {
        XMLElement elem = parent.createAnotherElement();
        if (object instanceof BPLDict) {
            BPLDict dict = (BPLDict)object;
            elem.setName("dict");
            for (int i2 = 0; i2 < dict.keyref.length; ++i2) {
                XMLElement key = parent.createAnotherElement();
                key.setName("key");
                key.setContent(dict.getKey(i2));
                elem.addChild(key);
                this.convertObjectTableToXML(elem, dict.getValue(i2));
            }
        } else if (object instanceof BPLArray) {
            BPLArray arr = (BPLArray)object;
            elem.setName("array");
            for (int i3 = 0; i3 < arr.objref.length; ++i3) {
                this.convertObjectTableToXML(elem, arr.getValue(i3));
            }
        } else if (object instanceof String) {
            elem.setName("string");
            elem.setContent((String)object);
        } else if (object instanceof Integer) {
            elem.setName("integer");
            elem.setContent(object.toString());
        } else if (object instanceof Long) {
            elem.setName("integer");
            elem.setContent(object.toString());
        } else if (object instanceof Float) {
            elem.setName("real");
            elem.setContent(object.toString());
        } else if (object instanceof Double) {
            elem.setName("real");
            elem.setContent(object.toString());
        } else if (object instanceof Boolean) {
            elem.setName("boolean");
            elem.setContent(object.toString());
        } else if (object instanceof byte[]) {
            elem.setName("data");
            elem.setContent(Base64.encodeBytes((byte[])object));
        } else if (object instanceof Date) {
            elem.setName("date");
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            elem.setContent(format.format((Date)object));
        } else {
            elem.setName("unsupported");
            elem.setContent(object.toString());
        }
        parent.addChild(elem);
    }

    private void parseObjectTable(DataInputStream in) throws IOException {
        int marker;
        while ((marker = in.read()) != -1) {
            switch ((marker & 0xF0) >> 4) {
                case 0: {
                    this.parsePrimitive(in, marker & 0xF);
                    break;
                }
                case 1: {
                    int count = 1 << (marker & 0xF);
                    this.parseInt(in, count);
                    break;
                }
                case 2: {
                    int count = 1 << (marker & 0xF);
                    this.parseReal(in, count);
                    break;
                }
                case 3: {
                    if ((marker & 0xF) != 3) {
                        throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                    }
                    this.parseDate(in);
                    break;
                }
                case 4: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    this.parseData(in, count);
                    break;
                }
                case 5: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    this.parseAsciiString(in, count);
                    break;
                }
                case 6: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    this.parseUnicodeString(in, count);
                    break;
                }
                case 7: {
                    System.out.println("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                    return;
                }
                case 8: {
                    int count = (marker & 0xF) + 1;
                    System.out.println("uid " + count);
                    break;
                }
                case 9: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                }
                case 10: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    if (this.refCount > 255) {
                        this.parseShortArray(in, count);
                        break;
                    }
                    this.parseByteArray(in, count);
                    break;
                }
                case 11: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                }
                case 12: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                }
                case 13: {
                    int count = marker & 0xF;
                    if (count == 15) {
                        count = this.readCount(in);
                    }
                    if (this.refCount > 256) {
                        this.parseShortDict(in, count);
                        break;
                    }
                    this.parseByteDict(in, count);
                    break;
                }
                case 14: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                }
                case 15: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(marker));
                }
            }
        }
    }

    private int readCount(DataInputStream in) throws IOException {
        int marker = in.read();
        if (marker == -1) {
            throw new IOException("variableLengthInt: Illegal EOF in marker");
        }
        if ((marker & 0xF0) >> 4 != 1) {
            throw new IOException("variableLengthInt: Illegal marker " + Integer.toBinaryString(marker));
        }
        int count = 1 << (marker & 0xF);
        int value = 0;
        for (int i2 = 0; i2 < count; ++i2) {
            int b2 = in.read();
            if (b2 == -1) {
                throw new IOException("variableLengthInt: Illegal EOF in value");
            }
            value = value << 8 | b2;
        }
        return value;
    }

    private void parsePrimitive(DataInputStream in, int primitive) throws IOException {
        switch (primitive) {
            case 0: {
                this.objectTable.add(null);
                break;
            }
            case 8: {
                this.objectTable.add(Boolean.FALSE);
                break;
            }
            case 9: {
                this.objectTable.add(Boolean.TRUE);
                break;
            }
            case 15: {
                break;
            }
            default: {
                throw new IOException("parsePrimitive: illegal primitive " + Integer.toBinaryString(primitive));
            }
        }
    }

    private void parseByteArray(DataInputStream in, int count) throws IOException {
        BPLArray arr = new BPLArray();
        arr.objectTable = this.objectTable;
        arr.objref = new int[count];
        for (int i2 = 0; i2 < count; ++i2) {
            arr.objref[i2] = in.readByte() & 0xFF;
            if (arr.objref[i2] != -1) continue;
            throw new IOException("parseByteArray: illegal EOF in objref*");
        }
        this.objectTable.add(arr);
    }

    private void parseShortArray(DataInputStream in, int count) throws IOException {
        BPLArray arr = new BPLArray();
        arr.objectTable = this.objectTable;
        arr.objref = new int[count];
        for (int i2 = 0; i2 < count; ++i2) {
            arr.objref[i2] = in.readShort() & 0xFFFF;
            if (arr.objref[i2] != -1) continue;
            throw new IOException("parseShortArray: illegal EOF in objref*");
        }
        this.objectTable.add(arr);
    }

    private void parseData(DataInputStream in, int count) throws IOException {
        byte[] data = new byte[count];
        in.readFully(data);
        this.objectTable.add(data);
    }

    private void parseByteDict(DataInputStream in, int count) throws IOException {
        int i2;
        BPLDict dict = new BPLDict();
        dict.objectTable = this.objectTable;
        dict.keyref = new int[count];
        dict.objref = new int[count];
        for (i2 = 0; i2 < count; ++i2) {
            dict.keyref[i2] = in.readByte() & 0xFF;
        }
        for (i2 = 0; i2 < count; ++i2) {
            dict.objref[i2] = in.readByte() & 0xFF;
        }
        this.objectTable.add(dict);
    }

    private void parseShortDict(DataInputStream in, int count) throws IOException {
        int i2;
        BPLDict dict = new BPLDict();
        dict.objectTable = this.objectTable;
        dict.keyref = new int[count];
        dict.objref = new int[count];
        for (i2 = 0; i2 < count; ++i2) {
            dict.keyref[i2] = in.readShort() & 0xFFFF;
        }
        for (i2 = 0; i2 < count; ++i2) {
            dict.objref[i2] = in.readShort() & 0xFFFF;
        }
        this.objectTable.add(dict);
    }

    private void parseAsciiString(DataInputStream in, int count) throws IOException {
        byte[] buf = new byte[count];
        in.readFully(buf);
        String str = new String(buf, "ASCII");
        this.objectTable.add(str);
    }

    private void parseInt(DataInputStream in, int count) throws IOException {
        if (count > 8) {
            throw new IOException("parseInt: unsupported byte count:" + count);
        }
        long value = 0L;
        for (int i2 = 0; i2 < count; ++i2) {
            int b2 = in.read();
            if (b2 == -1) {
                throw new IOException("parseInt: Illegal EOF in value");
            }
            value = value << 8 | (long)b2;
        }
        this.objectTable.add(value);
    }

    private void parseReal(DataInputStream in, int count) throws IOException {
        switch (count) {
            case 4: {
                this.objectTable.add(Float.valueOf(in.readFloat()));
                break;
            }
            case 8: {
                this.objectTable.add(in.readDouble());
                break;
            }
            default: {
                throw new IOException("parseReal: unsupported byte count:" + count);
            }
        }
    }

    private void parseDate(DataInputStream in) throws IOException {
        double date = in.readDouble();
        this.objectTable.add(new Date());
    }

    private void parseUnicodeString(DataInputStream in, int count) throws IOException {
        char[] buf = new char[count];
        for (int i2 = 0; i2 < count; ++i2) {
            buf[i2] = in.readChar();
        }
        String str = new String(buf);
        this.objectTable.add(str);
    }

    public static void main(String[] args) {
        try {
            File[] list = new File(SecurityUtils.getProperty("user.home", ""), "Library/Preferences").listFiles();
            for (int i2 = 0; i2 < list.length; ++i2) {
                String name = list[i2].getName();
                if (list[i2].isDirectory() || !name.endsWith(".plist") || name.endsWith("internetconfig.plist")) continue;
                try {
                    System.out.println(list[i2]);
                    BinaryPListParser bplr = new BinaryPListParser();
                    XMLElement xml2 = bplr.parse(list[i2]);
                    System.out.println(xml2);
                    continue;
                }
                catch (IOException e2) {
                    if (e2.getMessage() != null && (e2.getMessage().startsWith("parseHeader") || e2.getMessage().startsWith("parseTrailer"))) {
                        System.out.println(e2);
                        continue;
                    }
                    throw e2;
                }
            }
        }
        catch (Throwable e3) {
            e3.printStackTrace();
        }
    }

    private static class BPLDict {
        ArrayList objectTable;
        int[] keyref;
        int[] objref;

        private BPLDict() {
        }

        public String getKey(int i2) {
            return this.objectTable.get(this.keyref[i2]).toString();
        }

        public Object getValue(int i2) {
            return this.objectTable.get(this.objref[i2]);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("BPLDict{");
            for (int i2 = 0; i2 < this.keyref.length; ++i2) {
                if (i2 > 0) {
                    buf.append(',');
                }
                if (this.keyref[i2] < 0 || this.keyref[i2] >= this.objectTable.size()) {
                    buf.append("#" + this.keyref[i2]);
                } else if (this.objectTable.get(this.keyref[i2]) == this) {
                    buf.append("*" + this.keyref[i2]);
                } else {
                    buf.append(this.objectTable.get(this.keyref[i2]));
                }
                buf.append(":");
                if (this.objref[i2] < 0 || this.objref[i2] >= this.objectTable.size()) {
                    buf.append("#" + this.objref[i2]);
                    continue;
                }
                if (this.objectTable.get(this.objref[i2]) == this) {
                    buf.append("*" + this.objref[i2]);
                    continue;
                }
                buf.append(this.objectTable.get(this.objref[i2]));
            }
            buf.append('}');
            return buf.toString();
        }
    }

    private static class BPLArray {
        ArrayList objectTable;
        int[] objref;

        private BPLArray() {
        }

        public Object getValue(int i2) {
            return this.objectTable.get(this.objref[i2]);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("Array{");
            for (int i2 = 0; i2 < this.objref.length; ++i2) {
                if (i2 > 0) {
                    buf.append(',');
                }
                if (this.objectTable.size() > this.objref[i2] && this.objectTable.get(this.objref[i2]) != this) {
                    buf.append(this.objectTable.get(this.objref[i2]));
                    continue;
                }
                buf.append("*" + this.objref[i2]);
            }
            buf.append('}');
            return buf.toString();
        }
    }
}

