/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import com.jidesoft.plaf.aqua.AquaJideUtils;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.plaf.vsnet.VsnetJideTabbedPaneUI;
import com.jidesoft.swing.TabColorProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class AquaJideTabbedPaneUI
extends VsnetJideTabbedPaneUI {
    private static final Color COLOR1 = new Color(130, 130, 130);
    private static final Color COLOR2 = new Color(86, 86, 86);
    private static final Color COLOR3 = new Color(252, 252, 252);

    public static ComponentUI createUI(JComponent c2) {
        return new AquaJideTabbedPaneUI();
    }

    protected void paintTabBackground(Graphics g2, int tabPlacement, int tabIndex, int x2, int y2, int w2, int h2, boolean isSelected) {
        Color[] color;
        Component component;
        super.paintTabBackground(g2, tabPlacement, tabIndex, x2, y2, w2, h2, isSelected);
        if (this._tabPane.getTabColorProvider() != null && this._tabPane.getTabColorProvider().getBackgroundAt(tabIndex) != null) {
            return;
        }
        if (tabIndex >= 0 && tabIndex < this._tabPane.getTabCount() && (component = this._tabPane.getComponentAt(tabIndex)) instanceof TabColorProvider && ((TabColorProvider)((Object)component)).getTabBackground() != null) {
            return;
        }
        if (!isSelected) {
            return;
        }
        Color[] colorArray = color = AquaJideUtils.isGraphite() ? AquaJideUtils.AQUA_GRAPHITE : AquaJideUtils.AQUA_BLUE;
        if (this.tabRegion != null) {
            Graphics2D g2d = (Graphics2D)g2;
            switch (tabPlacement) {
                case 2: {
                    AquaJideUtils.fillAquaGradientVertical(g2d, this.tabRegion, color);
                    break;
                }
                case 4: {
                    AquaJideUtils.fillAquaGradientVertical(g2d, this.tabRegion, color);
                    break;
                }
                case 3: {
                    AquaJideUtils.fillAquaGradientHorizontal(g2d, this.tabRegion, color);
                    break;
                }
                default: {
                    AquaJideUtils.fillAquaGradientHorizontal(g2d, this.tabRegion, color);
                }
            }
        }
    }

    protected void paintFocusIndicator(Graphics g2, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    protected boolean isRoundedCorner() {
        return true;
    }

    protected boolean isShading() {
        return true;
    }

    protected Color getBorderEdgeColor() {
        return this._shadow;
    }

    protected BasicJideTabbedPaneUI.TabCloseButton createNoFocusButton(int type) {
        return new AquaTabCloseButton(type);
    }

    protected void prepareEditor(BasicJideTabbedPaneUI.TabEditor e2, int tabIndex) {
        e2.setOpaque(true);
        super.prepareEditor(e2, tabIndex);
    }

    public class AquaTabCloseButton
    extends BasicJideTabbedPaneUI.TabCloseButton {
        public void updateUI() {
            super.updateUI();
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusPainted(false);
        }

        public AquaTabCloseButton() {
            this(0);
        }

        public AquaTabCloseButton(int type) {
            super(AquaJideTabbedPaneUI.this);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.setContentAreaFilled(false);
            this.setType(type);
        }

        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        protected void paintComponent(Graphics g2) {
            if (!this.isEnabled()) {
                this.setMouseOver(false);
                this.setMousePressed(false);
            }
            AquaJideUtils.antialiasShape(g2, true);
            Color color = g2.getColor();
            if (this.isMouseOver() && this.isMousePressed()) {
                g2.setColor(COLOR1);
                g2.fillOval(2, 2, this.getWidth() - 4, this.getHeight() - 4);
                g2.setColor(COLOR2);
            } else if (this.isMouseOver()) {
                g2.setColor(COLOR1);
                g2.fillOval(2, 2, this.getWidth() - 4, this.getHeight() - 4);
                g2.setColor(COLOR3);
            } else {
                g2.setColor(COLOR1);
            }
            int centerX = this.getWidth() >> 1;
            int centerY = this.getHeight() >> 1;
            switch (this.getType()) {
                case 0: {
                    if (this.isEnabled()) {
                        g2.drawLine(centerX - 2, centerY - 2, centerX + 2, centerY + 2);
                        g2.drawLine(centerX - 3, centerY - 2, centerX + 1, centerY + 2);
                        g2.drawLine(centerX + 2, centerY - 2, centerX - 2, centerY + 2);
                        g2.drawLine(centerX + 1, centerY - 2, centerX - 3, centerY + 2);
                        break;
                    }
                    g2.drawLine(centerX - 3, centerY - 3, centerX + 3, centerY + 3);
                    g2.drawLine(centerX + 3, centerY - 3, centerX - 3, centerY + 3);
                    break;
                }
                case 1: {
                    if (AquaJideTabbedPaneUI.this._tabPane.getTabPlacement() == 1 || AquaJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3) {
                        int x2 = centerX + 2;
                        int y2 = centerY;
                        if (this.isEnabled()) {
                            g2.drawLine(x2 - 3, y2 - 3, x2 - 3, y2 + 3);
                            g2.drawLine(x2 - 2, y2 - 2, x2 - 2, y2 + 2);
                            g2.drawLine(x2 - 1, y2 - 1, x2 - 1, y2 + 1);
                            g2.drawLine(x2, y2, x2, y2);
                            break;
                        }
                        g2.drawLine(x2 - 3, y2 - 3, x2, y2);
                        g2.drawLine(x2 - 3, y2 - 3, x2 - 3, y2 + 3);
                        g2.drawLine(x2 - 3, y2 + 3, x2, y2);
                        break;
                    }
                    int x3 = centerX;
                    int y3 = centerY + 2;
                    if (this.isEnabled()) {
                        g2.drawLine(x3 - 3, y3 - 3, x3 + 3, y3 - 3);
                        g2.drawLine(x3 - 2, y3 - 2, x3 + 2, y3 - 2);
                        g2.drawLine(x3 - 1, y3 - 1, x3 + 1, y3 - 1);
                        g2.drawLine(x3, y3, x3, y3);
                        break;
                    }
                    g2.drawLine(x3 - 3, y3 - 3, x3, y3);
                    g2.drawLine(x3 - 3, y3 - 3, x3 + 3, y3 - 3);
                    g2.drawLine(x3 + 3, y3 - 3, x3, y3);
                    break;
                }
                case 2: {
                    if (AquaJideTabbedPaneUI.this._tabPane.getTabPlacement() == 1 || AquaJideTabbedPaneUI.this._tabPane.getTabPlacement() == 3) {
                        int x4 = centerX - 3;
                        int y4 = centerY;
                        if (this.isEnabled()) {
                            g2.drawLine(x4, y4, x4, y4);
                            g2.drawLine(x4 + 1, y4 - 1, x4 + 1, y4 + 1);
                            g2.drawLine(x4 + 2, y4 - 2, x4 + 2, y4 + 2);
                            g2.drawLine(x4 + 3, y4 - 3, x4 + 3, y4 + 3);
                            break;
                        }
                        g2.drawLine(x4, y4, x4 + 3, y4 - 3);
                        g2.drawLine(x4, y4, x4 + 3, y4 + 3);
                        g2.drawLine(x4 + 3, y4 - 3, x4 + 3, y4 + 3);
                        break;
                    }
                    int x5 = centerX;
                    int y5 = centerY - 2;
                    if (this.isEnabled()) {
                        g2.drawLine(x5, y5, x5, y5);
                        g2.drawLine(x5 - 1, y5 + 1, x5 + 1, y5 + 1);
                        g2.drawLine(x5 - 2, y5 + 2, x5 + 2, y5 + 2);
                        g2.drawLine(x5 - 3, y5 + 3, x5 + 3, y5 + 3);
                        break;
                    }
                    g2.drawLine(x5, y5, x5 - 3, y5 + 3);
                    g2.drawLine(x5, y5, x5 + 3, y5 + 3);
                    g2.drawLine(x5 - 3, y5 + 3, x5 + 3, y5 + 3);
                    break;
                }
                case 5: {
                    int x6 = centerX;
                    int y6 = centerY + 2;
                    g2.drawLine(x6 - 3, y6 - 3, x6 + 3, y6 - 3);
                    g2.drawLine(x6 - 2, y6 - 2, x6 + 2, y6 - 2);
                    g2.drawLine(x6 - 1, y6 - 1, x6 + 1, y6 - 1);
                    g2.drawLine(x6, y6, x6, y6);
                    break;
                }
            }
            g2.setColor(color);
            AquaJideUtils.antialiasShape(g2, false);
        }

        public boolean isOpaque() {
            return false;
        }
    }
}

