/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import com.jidesoft.icons.ColorFilter;
import com.jidesoft.icons.MaskFilter;
import com.jidesoft.icons.TintFilter;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconsFactory {
    static Map<String, ImageIcon> _icons = new HashMap<String, ImageIcon>();
    static Map<String, ImageIcon> _disableIcons = new HashMap<String, ImageIcon>();
    static Map<String, ImageIcon> _brighterIcons = new HashMap<String, ImageIcon>();
    static Map<String, ImageIcon> _tintedIcons = new HashMap<String, ImageIcon>();
    public static ImageIcon EMPTY_ICON = new ImageIcon(){
        private static final long serialVersionUID = 5081581607741629368L;

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public synchronized void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        }
    };
    static final double DEGREE_90 = 1.5707963267948966;

    public static ImageIcon getImageIcon(Class<?> clazz, String fileName) {
        String id = clazz.getName() + ":" + fileName;
        Object iconInUIDefaults = UIManager.getDefaults().get(id);
        if (iconInUIDefaults instanceof ImageIcon) {
            return (ImageIcon)iconInUIDefaults;
        }
        Icon saved = _icons.get(id);
        if (saved != null) {
            return (ImageIcon)saved;
        }
        ImageIcon icon = IconsFactory.createImageIcon(clazz, fileName);
        _icons.put(id, icon);
        return icon;
    }

    public static ImageIcon findImageIcon(Class<?> clazz, String fileName) throws IOException {
        String id = clazz.getName() + ":" + fileName;
        Object iconInUIDefaults = UIManager.getDefaults().get(id);
        if (iconInUIDefaults instanceof ImageIcon) {
            return (ImageIcon)iconInUIDefaults;
        }
        ImageIcon saved = _icons.get(id);
        if (saved != null) {
            return saved;
        }
        ImageIcon icon = IconsFactory.createImageIconWithException(clazz, fileName);
        _icons.put(id, icon);
        return icon;
    }

    public static ImageIcon getDisabledImageIcon(Class<?> clazz, String fileName) {
        String id = clazz.getName() + ":" + fileName;
        ImageIcon saved = _disableIcons.get(id);
        if (saved != null) {
            return saved;
        }
        ImageIcon icon = IconsFactory.createGrayImage(IconsFactory.getImageIcon(clazz, fileName));
        _disableIcons.put(id, icon);
        return icon;
    }

    public static ImageIcon getBrighterImageIcon(Class<?> clazz, String fileName) {
        String id = clazz.getName() + ":" + fileName + ":" + ColorFilter.getPercent();
        ImageIcon saved = _brighterIcons.get(id);
        if (saved != null) {
            return saved;
        }
        ImageIcon icon = IconsFactory.createBrighterImage(IconsFactory.getImageIcon(clazz, fileName));
        _brighterIcons.put(id, icon);
        return icon;
    }

    public static ImageIcon getBrighterImageIcon(Class<?> clazz, String fileName, int percent) {
        String id = clazz.getName() + ":" + fileName + ":" + percent;
        ImageIcon saved = _brighterIcons.get(id);
        if (saved != null) {
            return saved;
        }
        ImageIcon icon = IconsFactory.createBrighterImage(IconsFactory.getImageIcon(clazz, fileName), percent);
        _brighterIcons.put(id, icon);
        return icon;
    }

    public static ImageIcon getTintedImageIcon(Class<?> clazz, String fileName, Color color) {
        String id = clazz.getName() + ":" + fileName + ":" + color.toString();
        ImageIcon saved = _tintedIcons.get(id);
        if (saved != null) {
            return saved;
        }
        ImageIcon icon = IconsFactory.createTintedImage(IconsFactory.getImageIcon(clazz, fileName), color);
        _tintedIcons.put(id, icon);
        return icon;
    }

    public static ImageIcon createGrayImage(Image image2) {
        if (image2 == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(GrayFilter.createDisabledImage(image2));
    }

    private static ImageIcon createGrayImage(ImageIcon icon) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(GrayFilter.createDisabledImage(icon.getImage()));
    }

    public static ImageIcon createGrayImage(Component c2, Icon icon) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        int w2 = icon.getIconWidth();
        int h2 = icon.getIconHeight();
        if (w2 == 0 || h2 == 0) {
            return EMPTY_ICON;
        }
        BufferedImage image2 = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(c2, image2.getGraphics(), 0, 0);
        return new ImageIcon(GrayFilter.createDisabledImage(image2));
    }

    public static ImageIcon createBrighterImage(Image image2) {
        if (image2 == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(ColorFilter.createBrighterImage(image2));
    }

    public static ImageIcon createBrighterImage(Image image2, int percent) {
        if (image2 == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(ColorFilter.createBrighterImage(image2, percent));
    }

    public static ImageIcon createBrighterImage(Component c2, Icon icon) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        BufferedImage image2 = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(c2, image2.getGraphics(), 0, 0);
        return new ImageIcon(ColorFilter.createBrighterImage(image2));
    }

    public static ImageIcon createBrighterImage(Component c2, Icon icon, int percent) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        BufferedImage image2 = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(c2, image2.getGraphics(), 0, 0);
        return new ImageIcon(ColorFilter.createBrighterImage(image2, percent));
    }

    public static ImageIcon createBrighterImage(ImageIcon icon) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(ColorFilter.createBrighterImage(icon.getImage()));
    }

    public static ImageIcon createBrighterImage(ImageIcon icon, int percent) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(ColorFilter.createBrighterImage(icon.getImage(), percent));
    }

    public static ImageIcon createTintedImage(ImageIcon icon, Color color) {
        if (icon == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(TintFilter.createTintedImage(icon.getImage(), color, null));
    }

    public static ImageIcon createNegativeImage(Image image2) {
        if (image2 == null) {
            return EMPTY_ICON;
        }
        return new ImageIcon(MaskFilter.createNegativeImage(image2));
    }

    public static ImageIcon createMaskImage(Component c2, Icon icon, Color oldColor, Color newColor) {
        BufferedImage image2 = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(c2, image2.getGraphics(), 0, 0);
        return new ImageIcon(MaskFilter.createImage(image2, oldColor, newColor));
    }

    public static ImageIcon createRotatedImage(Component c2, Icon icon, double rotatedAngle) {
        int h2;
        int w2;
        double originalAngle = rotatedAngle % 360.0;
        if (rotatedAngle != 0.0 && originalAngle == 0.0) {
            originalAngle = 360.0;
        }
        double angle = originalAngle % 90.0;
        if (originalAngle != 0.0 && angle == 0.0) {
            angle = 90.0;
        }
        double radian = Math.toRadians(angle);
        int iw = icon.getIconWidth();
        int ih = icon.getIconHeight();
        if (originalAngle >= 0.0 && originalAngle <= 90.0 || originalAngle > 180.0 && originalAngle <= 270.0) {
            w2 = (int)Math.round((double)iw * Math.sin(1.5707963267948966 - radian) + (double)ih * Math.sin(radian));
            h2 = (int)Math.round((double)iw * Math.sin(radian) + (double)ih * Math.sin(1.5707963267948966 - radian));
        } else {
            w2 = (int)((double)ih * Math.sin(1.5707963267948966 - radian) + (double)iw * Math.sin(radian));
            h2 = (int)((double)ih * Math.sin(radian) + (double)iw * Math.sin(1.5707963267948966 - radian));
        }
        BufferedImage image2 = new BufferedImage(w2, h2, 2);
        Graphics g2 = image2.getGraphics();
        Graphics2D g2d = (Graphics2D)g2.create();
        int cx2 = iw / 2;
        int cy2 = ih / 2;
        int xOffset = iw % 2 != 0 && originalAngle >= 90.0 && originalAngle <= 180.0 ? 1 : 0;
        int yOffset = iw % 2 != 0 && originalAngle >= 180.0 && originalAngle < 360.0 ? 1 : 0;
        g2d.translate(w2 / 2 + xOffset, h2 / 2 + yOffset);
        g2d.rotate(Math.toRadians(originalAngle));
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        icon.paintIcon(c2, g2d, -cx2, -cy2);
        g2d.dispose();
        return new ImageIcon(image2);
    }

    public static ImageIcon createNegativeImage(Component c2, Icon icon) {
        BufferedImage image2 = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(c2, image2.getGraphics(), 0, 0);
        return new ImageIcon(MaskFilter.createNegativeImage(image2));
    }

    private static ImageIcon createImageIcon(Class<?> baseClass, String file) {
        try {
            return IconsFactory.createImageIconWithException(baseClass, file);
        }
        catch (IOException e2) {
            System.err.println(e2.getLocalizedMessage());
            return null;
        }
    }

    private static ImageIcon createImageIconWithException(Class<?> baseClass, String file) throws IOException {
        InputStream resource = baseClass.getResourceAsStream(file);
        if (resource == null) {
            throw new FileNotFoundException(file);
        }
        Image image2 = "true".equals(SecurityUtils.getProperty("jide.useImageIO", "true")) ? ImageIO.read(resource) : IconsFactory.readImageIcon(baseClass, file, resource);
        resource.close();
        return new ImageIcon(image2);
    }

    private static Image readImageIcon(Class clazz, String file, InputStream resource) throws IOException {
        int n2;
        byte[][] buffer = new byte[1][];
        BufferedInputStream in = new BufferedInputStream(resource);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        buffer[0] = new byte[1024];
        while ((n2 = in.read(buffer[0])) > 0) {
            out.write(buffer[0], 0, n2);
        }
        in.close();
        out.flush();
        buffer[0] = out.toByteArray();
        if (buffer[0] == null || buffer[0].length == 0) {
            Package pkg = clazz.getPackage();
            String pkgName = "";
            if (pkg != null) {
                pkgName = pkg.getName().replace('.', '/');
            }
            if (buffer[0] == null) {
                throw new IOException("Warning: Resource " + pkgName + "/" + file + " not found.");
            }
            if (buffer[0].length == 0) {
                throw new IOException("Warning: Resource " + pkgName + "/" + file + " is zero-length");
            }
        }
        return Toolkit.getDefaultToolkit().createImage(buffer[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateHTML(Class<?> clazz) {
        String fullClassName = clazz.getName();
        String className = IconsFactory.getClassName(fullClassName);
        File file = new File(fullClassName + ".html");
        try {
            FileWriter writer = new FileWriter(file);
            try {
                writer.write("<html>\n<body>\n<p><b><font size=\"5\" face=\"Verdana\">Icons in " + fullClassName + "</font></b></p>");
                writer.write("<p><b><font size=\"3\" face=\"Verdana\">Generated by JIDE Icons</font></b></p>");
                writer.write("<p><b><font size=\"3\" color=\"#AAAAAA\" face=\"Verdana\">1. If you cannot view the images in this page, make sure the file is at the same directory as " + className + ".java</font></b></p>");
                writer.write("<p><b><font size=\"3\" color=\"#AAAAAA\" face=\"Verdana\">2. To get a particular icon in your code, call " + className + ".getImageIcon(FULL_CONSTANT_NAME). Replace FULL_CONSTANT_NAME with the actual " + "full constant name as in the table below" + "</font></b></p>");
                IconsFactory.generate(clazz, writer, className);
                writer.write("\n</body>\n</html>");
            }
            catch (IOException e2) {
                System.err.println(e2);
            }
            finally {
                writer.close();
            }
            System.out.println("File is generated at \"" + file.getAbsolutePath() + "\". Please copy it to the same directory as " + className + ".java");
        }
        catch (IOException e3) {
            System.err.println(e3);
        }
    }

    private static String getClassName(String fullName) {
        int last = fullName.lastIndexOf(".");
        if (last != -1) {
            fullName = fullName.substring(last + 1);
        }
        StringTokenizer tokenizer = new StringTokenizer(fullName, "$");
        StringBuffer buffer = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            buffer.append(tokenizer.nextToken());
            buffer.append(".");
        }
        return buffer.substring(0, buffer.length() - 1);
    }

    private static void generate(Class<?> aClass, FileWriter writer, String prefix) throws IOException {
        Class<?>[] classes = aClass.getDeclaredClasses();
        for (int i2 = classes.length - 1; i2 >= 0; --i2) {
            Class<?> clazz = classes[i2];
            IconsFactory.generate(clazz, writer, IconsFactory.getClassName(clazz.getName()));
        }
        Field[] fields = aClass.getFields();
        writer.write("<p><font face=\"Verdana\"><b>" + prefix + "</b></font></p>");
        writer.write("<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\" bordercolor=\"#CCCCCC\" width=\"66%\">");
        writer.write("<tr>\n");
        writer.write("<td width=\"24%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">Name</font></b></td>\n");
        writer.write("<td width=\"13%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">Image</font></b></td>\n");
        writer.write("<td width=\"32%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">File Name</font></b></td>\n");
        writer.write("<td width=\"31%\" align=\"center\"><b><font face=\"Verdana\" color=\"#003399\">Full Constant Name</font></b></td>\n");
        writer.write("</tr>\n");
        for (Field field : fields) {
            try {
                String name = field.getName();
                Object value = field.get(aClass);
                writer.write("<tr>\n");
                writer.write("<td align=\"left\"><font face=\"Verdana\">" + name + "</font></td>\n");
                writer.write("<td align=\"center\"><font face=\"Verdana\"><img border=\"0\" src=\"" + value + "\"></font></td>\n");
                writer.write("<td align=\"left\"><font face=\"Verdana\">" + value + "</font></td>\n");
                writer.write("<td align=\"left\"><font face=\"Verdana\">" + prefix + "." + name + "</font></td>\n");
                writer.write("</tr>\n");
            }
            catch (IllegalArgumentException e2) {
                e2.printStackTrace();
            }
            catch (IllegalAccessException e3) {
                e3.printStackTrace();
            }
        }
        writer.write("</table><br><p>\n");
    }

    public static ImageIcon getIcon(Component c2, ImageIcon icon, int x2, int y2, int width, int height) {
        return IconsFactory.getIcon(c2, icon, x2, y2, width, height, width, height);
    }

    public static ImageIcon getIcon(Component c2, ImageIcon icon, int x2, int y2, int width, int height, int destWidth, int destHeight) {
        return IconsFactory.getIcon(c2, icon, x2, y2, width, height, 2, destWidth, destHeight);
    }

    public static ImageIcon getIcon(Component c2, ImageIcon icon, int x2, int y2, int width, int height, int imageType) {
        return IconsFactory.getIcon(c2, icon, x2, y2, width, height, imageType, width, height);
    }

    public static ImageIcon getIcon(Component c2, ImageIcon icon, int x2, int y2, int width, int height, int imageType, int destWidth, int destHeight) {
        if (icon == null || x2 < 0 || x2 + width > icon.getIconWidth() || y2 < 0 || y2 + height > icon.getIconHeight()) {
            return EMPTY_ICON;
        }
        BufferedImage image2 = new BufferedImage(destWidth, destHeight, imageType);
        image2.getGraphics().drawImage(icon.getImage(), 0, 0, destWidth, destHeight, x2, y2, x2 + width, y2 + height, c2);
        return new ImageIcon(image2);
    }

    public static ImageIcon getOverlayIcon(Component c2, ImageIcon icon, ImageIcon overlayIcon, int location) {
        return IconsFactory.getOverlayIcon(c2, icon, overlayIcon, location, new Insets(0, 0, 0, 0));
    }

    public static ImageIcon getOverlayIcon(Component c2, ImageIcon icon, ImageIcon overlayIcon, int location, Insets insets) {
        int x2 = -1;
        int y2 = -1;
        int w2 = icon.getIconWidth();
        int h2 = icon.getIconHeight();
        int sw = overlayIcon.getIconWidth();
        int sh = overlayIcon.getIconHeight();
        switch (location) {
            case 0: {
                x2 = (w2 - sw) / 2;
                y2 = (h2 - sh) / 2;
                break;
            }
            case 1: {
                x2 = (w2 - sw) / 2;
                y2 = insets.top;
                break;
            }
            case 5: {
                x2 = (w2 - sw) / 2;
                y2 = h2 - insets.bottom - sh;
                break;
            }
            case 7: {
                x2 = insets.left;
                y2 = (h2 - sh) / 2;
                break;
            }
            case 3: {
                x2 = w2 - insets.right - sw;
                y2 = (h2 - sh) / 2;
                break;
            }
            case 2: {
                x2 = w2 - insets.right - sw;
                y2 = insets.top;
                break;
            }
            case 8: {
                x2 = insets.left;
                y2 = insets.top;
                break;
            }
            case 6: {
                x2 = insets.left;
                y2 = h2 - insets.bottom - sh;
                break;
            }
            case 4: {
                x2 = w2 - insets.right - sw;
                y2 = h2 - insets.bottom - sh;
            }
        }
        return IconsFactory.getOverlayIcon(c2, icon, overlayIcon, x2, y2);
    }

    public static ImageIcon getOverlayIcon(Component c2, ImageIcon icon, ImageIcon overlayIcon, int x2, int y2) {
        int w2 = icon == null ? overlayIcon.getIconWidth() : icon.getIconWidth();
        int h2 = icon == null ? overlayIcon.getIconHeight() : icon.getIconHeight();
        int sw = overlayIcon.getIconWidth();
        int sh = overlayIcon.getIconHeight();
        if (x2 != -1 && y2 != -1) {
            BufferedImage image2 = new BufferedImage(w2, h2, 2);
            if (icon != null) {
                image2.getGraphics().drawImage(icon.getImage(), 0, 0, w2, h2, c2);
            }
            image2.getGraphics().drawImage(overlayIcon.getImage(), x2, y2, sw, sh, c2);
            return new ImageIcon(image2);
        }
        return icon;
    }

    public static ImageIcon getCombinedIcon(Component c2, ImageIcon icon1, ImageIcon icon2, int orientation, int gap) {
        int y2;
        int y1;
        int x2;
        int x1;
        int height;
        int width;
        if (icon1 == null) {
            return icon2;
        }
        if (icon2 == null) {
            return icon1;
        }
        int w1 = icon1.getIconWidth();
        int h1 = icon1.getIconHeight();
        int w2 = icon2.getIconWidth();
        int h2 = icon2.getIconHeight();
        if (orientation == 0) {
            width = w1 + w2 + gap;
            height = Math.max(h1, h2);
            x1 = 0;
            x2 = w1 + gap;
            y1 = h1 > h2 ? 0 : (h2 - h1) / 2;
            y2 = h1 < h2 ? 0 : (h1 - h2) / 2;
        } else {
            width = Math.max(w1, w2);
            height = h1 + h2 + gap;
            x1 = w1 > w2 ? 0 : (w2 - w1) / 2;
            x2 = w1 < w2 ? 0 : (w1 - w2) / 2;
            y1 = 0;
            y2 = h1 + gap;
        }
        BufferedImage image2 = new BufferedImage(width, height, 2);
        image2.getGraphics().drawImage(icon1.getImage(), x1, y1, w1, h1, c2);
        image2.getGraphics().drawImage(icon2.getImage(), x2, y2, w2, h2, c2);
        return new ImageIcon(image2);
    }

    public static ImageIcon getScaledImage(Component c2, ImageIcon icon, int w2, int h2) {
        if (w2 >= icon.getIconWidth() / 2) {
            BufferedImage temp = new BufferedImage(w2, h2, 2);
            Graphics2D g2 = temp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.drawImage(icon.getImage(), 0, 0, temp.getWidth(), temp.getHeight(), c2);
            g2.dispose();
            return new ImageIcon(temp);
        }
        BufferedImage temp = new BufferedImage(w2, h2, 2);
        Graphics2D g2 = temp.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(icon.getImage(), 0, 0, temp.getWidth(), temp.getHeight(), c2);
        g2.dispose();
        return new ImageIcon(JideSwingUtilities.getFasterScaledInstance(temp, w2, h2, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true));
    }

    public static void writeGifToFile(Component c2, File file) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(file);
        IconsFactory.writeToStream(c2, "gif", fos);
        try {
            fos.close();
        }
        catch (IOException e2) {
            Logger.getAnonymousLogger().severe(e2.getMessage());
        }
    }

    public static void writeJpegToFile(Component c2, File file) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(file);
        IconsFactory.writeToStream(c2, "jpg", fos);
        try {
            fos.close();
        }
        catch (IOException e2) {
            Logger.getAnonymousLogger().severe(e2.getMessage());
        }
    }

    public static void writePngToFile(Component c2, File file) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(file);
        IconsFactory.writeToStream(c2, "png", fos);
        try {
            fos.close();
        }
        catch (IOException e2) {
            Logger.getAnonymousLogger().severe(e2.getMessage());
        }
    }

    public static void writeToStream(Component c2, OutputStream stream) {
        IconsFactory.writeToStream(c2, "png", stream);
    }

    private static void writeToStream(Component c2, String format, OutputStream stream) {
        BufferedImage img = IconsFactory.createImage(c2);
        try {
            ImageIO.write((RenderedImage)img, format, stream);
        }
        catch (IOException e2) {
            Logger.getAnonymousLogger().severe(e2.getMessage());
        }
    }

    public static BufferedImage createImage(Component component) {
        return IconsFactory.createImage(component, 1);
    }

    public static BufferedImage createImage(Component component, Rectangle bounds, int imageType) {
        BufferedImage img = new BufferedImage(bounds.width, bounds.height, imageType);
        Graphics2D graphics = img.createGraphics();
        graphics.fillRect(0, 0, img.getWidth(), img.getHeight());
        if (component instanceof JComponent) {
            JComponent c2 = (JComponent)component;
            boolean isDoubleBuffered = c2.isDoubleBuffered();
            c2.setDoubleBuffered(false);
            graphics.translate(-bounds.x, -bounds.y);
            graphics.setClip(bounds.x, bounds.y, bounds.width, bounds.height);
            c2.paint(graphics);
            c2.setDoubleBuffered(isDoubleBuffered);
        } else {
            component.paint(graphics);
        }
        graphics.dispose();
        return img;
    }

    public static BufferedImage createImage(Component component, int imageType) {
        Dimension componentSize = component.getSize();
        BufferedImage img = new BufferedImage(componentSize.width, componentSize.height, imageType);
        Graphics2D graphics = img.createGraphics();
        graphics.fillRect(0, 0, img.getWidth(), img.getHeight());
        if (component instanceof JComponent) {
            JComponent c2 = (JComponent)component;
            boolean isDoubleBuffered = c2.isDoubleBuffered();
            c2.setDoubleBuffered(false);
            c2.paint(graphics);
            c2.setDoubleBuffered(isDoubleBuffered);
        } else {
            component.paint(graphics);
        }
        graphics.dispose();
        return img;
    }

    public static Image createThumbnailImage(Component component, int width, int height) {
        BufferedImage image2 = IconsFactory.createImage(component);
        BufferedImage thumbnailImage = new BufferedImage(width, height, 1);
        Graphics2D g2 = thumbnailImage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        double w2 = (double)width / (double)image2.getWidth();
        double h2 = (double)height / (double)image2.getHeight();
        assert (w2 <= 1.0) : "The thumbnail should be smaller than the original";
        assert (h2 <= 1.0) : "The thumbnail should be smaller than the original";
        AffineTransform transform = AffineTransform.getScaleInstance(w2, h2);
        g2.drawRenderedImage(image2, transform);
        return thumbnailImage;
    }

    public static ImageIcon createThumbnail(Component component, int width, int height) {
        return new ImageIcon(IconsFactory.createThumbnailImage(component, width, height));
    }

    public static TexturePaint createTexture(JComponent observer, String fileName) {
        Image image2 = IconsFactory.createImage(fileName);
        MediaTracker tracker = new MediaTracker(observer);
        tracker.addImage(image2, 1);
        try {
            tracker.waitForAll();
        }
        catch (Exception e2) {
            // empty catch block
        }
        int w2 = image2.getWidth(observer);
        int h2 = image2.getHeight(observer);
        BufferedImage bi2 = new BufferedImage(w2, h2, 1);
        Graphics2D big = bi2.createGraphics();
        big.drawImage(image2, 0, 0, observer);
        return new TexturePaint(bi2, new Rectangle(0, 0, bi2.getWidth(), bi2.getHeight()));
    }

    public static Image createImage(String path) {
        ClassLoader loader = IconsFactory.class.getClassLoader();
        if (loader != null) {
            URL url = loader.getResource(path);
            if (url == null) {
                url = loader.getResource("/" + path);
            }
            return Toolkit.getDefaultToolkit().createImage(url);
        }
        return null;
    }
}

