/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;

public class ColorFilter
extends RGBImageFilter {
    private boolean _brighter;
    private static int _percent = 30;
    private static ColorFilter _colorFilter;

    public static ColorFilter getInstance(boolean brighter, int percent) {
        if (_colorFilter == null) {
            _colorFilter = new ColorFilter(brighter, percent);
        } else {
            _colorFilter.setBrighter(brighter);
            ColorFilter.setPercent(percent);
        }
        return _colorFilter;
    }

    public void setBrighter(boolean brighter) {
        this._brighter = brighter;
    }

    public static void setPercent(int percent) {
        _percent = percent;
    }

    public static int getPercent() {
        return _percent;
    }

    public static Image createBrighterImage(Image i2) {
        ColorFilter filter = ColorFilter.getInstance(true, _percent);
        FilteredImageSource prod = new FilteredImageSource(i2.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    public static Image createBrighterImage(Image i2, int p2) {
        ColorFilter.setPercent(p2);
        return ColorFilter.createBrighterImage(i2);
    }

    public static Image createDarkerImage(Image i2) {
        ColorFilter filter = ColorFilter.getInstance(false, _percent);
        FilteredImageSource prod = new FilteredImageSource(i2.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    public static Image createDarkerImage(Image i2, int p2) {
        ColorFilter.setPercent(p2);
        return ColorFilter.createDarkerImage(i2);
    }

    public ColorFilter(boolean b2, int p2) {
        this._brighter = b2;
        _percent = p2;
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int x2, int y2, int rgb) {
        int r2 = rgb >> 16 & 0xFF;
        int g2 = rgb >> 8 & 0xFF;
        int b2 = rgb & 0xFF;
        return rgb & 0xFF000000 | this.convert(r2) << 16 | this.convert(g2) << 8 | this.convert(b2);
    }

    private int convert(int color) {
        color = this._brighter ? (color += (255 - color) * _percent / 100) : (color -= (255 - color) * _percent / 100);
        if (color < 0) {
            color = 0;
        }
        if (color > 255) {
            color = 255;
        }
        return color;
    }
}

