/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ColorConverter;
import com.jidesoft.converter.ConverterContext;
import java.awt.Color;
import java.util.StringTokenizer;

public class RgbColorConverter
extends ColorConverter {
    private boolean _alphaIncluded = false;

    public RgbColorConverter() {
    }

    public RgbColorConverter(boolean alphaIncluded) {
        this._alphaIncluded = alphaIncluded;
    }

    public boolean isAlphaIncluded() {
        return this._alphaIncluded;
    }

    public void setAlphaIncluded(boolean alphaIncluded) {
        this._alphaIncluded = alphaIncluded;
    }

    public String toString(Object object, ConverterContext context) {
        if (object instanceof Color) {
            Color color = (Color)object;
            StringBuffer colorText = new StringBuffer();
            colorText.append(color.getRed()).append(", ");
            colorText.append(color.getGreen()).append(", ");
            colorText.append(color.getBlue());
            if (this.isAlphaIncluded()) {
                colorText.append(", ").append(color.getAlpha());
            }
            return new String(colorText);
        }
        return "";
    }

    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    public boolean supportFromString(String string2, ConverterContext context) {
        return true;
    }

    public Object fromString(String string2, ConverterContext context) {
        String s2;
        if (string2 == null || string2.trim().length() == 0) {
            return null;
        }
        StringTokenizer token2 = new StringTokenizer(string2, ",; ");
        int r2 = 0;
        int g2 = 0;
        int b2 = 0;
        int a2 = 255;
        if (token2.hasMoreTokens()) {
            s2 = token2.nextToken();
            try {
                r2 = Integer.parseInt(s2, 10) % 256;
                if (r2 < 0) {
                    r2 += 256;
                }
            }
            catch (NumberFormatException e2) {
                return null;
            }
        }
        if (token2.hasMoreTokens()) {
            s2 = token2.nextToken();
            try {
                g2 = Integer.parseInt(s2, 10) % 256;
                if (g2 < 0) {
                    g2 += 256;
                }
            }
            catch (NumberFormatException e3) {
                return null;
            }
        }
        if (token2.hasMoreTokens()) {
            s2 = token2.nextToken();
            try {
                b2 = Integer.parseInt(s2, 10) % 256;
                if (b2 < 0) {
                    b2 += 256;
                }
            }
            catch (NumberFormatException e4) {
                return null;
            }
        }
        if (this.isAlphaIncluded() && token2.hasMoreTokens()) {
            s2 = token2.nextToken();
            try {
                a2 = Integer.parseInt(s2, 10) % 256;
                if (a2 < 0) {
                    a2 += 256;
                }
            }
            catch (NumberFormatException e5) {
                return null;
            }
        }
        return new Color(r2, g2, b2, a2);
    }
}

