/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.converter.Resource;
import com.jidesoft.range.Range;
import java.text.MessageFormat;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeConverter
implements ObjectConverter {
    private Class<?> _elementClass;
    public static final ConverterContext CONTEXT_RANGE = new ConverterContext("Range");
    public static final ConverterContext CONTEXT_MULTIPLE = new ConverterContext("Multiple");

    public RangeConverter(Class<?> elementClass) {
        this._elementClass = elementClass;
    }

    public String arrayToString(Object[] objects, ConverterContext context) {
        if (objects.length > 1) {
            if (CONTEXT_RANGE.equals(context)) {
                String s2 = Resource.getResourceBundle(Locale.getDefault()).getString("Range.range");
                return MessageFormat.format(s2, this.toString(0, objects[0], context), this.toString(1, objects[1], context));
            }
            return Resource.getResourceBundle(Locale.getDefault()).getString("Range.multiple");
        }
        if (objects.length == 1) {
            return this.toString(0, objects[0], context);
        }
        return "";
    }

    protected String toString(int i2, Object o2, ConverterContext context) {
        return ObjectConverterManager.toString(o2, this._elementClass, context);
    }

    public Object[] arrayFromString(String string2, ConverterContext context) {
        return null;
    }

    protected Object fromString(int i2, String s2, ConverterContext context) {
        return ObjectConverterManager.fromString(s2, this._elementClass, context);
    }

    @Override
    public String toString(Object object, ConverterContext context) {
        if (object instanceof Range) {
            Range range = (Range)object;
            if (range.size() == 0.0) {
                return this.arrayToString(new Object[]{range.lower()}, context);
            }
            return this.arrayToString(new Object[]{range.lower(), range.upper()}, context);
        }
        return "";
    }

    @Override
    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    @Override
    public Object fromString(String string2, ConverterContext context) {
        if (string2 == null || string2.trim().length() == 0) {
            return null;
        }
        Object[] objects = this.arrayFromString(string2, context);
        if (objects == null) {
            return null;
        }
        if (objects.length == 1) {
            return null;
        }
        if (objects.length >= 2) {
            return null;
        }
        return null;
    }

    @Override
    public boolean supportFromString(String string2, ConverterContext context) {
        return false;
    }
}

