/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class MonthConverter
implements ObjectConverter {
    public static ConverterContext CONTEXT_MONTH = new ConverterContext("Calendar.Month");
    private DateFormat _conciseFormat = new SimpleDateFormat("MMyy");
    private DateFormat _shortFormat = new SimpleDateFormat("MM/yy");
    private DateFormat _mediumFormat = new SimpleDateFormat("MM, yyyy");
    private DateFormat _longFormat = new SimpleDateFormat("MMMMM, yyyy");
    private DateFormat _defaultFormat = this._shortFormat;

    public String toString(Object object, ConverterContext context) {
        if (object == null || !(object instanceof Calendar)) {
            return "";
        }
        return this._defaultFormat.format(((Calendar)object).getTime());
    }

    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    public Object fromString(String string2, ConverterContext context) {
        Calendar calendar2 = Calendar.getInstance();
        try {
            Date time = this._defaultFormat.parse(string2);
            calendar2.setTime(time);
        }
        catch (ParseException e1) {
            try {
                Date time = this._shortFormat.parse(string2);
                calendar2.setTime(time);
            }
            catch (ParseException e2) {
                try {
                    Date time = this._mediumFormat.parse(string2);
                    calendar2.setTime(time);
                }
                catch (ParseException e3) {
                    try {
                        Date time = this._longFormat.parse(string2);
                        calendar2.setTime(time);
                    }
                    catch (ParseException e4) {
                        try {
                            Date time = this._conciseFormat.parse(string2);
                            calendar2.setTime(time);
                        }
                        catch (ParseException e5) {
                            return null;
                        }
                    }
                }
            }
        }
        return calendar2;
    }

    public boolean supportFromString(String string2, ConverterContext context) {
        return true;
    }

    public DateFormat getDefaultFormat() {
        return this._defaultFormat;
    }

    public void setDefaultFormat(DateFormat defaultFormat) {
        this._defaultFormat = defaultFormat;
    }
}

