/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.comparator;

import com.jidesoft.comparator.ComparatorContext;
import java.io.File;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlphanumFileComparator
implements Comparator<File> {
    private boolean _caseSensitive;
    public static final ComparatorContext CONTEXT = new ComparatorContext("Alphanum");
    public static final ComparatorContext CONTEXT_IGNORE_CASE = new ComparatorContext("Alphanum_Ignorecase");

    public AlphanumFileComparator() {
        this(true);
    }

    public AlphanumFileComparator(boolean caseSensitive) {
        this._caseSensitive = caseSensitive;
    }

    private boolean isDigit(char ch2) {
        return ch2 >= '0' && ch2 <= '9';
    }

    private String getChunk(CharSequence s2, int slength, int marker) {
        StringBuilder chunk2 = new StringBuilder();
        char c2 = s2.charAt(marker);
        chunk2.append(c2);
        ++marker;
        if (this.isDigit(c2)) {
            while (marker < slength && this.isDigit(c2 = s2.charAt(marker))) {
                chunk2.append(c2);
                ++marker;
            }
        } else {
            while (marker < slength && !this.isDigit(c2 = s2.charAt(marker))) {
                chunk2.append(c2);
                ++marker;
            }
        }
        return chunk2.toString();
    }

    @Override
    public int compare(File f1, File f2) {
        int thisMarker = 0;
        int thatMarker = 0;
        String s1 = f1.getName();
        String s2 = f2.getName();
        int s1Length = s1.length();
        int s2Length = s2.length();
        while (thisMarker < s1Length && thatMarker < s2Length) {
            int result;
            String thisChunk = this.getChunk(s1, s1Length, thisMarker);
            thisMarker += thisChunk.length();
            String thatChunk = this.getChunk(s2, s2Length, thatMarker);
            thatMarker += thatChunk.length();
            if (this.isDigit(thisChunk.charAt(0)) && this.isDigit(thatChunk.charAt(0))) {
                int thisChunkLength = thisChunk.length();
                result = thisChunkLength - thatChunk.length();
                if (result == 0) {
                    for (int i2 = 0; i2 < thisChunkLength; ++i2) {
                        result = thisChunk.charAt(i2) - thatChunk.charAt(i2);
                        if (result == 0) continue;
                        return result;
                    }
                }
            } else {
                int n2 = result = this.isCaseSensitive() ? thisChunk.compareTo(thatChunk) : thisChunk.compareToIgnoreCase(thatChunk);
            }
            if (result == 0) continue;
            return result;
        }
        return s1Length - s2Length;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this._caseSensitive = caseSensitive;
    }
}

