/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.ZyNodeData;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IRealizerUpdater;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyNodeRealizerListener;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.IZyNodeRealizer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import y.c.d;
import y.c.p;
import y.d.m;
import y.i.O;
import y.i.U;
import y.i.aY;
import y.i.cd;
import y.i.co;

public abstract class ZyNodeRealizer<NodeType extends ZyGraphNode<?>>
extends co
implements IZyNodeRealizer {
    private ZyNodeData<?> m_userData;
    private IRealizerUpdater<?> m_updater;
    private final ListenerProvider<IZyNodeRealizerListener<?>> m_listeners = new ListenerProvider();
    protected boolean m_isHighLighted = false;

    private void notifyLocationChanged(double d2, double d3) {
        for (IZyNodeRealizerListener<?> iZyNodeRealizerListener : this.m_listeners) {
            try {
                iZyNodeRealizerListener.changedLocation(this, d2, d3);
            }
            catch (Exception exception) {}
        }
    }

    protected void notifyHasRegenerated() {
        for (IZyNodeRealizerListener<?> iZyNodeRealizerListener : this.m_listeners) {
            try {
                iZyNodeRealizerListener.regenerated(this);
            }
            catch (Exception exception) {}
        }
    }

    protected void scalePortCoordinates(p p2, double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        cd cd2;
        O o2;
        d d8;
        U u2 = (U)p2.e();
        double d9 = d2 > 0.0 ? d3 / d2 : 1.0;
        double d10 = d4 > 0.0 ? d5 / d4 : 1.0;
        for (d8 = p2.f(); d8 != null; d8 = d8.g()) {
            o2 = u2.i(d8);
            cd2 = o2.getSourcePort();
            d7 = cd2.g() * d9;
            d6 = cd2.h() * d10;
            cd2.b(d7, d6);
            u2.a(d8, new m(d7, d6));
        }
        for (d8 = p2.g(); d8 != null; d8 = d8.h()) {
            o2 = u2.i(d8);
            cd2 = o2.getTargetPort();
            d7 = cd2.g() * d9;
            d6 = cd2.h() * d10;
            cd2.b(d7, d6);
            u2.b(d8, new m(d7, d6));
        }
    }

    public void addListener(IZyNodeRealizerListener<?> iZyNodeRealizerListener) {
        this.m_listeners.addListener(iZyNodeRealizerListener);
    }

    @Override
    public abstract ZyLabelContent getNodeContent();

    public IRealizerUpdater<?> getUpdater() {
        return this.m_updater;
    }

    @Override
    public ZyNodeData<?> getUserData() {
        return this.m_userData;
    }

    @Override
    public void moveBy(double d2, double d3) {
        super.moveBy(d2, d3);
        this.notifyLocationChanged(this.getX(), this.getY());
    }

    @Override
    public void paintSloppy(Graphics2D graphics2D) {
        if (this.isSelected() || this.m_isHighLighted) {
            aY aY2 = this.getLineType();
            this.setLineType(aY.e);
            this.paintFilledShape(graphics2D);
            this.paintShapeBorder(graphics2D);
            this.setLineType(aY2);
        } else {
            this.paintFilledShape(graphics2D);
            this.paintShapeBorder(graphics2D);
        }
    }

    @Override
    public int positionToRow(double d2) {
        ZyLabelContent zyLabelContent = this.getNodeContent();
        Rectangle2D rectangle2D = this.getNodeContent().getBounds();
        double d3 = this.getHeight() / rectangle2D.getHeight();
        int n2 = (int)((d2 / d3 - (double)zyLabelContent.getPaddingTop()) / zyLabelContent.getLineHeight());
        return n2 >= zyLabelContent.getLineCount() ? -1 : n2;
    }

    @Override
    public void regenerate() {
        ZyLabelContent zyLabelContent = this.getNodeContent();
        double d2 = zyLabelContent.getBounds().getWidth();
        double d3 = zyLabelContent.getBounds().getHeight();
        if (this.m_updater != null) {
            this.m_updater.generateContent(this, zyLabelContent);
        }
        Rectangle2D rectangle2D = zyLabelContent.getBounds();
        this.setSize(rectangle2D.getWidth(), rectangle2D.getHeight());
        this.scalePortCoordinates(this.getNode(), d2, rectangle2D.getWidth(), d3, rectangle2D.getHeight());
        this.notifyHasRegenerated();
        this.repaint();
    }

    public void removeListener(IZyNodeRealizerListener<?> iZyNodeRealizerListener) {
        this.m_listeners.removeListener(iZyNodeRealizerListener);
    }

    @Override
    public double rowToPosition(int n2) {
        ZyLabelContent zyLabelContent = this.getNodeContent();
        return (double)zyLabelContent.getPaddingTop() + (double)n2 * zyLabelContent.getLineHeight();
    }

    @Override
    public void setCenter(double d2, double d3) {
        super.setCenter(d2, d3);
        this.notifyLocationChanged(this.getX(), this.getY());
    }

    @Override
    public void setFillColor(Color color) {
        if (super.getFillColor() != color) {
            super.setFillColor(color);
            this.updateContentSelectionColor();
        }
    }

    @Override
    public void setLineType(aY aY2) {
        this.m_isHighLighted = aY2 == aY.e || aY2 == aY.l || aY2 == aY.q || aY2 == aY.v;
        super.setLineType(aY2);
    }

    @Override
    public void setLocation(double d2, double d3) {
        super.setLocation(d2, d3);
        this.notifyLocationChanged(d2, d3);
    }

    @Override
    public void setSelected(boolean bl2) {
        if (super.isSelected() != bl2) {
            super.setSelected(bl2);
            this.updateContentSelectionColor();
            for (IZyNodeRealizerListener<?> iZyNodeRealizerListener : this.m_listeners) {
                try {
                    iZyNodeRealizerListener.changedSelection(this);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void setSize(double d2, double d3) {
        if (super.getX() != d2 || super.getY() != d3) {
            super.setSize(d2, d3);
            for (IZyNodeRealizerListener<?> iZyNodeRealizerListener : this.m_listeners) {
                try {
                    iZyNodeRealizerListener.changedSize(this, d2, d3);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void setUpdater(IRealizerUpdater<? extends ZyGraphNode<?>> iRealizerUpdater) {
        this.m_updater = iRealizerUpdater;
        if (iRealizerUpdater != null) {
            iRealizerUpdater.setRealizer(this);
        }
    }

    @Override
    public void setUserData(ZyNodeData<?> zyNodeData) {
        Preconditions.checkNotNull(zyNodeData, "Error: Invalid node data");
        this.m_userData = zyNodeData;
    }

    @Override
    public void setVisible(boolean bl2) {
        if (super.isVisible() != bl2) {
            super.setVisible(bl2);
            this.updateContentSelectionColor();
            for (IZyNodeRealizerListener<?> iZyNodeRealizerListener : this.m_listeners) {
                try {
                    iZyNodeRealizerListener.changedVisibility(this);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void updateContentSelectionColor() {
        ZyLabelContent zyLabelContent = this.getNodeContent();
        if (zyLabelContent.isSelectable()) {
            zyLabelContent.updateContentSelectionColor(this.getFillColor(), this.isSelected());
        }
    }
}

