/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode.states;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.editmode.CStateChange;
import com.google.security.zynamics.zylib.gui.zygraph.editmode.IMouseState;
import com.google.security.zynamics.zylib.gui.zygraph.editmode.IMouseStateChange;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode.CStateFactory;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode.helpers.CMousePressedHandler;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode.transformations.CHitBendsTransformer;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode.transformations.CHitEdgeLabelsTransformer;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode.transformations.CHitEdgesTransformer;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode.transformations.CHitNodesTransformer;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.awt.event.MouseEvent;
import y.i.N;
import y.i.aM;

public class CEdgeLabelExitState<NodeType extends ZyGraphNode<?>, EdgeType extends ZyGraphEdge<?, ?, ?>>
implements IMouseState {
    private final CStateFactory<NodeType, EdgeType> m_factory;
    private final AbstractZyGraph<NodeType, EdgeType> m_graph;
    private final N m_label;

    public CEdgeLabelExitState(CStateFactory<NodeType, EdgeType> cStateFactory, AbstractZyGraph<NodeType, EdgeType> abstractZyGraph, N n2) {
        this.m_factory = Preconditions.checkNotNull(cStateFactory, "Error: factory argument can not be null");
        this.m_graph = Preconditions.checkNotNull(abstractZyGraph, "Error: graph argument can not be null");
        this.m_label = Preconditions.checkNotNull(n2, "Error: label argument can not be null");
    }

    public AbstractZyGraph<NodeType, EdgeType> getGraph() {
        return this.m_graph;
    }

    public N getLabel() {
        return this.m_label;
    }

    public CStateFactory<NodeType, EdgeType> getStateFactory() {
        return this.m_factory;
    }

    @Override
    public IMouseStateChange mouseDragged(MouseEvent mouseEvent, AbstractZyGraph<?, ?> abstractZyGraph) {
        return new CStateChange(this.m_factory.createDefaultState(), true);
    }

    @Override
    public IMouseStateChange mouseMoved(MouseEvent mouseEvent, AbstractZyGraph<?, ?> abstractZyGraph) {
        double d2 = this.m_graph.getEditMode().translateX(mouseEvent.getX());
        double d3 = this.m_graph.getEditMode().translateY(mouseEvent.getY());
        aM aM2 = this.m_graph.getGraph().b(d2, d3);
        if (aM2.t()) {
            return CHitNodesTransformer.enterNode(this.m_factory, mouseEvent, aM2);
        }
        if (aM2.s()) {
            throw new IllegalStateException();
        }
        if (aM2.u()) {
            return CHitEdgesTransformer.enterEdge(this.m_factory, mouseEvent, aM2);
        }
        if (aM2.r()) {
            return CHitEdgeLabelsTransformer.enterEdgeLabel(this.m_factory, mouseEvent, aM2);
        }
        if (aM2.v()) {
            return CHitBendsTransformer.enterBend(this.m_factory, mouseEvent, aM2);
        }
        if (aM2.q()) {
            return new CStateChange(this, true);
        }
        return new CStateChange(this.m_factory.createDefaultState(), true);
    }

    @Override
    public IMouseStateChange mousePressed(MouseEvent mouseEvent, AbstractZyGraph<?, ?> abstractZyGraph) {
        return CMousePressedHandler.handleMousePressed(this.m_factory, this, abstractZyGraph, mouseEvent);
    }

    @Override
    public IMouseStateChange mouseReleased(MouseEvent mouseEvent, AbstractZyGraph<?, ?> abstractZyGraph) {
        return new CStateChange(this.m_factory.createDefaultState(), true);
    }
}

