/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode.states;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.editmode.CStateChange;
import com.google.security.zynamics.zylib.gui.zygraph.editmode.IMouseState;
import com.google.security.zynamics.zylib.gui.zygraph.editmode.IMouseStateChange;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode.CStateFactory;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.editmode.transformations.CHitEdgesTransformer;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.awt.event.MouseEvent;
import y.c.d;
import y.i.aM;

public class CEdgeClickedRightState<NodeType extends ZyGraphNode<?>, EdgeType extends ZyGraphEdge<?, ?, ?>>
implements IMouseState {
    private final CStateFactory<NodeType, EdgeType> m_factory;
    private final AbstractZyGraph<NodeType, EdgeType> m_graph;
    private final d m_edge;

    public CEdgeClickedRightState(CStateFactory<NodeType, EdgeType> cStateFactory, AbstractZyGraph<NodeType, EdgeType> abstractZyGraph, d d2) {
        this.m_factory = Preconditions.checkNotNull(cStateFactory, "Error: factory argument can not be null");
        this.m_graph = Preconditions.checkNotNull(abstractZyGraph, "Error: graph argument can not be null");
        this.m_edge = Preconditions.checkNotNull(d2, "Error: edge argument can not be null");
    }

    public ZyGraphEdge<?, ?, ?> getEdge() {
        return this.m_graph.getEdge(this.m_edge);
    }

    public AbstractZyGraph<NodeType, EdgeType> getGraph() {
        return this.m_graph;
    }

    public CStateFactory<NodeType, EdgeType> getStateFactory() {
        return this.m_factory;
    }

    @Override
    public IMouseStateChange mouseDragged(MouseEvent mouseEvent, AbstractZyGraph<?, ?> abstractZyGraph) {
        return new CStateChange(this, true);
    }

    @Override
    public IMouseStateChange mouseMoved(MouseEvent mouseEvent, AbstractZyGraph<?, ?> abstractZyGraph) {
        double d2 = abstractZyGraph.getEditMode().translateX(mouseEvent.getX());
        double d3 = abstractZyGraph.getEditMode().translateY(mouseEvent.getY());
        aM aM2 = abstractZyGraph.getGraph().b(d2, d3);
        if (aM2.u()) {
            return CHitEdgesTransformer.changeEdge(this.m_factory, mouseEvent, aM2, this.m_edge);
        }
        this.m_factory.createEdgeExitState(this.m_edge, mouseEvent);
        return CHitEdgesTransformer.exitEdge(this.m_factory, mouseEvent, aM2, this);
    }

    @Override
    public IMouseStateChange mousePressed(MouseEvent mouseEvent, AbstractZyGraph<?, ?> abstractZyGraph) {
        return new CStateChange(this.m_factory.createDefaultState(), true);
    }

    @Override
    public IMouseStateChange mouseReleased(MouseEvent mouseEvent, AbstractZyGraph<?, ?> abstractZyGraph) {
        return new CStateChange(this.m_factory.createDefaultState(), true);
    }
}

