/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.yfileswrap.gui.zygraph;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.ZyEdgeRealizer;
import java.util.Collection;
import java.util.Map;
import y.c.d;
import y.c.p;
import y.i.U;

public class ZyGraphMappings<NodeType extends ZyGraphNode<?>, EdgeType extends ZyGraphEdge<?, ?, ?>> {
    private final Map<d, EdgeType> m_edgeMap;
    private final Map<Object, EdgeType> m_rawEdgeMap;
    private final Map<p, NodeType> m_nodeMap;
    private final Map<Object, NodeType> m_rawNodeMap;
    private final U m_graph;

    public ZyGraphMappings(U u2, Map<p, NodeType> map, Map<d, EdgeType> map2) {
        this.m_graph = u2;
        this.m_nodeMap = Maps.newHashMap(map);
        this.m_rawNodeMap = Maps.newHashMap();
        this.m_edgeMap = Maps.newHashMap(map2);
        this.m_rawEdgeMap = Maps.newHashMap();
        for (Object object : map2.values()) {
            this.m_rawEdgeMap.put(((ZyGraphEdge)object).getRawEdge(), object);
        }
        for (Object object : map.values()) {
            this.m_rawNodeMap.put(((ZyGraphNode)object).getRawNode(), object);
        }
    }

    public void addEdge(d d2, EdgeType EdgeType2) {
        this.m_edgeMap.put(d2, EdgeType2);
        this.m_rawEdgeMap.put(((ZyGraphEdge)EdgeType2).getRawEdge(), EdgeType2);
    }

    public void addNode(p p2, NodeType NodeType) {
        this.m_nodeMap.put(p2, NodeType);
        this.m_rawNodeMap.put(((ZyGraphNode)NodeType).getRawNode(), NodeType);
    }

    public EdgeType getEdge(d d2) {
        if (d2.a() != this.m_graph) {
            return null;
        }
        ZyGraphEdge zyGraphEdge = (ZyGraphEdge)((ZyEdgeRealizer)this.m_graph.i(d2)).getUserData().getEdge();
        return (EdgeType)zyGraphEdge;
    }

    public EdgeType getEdge(Object object) {
        return (EdgeType)((ZyGraphEdge)this.m_rawEdgeMap.get(object));
    }

    public Collection<EdgeType> getEdges() {
        return this.m_edgeMap.values();
    }

    public NodeType getNode(p p2) {
        Preconditions.checkNotNull(p2, "Node argument cannot be null");
        return (NodeType)((ZyGraphNode)this.m_nodeMap.get(p2));
    }

    public NodeType getNode(Object object) {
        return (NodeType)((ZyGraphNode)this.m_rawNodeMap.get(object));
    }

    public Collection<NodeType> getNodes() {
        return this.m_nodeMap.values();
    }

    public d getYEdge(Object object) {
        return ((ZyGraphEdge)this.m_rawEdgeMap.get(object)).getEdge();
    }

    public p getYNode(Object object) {
        if (this.m_rawNodeMap.containsKey(object)) {
            return ((ZyGraphNode)this.m_rawNodeMap.get(object)).getNode();
        }
        return null;
    }

    public void removeEdge(EdgeType EdgeType2) {
        this.m_edgeMap.remove(((ZyGraphEdge)EdgeType2).getEdge());
        this.m_rawEdgeMap.remove(((ZyGraphEdge)EdgeType2).getRawEdge());
    }

    public void removeNode(NodeType NodeType) {
        this.m_nodeMap.remove(((ZyGraphNode)NodeType).getNode());
        this.m_rawNodeMap.remove(((ZyGraphNode)NodeType).getRawNode());
    }

    public void setEdge(Object object, EdgeType EdgeType2) {
        this.m_rawEdgeMap.put(object, EdgeType2);
    }

    public void setNode(Object object, NodeType NodeType) {
        this.m_rawNodeMap.put(object, NodeType);
    }
}

