/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.yfileswrap.gui.zygraph;

import com.google.security.zynamics.zylib.general.ClipboardHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.functions.NodeFunctions;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.SelectedVisibleFilter;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.functions.MoveFunctions;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.functions.ZoomFunctions;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import y.i.ar;
import y.i.au;

public class CRegisterHotKeys {
    public static <NodeType extends ZyGraphNode<?>> void register(AbstractZyGraph<NodeType, ?> abstractZyGraph) {
        ar ar2 = abstractZyGraph.getView();
        au au2 = new au(ar2);
        ActionMap actionMap = au2.v();
        InputMap inputMap = au2.a(actionMap);
        ar2.setActionMap(actionMap);
        ar2.setInputMap(0, inputMap);
        ar2.getCanvasComponent().setActionMap(actionMap);
        ar2.getCanvasComponent().setInputMap(0, inputMap);
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "DOWN");
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "UP");
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "LEFT");
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "RIGHT");
        inputMap.put(KeyStroke.getKeyStroke(521, 0), "+");
        inputMap.put(KeyStroke.getKeyStroke(45, 0), "-");
        inputMap.put(KeyStroke.getKeyStroke(77, 0), "m");
        inputMap.put(KeyStroke.getKeyStroke(83, 0), "s");
        inputMap.put(KeyStroke.getKeyStroke(153, 0), "<");
        inputMap.put(KeyStroke.getKeyStroke(65, 128), "SELECT_VISIBLE_NODES");
        inputMap.put(KeyStroke.getKeyStroke(67, 128), "COPY_CONTENT_FROM_SELECTED_NODES");
        actionMap.remove(au.u);
        actionMap.remove(au.B);
        CRegisterHotKeys.registerActions(abstractZyGraph);
    }

    public static <NodeType extends ZyGraphNode<?>> void registerActions(AbstractZyGraph<NodeType, ?> abstractZyGraph) {
        ActionMap actionMap = abstractZyGraph.getView().getCanvasComponent().getActionMap();
        actionMap.put("DOWN", new CActionHotKey<NodeType>("DOWN", abstractZyGraph));
        actionMap.put("UP", new CActionHotKey<NodeType>("UP", abstractZyGraph));
        actionMap.put("LEFT", new CActionHotKey<NodeType>("LEFT", abstractZyGraph));
        actionMap.put("RIGHT", new CActionHotKey<NodeType>("RIGHT", abstractZyGraph));
        actionMap.put("+", new CActionHotKey<NodeType>("+", abstractZyGraph));
        actionMap.put("-", new CActionHotKey<NodeType>("-", abstractZyGraph));
        actionMap.put("m", new CActionHotKey<NodeType>("m", abstractZyGraph));
        actionMap.put("s", new CActionHotKey<NodeType>("s", abstractZyGraph));
        actionMap.put("<", new CActionHotKey<NodeType>("<", abstractZyGraph));
        actionMap.put("SELECT_VISIBLE_NODES", new CActionHotKey<NodeType>("SELECT_VISIBLE_NODES", abstractZyGraph));
        actionMap.put("COPY_CONTENT_FROM_SELECTED_NODES", new CActionHotKey<NodeType>("COPY_CONTENT_FROM_SELECTED_NODES", abstractZyGraph));
        abstractZyGraph.getView().setActionMap(actionMap);
        abstractZyGraph.getView().getCanvasComponent().setActionMap(actionMap);
    }

    public static <NodeType extends ZyGraphNode<?>> void unregisterActions(AbstractZyGraph<NodeType, ?> abstractZyGraph) {
        ActionMap actionMap = abstractZyGraph.getView().getCanvasComponent().getActionMap();
        ActionMap actionMap2 = abstractZyGraph.getView().getActionMap();
        actionMap.remove("F2");
        actionMap.remove("DOWN");
        actionMap.remove("UP");
        actionMap.remove("LEFT");
        actionMap.remove("RIGHT");
        actionMap.remove("+");
        actionMap.remove("-");
        actionMap.remove("m");
        actionMap.remove("s");
        actionMap.remove("<");
        actionMap.remove("SELECT_VISIBLE_NODES");
        actionMap.remove("COPY_CONTENT_FROM_SELECTED_NODES");
        actionMap2.remove("DOWN");
        actionMap2.remove("UP");
        actionMap2.remove("LEFT");
        actionMap2.remove("RIGHT");
        actionMap2.remove("+");
        actionMap2.remove("-");
        actionMap2.remove("m");
        actionMap2.remove("s");
        actionMap2.remove("<");
        actionMap2.remove("SELECT_VISIBLE_NODES");
        actionMap2.remove("COPY_CONTENT_FROM_SELECTED_NODES");
    }

    private static class CActionHotKey<NodeType extends ZyGraphNode<? extends IViewNode<?>>>
    extends AbstractAction {
        private static final long serialVersionUID = 4029488848855226091L;
        private final String m_action;
        private final AbstractZyGraph<NodeType, ?> m_graph;

        public CActionHotKey(String string2, AbstractZyGraph<NodeType, ?> abstractZyGraph) {
            super(string2);
            this.m_action = string2;
            this.m_graph = abstractZyGraph;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.m_action.equals("UP")) {
                MoveFunctions.pan(this.m_graph, 0.0, -1.0);
            } else if (this.m_action.equals("DOWN")) {
                MoveFunctions.pan(this.m_graph, 0.0, 1.0);
            } else if (this.m_action.equals("LEFT")) {
                MoveFunctions.pan(this.m_graph, -1.0, 0.0);
            } else if (this.m_action.equals("RIGHT")) {
                MoveFunctions.pan(this.m_graph, 1.0, 0.0);
            } else if (this.m_action.equals("+")) {
                this.m_graph.zoomIn();
            } else if (this.m_action.equals("-")) {
                this.m_graph.zoomOut();
            } else if (this.m_action.equals("m")) {
                this.m_graph.getView().fitContent(true);
            } else if (this.m_action.equals("s")) {
                ZoomFunctions.zoomToNodes(this.m_graph, SelectedVisibleFilter.filter(this.m_graph.getSelectedNodes()));
            } else if (this.m_action.equals("SELECT_VISIBLE_NODES")) {
                List<NodeType> list = NodeFunctions.getVisibleNodes(this.m_graph);
                this.m_graph.selectNodes(list, true);
            } else if (this.m_action.equals("COPY_CONTENT_FROM_SELECTED_NODES")) {
                ClipboardHelpers.copyToClipboard(GraphHelpers.getSelectedContent(this.m_graph));
            }
        }
    }
}

