/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.types.graphs.algorithms;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import com.google.security.zynamics.zylib.types.graphs.IGraphNode;
import com.google.security.zynamics.zylib.types.graphs.algorithms.MalformedGraphException;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import com.google.security.zynamics.zylib.types.trees.Tree;
import com.google.security.zynamics.zylib.types.trees.TreeNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public final class LengauerTarjan {
    private static <NodeType extends IGraphNode<NodeType>> int depthFirstSearch(NodeType parent, NodeType rootNode, HashMap<NodeType, Integer> dfnums, HashMap<Integer, NodeType> vertex, HashMap<NodeType, NodeType> parents, int dfnum) {
        parents.put(rootNode, parent);
        vertex.put(dfnum, rootNode);
        dfnums.put(rootNode, dfnum);
        ++dfnum;
        Stack<Pair<IGraphNode, Object>> nodeStack = new Stack<Pair<IGraphNode, Object>>();
        for (IGraphNode child : Lists.reverse(rootNode.getChildren())) {
            nodeStack.push(new Pair<IGraphNode, NodeType>(child, rootNode));
        }
        while (!nodeStack.empty()) {
            Pair currentElement = (Pair)nodeStack.pop();
            IGraphNode currentNode = (IGraphNode)currentElement.first();
            IGraphNode currentParent = (IGraphNode)currentElement.second();
            if (dfnums.get(currentNode) != -1) continue;
            dfnums.put(currentNode, dfnum);
            vertex.put(dfnum, currentNode);
            parents.put(currentNode, currentParent);
            ++dfnum;
            for (IGraphNode child : Lists.reverse(currentNode.getChildren())) {
                nodeStack.push(new Pair<IGraphNode, IGraphNode>(child, currentNode));
            }
        }
        return dfnum - 1;
    }

    private static <NodeType extends IGraphNode<NodeType>> NodeType getAncestorWithLowestSemi(NodeType node, HashMap<NodeType, Integer> dfnum, HashMap<NodeType, NodeType> semi, HashMap<NodeType, NodeType> ancestor, HashMap<NodeType, NodeType> best) {
        IGraphNode a2 = (IGraphNode)ancestor.get(node);
        if (ancestor.get(a2) != null) {
            IGraphNode b2 = LengauerTarjan.getAncestorWithLowestSemi(a2, dfnum, semi, ancestor, best);
            ancestor.put(node, ancestor.get(a2));
            if (dfnum.get(semi.get(b2)) < dfnum.get(semi.get(best.get(node)))) {
                best.put(node, b2);
            }
        }
        return (NodeType)((IGraphNode)best.get(node));
    }

    private static <NodeType extends IGraphNode<NodeType>> void link(NodeType parent, NodeType node, HashMap<NodeType, NodeType> ancestor, HashMap<NodeType, NodeType> best) {
        ancestor.put(node, parent);
        best.put(node, node);
    }

    public static <NodeType extends IGraphNode<NodeType>> Pair<Tree<NodeType>, HashMap<NodeType, ITreeNode<NodeType>>> calculate(Collection<NodeType> nodes, NodeType rootNode) throws MalformedGraphException {
        IGraphNode node;
        int n2;
        int i2;
        Preconditions.checkNotNull(nodes, "Error: Nodes argument can not be null");
        if (nodes.size() == 0) {
            return new Pair<Object, Object>(null, null);
        }
        Preconditions.checkNotNull(rootNode, "Error: Root node argument can not be null");
        Preconditions.checkArgument(nodes.contains(rootNode), "Error: Root node is not part of the graph");
        int entryNodes = 0;
        for (IGraphNode node2 : nodes) {
            if (node2.getParents().size() != 0) continue;
            ++entryNodes;
        }
        if (entryNodes > 1) {
            throw new MalformedGraphException("Error: Can not calculate dominator trees for graphs with more than one entry node");
        }
        HashMap bucket = new HashMap();
        HashMap<IGraphNode, IGraphNode<Object>> idom = new HashMap<IGraphNode, IGraphNode<Object>>();
        HashMap best = new HashMap();
        HashMap<IGraphNode, IGraphNode> semi = new HashMap<IGraphNode, IGraphNode>();
        HashMap<IGraphNode, Object> ancestor = new HashMap<IGraphNode, Object>();
        HashMap<IGraphNode, IGraphNode> samedom = new HashMap<IGraphNode, IGraphNode>();
        HashMap vertex = new HashMap();
        HashMap parents = new HashMap();
        HashMap<IGraphNode, Integer> dfnum = new HashMap<IGraphNode, Integer>();
        for (IGraphNode node3 : nodes) {
            bucket.put(node3, new HashSet());
            dfnum.put(node3, -1);
            semi.put(node3, null);
            ancestor.put(node3, null);
            idom.put(node3, null);
            samedom.put(node3, null);
        }
        for (i2 = n2 = LengauerTarjan.depthFirstSearch(null, rootNode, dfnum, vertex, parents, 0); i2 >= 1; --i2) {
            IGraphNode parent;
            node = (IGraphNode)vertex.get(i2);
            IGraphNode s2 = parent = (IGraphNode)parents.get(node);
            for (IGraphNode v2 : node.getParents()) {
                IGraphNode temps = null;
                temps = (Integer)dfnum.get(v2) <= (Integer)dfnum.get(node) ? v2 : (IGraphNode)semi.get(LengauerTarjan.getAncestorWithLowestSemi(v2, dfnum, semi, ancestor, best));
                if ((Integer)dfnum.get(temps) >= (Integer)dfnum.get(s2)) continue;
                s2 = temps;
            }
            semi.put(node, s2);
            ((Set)bucket.get(s2)).add(node);
            LengauerTarjan.link(parent, node, ancestor, best);
            for (IGraphNode v2 : (Set)bucket.get(parent)) {
                IGraphNode y2 = LengauerTarjan.getAncestorWithLowestSemi(v2, dfnum, semi, ancestor, best);
                if (semi.get(y2) == semi.get(v2)) {
                    idom.put(v2, parent);
                    continue;
                }
                samedom.put(v2, y2);
            }
            ((Set)bucket.get(parent)).clear();
        }
        for (i2 = 1; i2 <= n2; ++i2) {
            node = (IGraphNode)vertex.get(i2);
            if (samedom.get(node) == null) continue;
            idom.put(node, (IGraphNode<Object>)idom.get(samedom.get(node)));
        }
        TreeNode treeRoot = null;
        HashMap nodeMap = new HashMap();
        for (Map.Entry node4 : idom.entrySet()) {
            TreeNode treeNode = new TreeNode(node4.getKey());
            nodeMap.put(node4.getKey(), treeNode);
            if (node4.getValue() != null) continue;
            treeRoot = treeNode;
        }
        for (Map.Entry node4 : idom.entrySet()) {
            IGraphNode dominatedNode = (IGraphNode)node4.getKey();
            IGraphNode dominatorNode = (IGraphNode)node4.getValue();
            if (dominatorNode == null) continue;
            ((ITreeNode)nodeMap.get(dominatorNode)).addChild((ITreeNode)nodeMap.get(dominatedNode));
            ((ITreeNode)nodeMap.get(dominatedNode)).setParent((ITreeNode)nodeMap.get(dominatorNode));
        }
        return new Pair<Tree<NodeType>, HashMap<NodeType, ITreeNode<NodeType>>>(new Tree(treeRoot), nodeMap);
    }

    public static <NodeType extends IGraphNode<NodeType>> Pair<Tree<NodeType>, HashMap<NodeType, ITreeNode<NodeType>>> calculate(IDirectedGraph<NodeType, ?> graph, NodeType rootNode) throws MalformedGraphException {
        Preconditions.checkNotNull(graph, "Error: Graph argument can not be null");
        Preconditions.checkNotNull(rootNode, "Error: Root node argument can not be null");
        if (graph.nodeCount() == 0) {
            return new Pair<Object, Object>(null, null);
        }
        return LengauerTarjan.calculate(graph.getNodes(), rootNode);
    }
}

