/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.types.graphs;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import com.google.security.zynamics.zylib.types.graphs.IGraphEdge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MutableDirectedGraph<NodeType, EdgeType extends IGraphEdge<NodeType>>
implements IDirectedGraph<NodeType, EdgeType>,
Iterable<NodeType> {
    private final List<NodeType> m_nodes;
    private final List<EdgeType> m_edges;
    private final Map<NodeType, List<EdgeType>> m_nodeToEdges = new HashMap<NodeType, List<EdgeType>>();

    public MutableDirectedGraph(List<NodeType> nodes, List<EdgeType> edges) {
        this.m_nodes = Preconditions.checkNotNull(nodes, "Nodes argument can not be null");
        this.m_edges = Preconditions.checkNotNull(edges, "Edges argument can not be null");
        for (NodeType node : nodes) {
            Preconditions.checkNotNull(node, "Node list contains null-nodes");
            this.m_nodeToEdges.put(node, new ArrayList());
        }
        for (IGraphEdge edge : edges) {
            this.updateNodeToEdgeMapping(edge);
        }
    }

    private void updateNodeToEdgeMapping(EdgeType edge) {
        Preconditions.checkNotNull(edge, "Error: edge argument can not be null");
        if (this.m_nodeToEdges.get(edge.getSource()) == null) {
            throw new IllegalStateException("Error: The given edge has a source node which is not known to the graph.");
        }
        this.m_nodeToEdges.get(edge.getSource()).add(edge);
        if (this.m_nodeToEdges.get(edge.getTarget()) == null) {
            throw new IllegalStateException("Error: the given edge has a target node which is not known to the graph.");
        }
        this.m_nodeToEdges.get(edge.getTarget()).add(edge);
    }

    public void addEdge(EdgeType edge) {
        Preconditions.checkNotNull(edge, "Edge argument can not be null");
        this.m_edges.add(edge);
        this.updateNodeToEdgeMapping(edge);
    }

    public void addNode(NodeType node) {
        Preconditions.checkNotNull(node, "Node argument can not be null");
        this.m_nodes.add(node);
        this.m_nodeToEdges.put(node, new ArrayList());
    }

    @Override
    public int edgeCount() {
        return this.m_edges.size();
    }

    @Override
    public List<EdgeType> getEdges() {
        return Collections.unmodifiableList(this.m_edges);
    }

    @Override
    public List<NodeType> getNodes() {
        return Collections.unmodifiableList(this.m_nodes);
    }

    @Override
    public Iterator<NodeType> iterator() {
        return this.m_nodes.iterator();
    }

    @Override
    public int nodeCount() {
        return this.m_nodes.size();
    }

    public void removeEdge(EdgeType edge) {
        Preconditions.checkArgument(this.m_edges.remove(edge), "Error: Edge was not part of the graph");
        this.m_nodeToEdges.get(edge.getSource()).remove(edge);
        this.m_nodeToEdges.get(edge.getTarget()).remove(edge);
    }

    public void removeNode(NodeType node) {
        Preconditions.checkArgument(this.m_nodes.remove(node), String.format("Error: Node '%s' was not part of the graph", node));
        this.m_edges.removeAll((Collection)this.m_nodeToEdges.get(node));
        this.m_nodeToEdges.remove(node);
    }
}

