/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.types.graphs;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeFilter;
import com.google.security.zynamics.zylib.types.graphs.IDirectedGraph;
import com.google.security.zynamics.zylib.types.graphs.IGraphNode;
import com.google.security.zynamics.zylib.types.graphs.algorithms.LengauerTarjan;
import com.google.security.zynamics.zylib.types.graphs.algorithms.MalformedGraphException;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import com.google.security.zynamics.zylib.types.trees.Tree;
import com.google.security.zynamics.zylib.types.trees.TreeAlgorithms;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class GraphAlgorithms {
    private GraphAlgorithms() {
    }

    private static <NodeType extends IGraphNode<NodeType>> void getPredecessors(IGraphNode<NodeType> node, Set<NodeType> predecessors, Set<NodeType> visited) {
        for (IGraphNode parent : node.getParents()) {
            if (visited.contains(parent)) continue;
            visited.add(parent);
            predecessors.add(parent);
            GraphAlgorithms.getPredecessors(parent, predecessors, visited);
        }
    }

    private static <NodeType extends IGraphNode<NodeType>> void getPredecessorsInternal(NodeType node, int depth, List<NodeType> nodes, Set<NodeType> visited) {
        if (depth <= 0) {
            return;
        }
        for (IGraphNode parent : node.getParents()) {
            if (visited.contains(parent)) continue;
            visited.add(parent);
            nodes.add(parent);
            GraphAlgorithms.getPredecessorsInternal(parent, depth - 1, nodes, visited);
        }
    }

    private static <NodeType extends IGraphNode<NodeType>> void getSuccessors(IGraphNode<NodeType> node, Set<NodeType> successors, Set<NodeType> visited) {
        for (IGraphNode child : node.getChildren()) {
            if (visited.contains(child)) continue;
            visited.add(child);
            successors.add(child);
            GraphAlgorithms.getSuccessors(child, successors, visited);
        }
    }

    private static <NodeType extends IGraphNode<NodeType>> void getSuccessorsInternal(NodeType node, int depth, List<NodeType> nodes, HashSet<NodeType> visited) {
        if (depth <= 0) {
            return;
        }
        for (IGraphNode child : node.getChildren()) {
            if (visited.contains(child)) continue;
            visited.add(child);
            nodes.add(child);
            GraphAlgorithms.getSuccessorsInternal(child, depth - 1, nodes, visited);
        }
    }

    public static <NodeType extends IGraphNode<NodeType>> Collection<NodeType> collectChildren(NodeType node, INodeFilter<NodeType> filter) {
        Preconditions.checkNotNull(node, "Error: Node argument can't be null");
        return GraphAlgorithms.collectNodes(node.getChildren(), filter);
    }

    public static <NodeType> Collection<NodeType> collectNodes(Collection<? extends NodeType> nodes, INodeFilter<NodeType> filter) {
        Preconditions.checkNotNull(nodes, "Error: Nodes argument can't be null");
        Preconditions.checkNotNull(filter, "Error: Filter argument can't be null");
        ArrayList<NodeType> filteredNodes = new ArrayList<NodeType>();
        for (NodeType child : nodes) {
            if (!filter.qualifies(child)) continue;
            filteredNodes.add(child);
        }
        return filteredNodes;
    }

    public static <NodeType extends IGraphNode<NodeType>> Collection<NodeType> collectParents(NodeType node, INodeFilter<NodeType> filter) {
        Preconditions.checkNotNull(node, "Error: Node argument can't be null");
        return GraphAlgorithms.collectNodes(node.getParents(), filter);
    }

    public static <NodeType extends IGraphNode<NodeType>> HashMap<NodeType, ArrayList<NodeType>> getBackEdges(IDirectedGraph<NodeType, ?> graph, NodeType rootNode) throws MalformedGraphException {
        Preconditions.checkNotNull(graph, "Error: Graph argument can not be null");
        Preconditions.checkNotNull(rootNode, "Error: Root Node argument can not be null");
        HashMap nodeToBackedges = new HashMap();
        Pair<Tree<NodeType>, HashMap<NodeType, ITreeNode<NodeType>>> dominatorPair = LengauerTarjan.calculate(graph, rootNode);
        HashMap<NodeType, ITreeNode<NodeType>> dominatorTreeMapping = dominatorPair.second();
        HashMap<ITreeNode<NodeType>, Set<ITreeNode<NodeType>>> treeNodeDominateRelation = TreeAlgorithms.getDominateRelation(dominatorPair.first().getRootNode());
        for (IGraphNode t2 : graph.getNodes()) {
            ArrayList<IGraphNode> currentNodesBackedges = new ArrayList<IGraphNode>();
            Set<ITreeNode<NodeType>> currentTreeNodeDominateRelation = treeNodeDominateRelation.get(dominatorTreeMapping.get(t2));
            if (currentTreeNodeDominateRelation != null) {
                for (IGraphNode graphNode : t2.getChildren()) {
                    if (!currentTreeNodeDominateRelation.contains(dominatorTreeMapping.get(graphNode))) continue;
                    currentNodesBackedges.add(graphNode);
                }
            }
            nodeToBackedges.put(t2, currentNodesBackedges);
        }
        return nodeToBackedges;
    }

    public static <T extends IGraphNode<T>> ArrayList<Set<T>> getGraphLoops(IDirectedGraph<T, ?> graph) throws MalformedGraphException {
        IGraphNode rootNode = null;
        ArrayList<Set<T>> resultList = new ArrayList<Set<T>>();
        for (IGraphNode currentNode : graph.getNodes()) {
            if (currentNode.getParents().size() != 0) continue;
            rootNode = currentNode;
            break;
        }
        if (rootNode == null) {
            return null;
        }
        HashMap<Object, ArrayList<Object>> nodeToBackEdges = GraphAlgorithms.getBackEdges(graph, rootNode);
        for (IGraphNode graphNode : graph.getNodes()) {
            ArrayList<Object> nodesBackEdges = nodeToBackEdges.get(graphNode);
            for (IGraphNode iGraphNode : nodesBackEdges) {
                resultList.add(GraphAlgorithms.getLoopNodes(graphNode, iGraphNode));
            }
        }
        return resultList;
    }

    public static <NodeType extends IGraphNode<NodeType>> Set<NodeType> getLoopNodes(NodeType sourceNode, NodeType destinationNode) {
        if (sourceNode == destinationNode) {
            ArrayList<NodeType> nodeList = new ArrayList<NodeType>();
            nodeList.add(sourceNode);
            return new HashSet(nodeList);
        }
        ArrayList<NodeType> upwardsNodes = new ArrayList<NodeType>();
        upwardsNodes.add(destinationNode);
        HashSet<IGraphNode> resolveUpwards = new HashSet<IGraphNode>(upwardsNodes);
        Stack<IGraphNode> upwardsWorkingList = new Stack<IGraphNode>();
        upwardsWorkingList.push(sourceNode);
        while (!upwardsWorkingList.empty()) {
            IGraphNode currentNode = (IGraphNode)upwardsWorkingList.pop();
            resolveUpwards.add(currentNode);
            for (IGraphNode currentParentNode : currentNode.getParents()) {
                if (resolveUpwards.contains(currentParentNode)) continue;
                resolveUpwards.add(currentParentNode);
                upwardsWorkingList.push(currentParentNode);
            }
        }
        ArrayList downwardsNodes = new ArrayList();
        HashSet<IGraphNode> resolveDownwards = new HashSet<IGraphNode>(downwardsNodes);
        Stack<IGraphNode> downwardsWorkingList = new Stack<IGraphNode>();
        downwardsWorkingList.push(destinationNode);
        while (!downwardsWorkingList.empty()) {
            IGraphNode currentNode = (IGraphNode)downwardsWorkingList.pop();
            resolveDownwards.add(currentNode);
            for (IGraphNode currentChildNode : currentNode.getChildren()) {
                if (resolveDownwards.contains(currentChildNode)) continue;
                resolveDownwards.add(currentChildNode);
                downwardsWorkingList.push(currentChildNode);
            }
        }
        resolveUpwards.retainAll(resolveDownwards);
        return resolveUpwards;
    }

    public static <NodeType extends IGraphNode<NodeType>> Collection<NodeType> getPredecessors(Collection<NodeType> nodes) {
        Preconditions.checkNotNull(nodes, "Error: Nodes argument can't be null");
        HashSet<NodeType> predecessors = new HashSet<NodeType>();
        for (IGraphNode zyGraphNode : nodes) {
            predecessors.addAll(GraphAlgorithms.getPredecessors(zyGraphNode));
        }
        return predecessors;
    }

    public static <NodeType extends IGraphNode<NodeType>> Set<NodeType> getPredecessors(IGraphNode<NodeType> node) {
        Preconditions.checkNotNull(node, "Error: Start node can't be null");
        HashSet predecessors = new HashSet();
        HashSet visited = new HashSet();
        GraphAlgorithms.getPredecessors(node, predecessors, visited);
        return predecessors;
    }

    public static <NodeType extends IGraphNode<NodeType>> Set<NodeType> getPredecessorsUpToNode(IGraphNode<NodeType> childNode, IGraphNode<NodeType> maximumParentNode) {
        Preconditions.checkNotNull(childNode, "Error: endNode argument can not be null");
        Preconditions.checkNotNull(maximumParentNode, "Error: startNode argument can not be null");
        HashSet predecessors = Sets.newHashSet();
        HashSet<IGraphNode<NodeType>> visited = Sets.newHashSet();
        visited.add(maximumParentNode);
        GraphAlgorithms.getPredecessors(childNode, predecessors, visited);
        return predecessors;
    }

    public static <NodeType extends IGraphNode<NodeType>> List<NodeType> getPredecessors(Iterable<NodeType> selectedNodes, int depth) {
        ArrayList<IGraphNode> nodes = new ArrayList<IGraphNode>();
        for (IGraphNode node : selectedNodes) {
            nodes.addAll(GraphAlgorithms.getPredecessors(node, depth));
        }
        return nodes;
    }

    public static <NodeType extends IGraphNode<NodeType>> List<NodeType> getPredecessors(NodeType node, int depth) {
        ArrayList nodes = new ArrayList();
        GraphAlgorithms.getPredecessorsInternal(node, depth, nodes, new HashSet());
        return nodes;
    }

    public static <NodeType extends IGraphNode<NodeType>> Collection<NodeType> getSuccessors(Collection<NodeType> nodes) {
        Preconditions.checkNotNull(nodes, "Error: Nodes argument can't be null");
        HashSet<NodeType> successors = new HashSet<NodeType>();
        for (IGraphNode zyGraphNode : nodes) {
            successors.addAll(GraphAlgorithms.getSuccessors(zyGraphNode));
        }
        return successors;
    }

    public static <NodeType extends IGraphNode<NodeType>> Set<NodeType> getSuccessors(IGraphNode<NodeType> node) {
        Preconditions.checkNotNull(node, "Error: Start node can't be null");
        HashSet successors = new HashSet();
        HashSet visited = new HashSet();
        GraphAlgorithms.getSuccessors(node, successors, visited);
        return successors;
    }

    public static <NodeType extends IGraphNode<NodeType>> Set<NodeType> getSuccessorsDownToNode(IGraphNode<NodeType> parentNode, IGraphNode<NodeType> maximumChildNode) {
        Preconditions.checkNotNull(parentNode, "Error: parent node can't be null");
        Preconditions.checkNotNull(maximumChildNode, "Error: maximumChildNode argument can not be null");
        HashSet successors = new HashSet();
        HashSet visited = new HashSet();
        GraphAlgorithms.getSuccessors(parentNode, successors, visited);
        return successors;
    }

    public static <NodeType extends IGraphNode<NodeType>> List<NodeType> getSuccessors(Iterable<NodeType> selectedNodes, int depth) {
        ArrayList<IGraphNode> nodes = new ArrayList<IGraphNode>();
        for (IGraphNode node : selectedNodes) {
            nodes.addAll(GraphAlgorithms.getSuccessors(node, depth));
        }
        return nodes;
    }

    public static <NodeType extends IGraphNode<NodeType>> List<NodeType> getSuccessors(NodeType node, int depth) {
        ArrayList nodes = new ArrayList();
        GraphAlgorithms.getSuccessorsInternal(node, depth, nodes, new HashSet());
        return nodes;
    }

    public static <NodeType extends IGraphNode<NodeType>> boolean isRootNode(NodeType node) {
        return node.getParents().size() == 0;
    }
}

