/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.types.common;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import com.google.security.zynamics.zylib.types.common.ICollectionMapper;
import com.google.security.zynamics.zylib.types.common.IFilteredItemCallback;
import com.google.security.zynamics.zylib.types.common.IItemCallback;
import com.google.security.zynamics.zylib.types.common.IIterableCollection;
import com.google.security.zynamics.zylib.types.common.IterationMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CollectionHelpers {
    public static <ItemType> boolean all(Collection<ItemType> collection, ICollectionFilter<ItemType> callback) {
        for (ItemType item : collection) {
            if (callback.qualifies(item)) continue;
            return false;
        }
        return true;
    }

    public static <ItemType> boolean any(Collection<ItemType> collection, ICollectionFilter<ItemType> callback) {
        for (ItemType item : collection) {
            if (!callback.qualifies(item)) continue;
            return true;
        }
        return false;
    }

    public static <ItemType> int count(Collection<? extends ItemType> collection, ItemType item) {
        int counter = 0;
        for (ItemType itemType : collection) {
            if (itemType != item) continue;
            ++counter;
        }
        return counter;
    }

    public static <ItemType> int countIf(Collection<? extends ItemType> collection, ICollectionFilter<ItemType> item) {
        int counter = 0;
        for (ItemType itemType : collection) {
            if (!item.qualifies(itemType)) continue;
            ++counter;
        }
        return counter;
    }

    public static <ItemType> List<ItemType> filter(Collection<? extends ItemType> collection, ICollectionFilter<ItemType> callback) {
        ArrayList<ItemType> filteredItems = new ArrayList<ItemType>();
        for (ItemType item : collection) {
            if (!callback.qualifies(item)) continue;
            filteredItems.add(item);
        }
        return filteredItems;
    }

    public static <T> Collection<T> flatten(Collection<? extends Collection<T>> second) {
        ArrayList<T> returnList = new ArrayList<T>();
        for (Collection<T> collection : second) {
            returnList.addAll(collection);
        }
        return returnList;
    }

    public static <ItemType, CollectionType extends IIterableCollection<IItemCallback<ItemType>>> void iterate(CollectionType collection, final ICollectionFilter<ItemType> filter, final IItemCallback<ItemType> callback) {
        Preconditions.checkNotNull(collection, "Error: Graph argument can't be null");
        Preconditions.checkNotNull(callback, "Error: Callback argument can't be null");
        Preconditions.checkNotNull(filter, "Error: Filter argument can't be null");
        collection.iterate(new IItemCallback<ItemType>(){

            @Override
            public IterationMode next(ItemType node) {
                if (filter.qualifies(node)) {
                    return callback.next(node);
                }
                return IterationMode.CONTINUE;
            }
        });
    }

    public static <ItemType, CollectionType extends IIterableCollection<IItemCallback<ItemType>>> void iterate(CollectionType collection, final IFilteredItemCallback<ItemType> callback) {
        collection.iterate(new IItemCallback<ItemType>(){

            @Override
            public IterationMode next(ItemType node) {
                if (callback.qualifies(node)) {
                    return callback.next(node);
                }
                return IterationMode.CONTINUE;
            }
        });
    }

    public static <InputType, OutputType> List<OutputType> map(Collection<? extends InputType> elements, ICollectionMapper<InputType, OutputType> mapper) {
        ArrayList<OutputType> list = new ArrayList<OutputType>();
        for (InputType element : elements) {
            list.add(mapper.map(element));
        }
        return list;
    }

    public static <ItemType> ItemType nth(Collection<? extends ItemType> collection, ICollectionFilter<ItemType> callback, int index) {
        int counter = 0;
        for (ItemType itemType : collection) {
            if (!callback.qualifies(itemType)) continue;
            if (counter == index) {
                return itemType;
            }
            ++counter;
        }
        throw new IllegalStateException("Error: nth element does not exist");
    }

    public static <S, T> Pair<Collection<S>, Collection<T>> unzip(Collection<Pair<S, T>> elements) {
        ArrayList<S> firstList = new ArrayList<S>(elements.size());
        ArrayList<T> secondList = new ArrayList<T>(elements.size());
        for (Pair<S, T> pair : elements) {
            firstList.add(pair.first());
            secondList.add(pair.second());
        }
        return new Pair<Collection<S>, Collection<T>>(firstList, secondList);
    }
}

