/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.system;

import com.google.security.zynamics.zylib.io.FileUtils;
import java.io.File;

public final class SystemHelpers {
    public static String getAllUsersApplicationDataDirectory() {
        String result;
        if (SystemHelpers.isRunningWindows()) {
            result = System.getenv("ProgramData");
            if (result == null) {
                String appData = System.getenv("APPDATA");
                String string2 = String.valueOf(System.getenv("ALLUSERSPROFILE"));
                String string3 = String.valueOf(appData != null ? appData.substring(appData.lastIndexOf(92)) : "\\Application Data");
                result = string3.length() != 0 ? string2.concat(string3) : new String(string2);
            }
        } else {
            result = SystemHelpers.isRunningLinux() ? "/etc/opt" : (SystemHelpers.isRunningMacOSX() ? "/etc/opt" : System.getProperty("user.home"));
        }
        return FileUtils.ensureTrailingSlash(result);
    }

    public static String getAllUsersApplicationDataDirectory(String product) {
        String string2 = SystemHelpers.getAllUsersApplicationDataDirectory();
        String string3 = String.valueOf(File.separator);
        String string4 = String.valueOf(File.separator);
        return new StringBuilder(8 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(product).length() + String.valueOf(string4).length()).append(string2).append("zynamics").append(string3).append(product).append(string4).toString();
    }

    public static String getApplicationDataDirectory() {
        return FileUtils.ensureTrailingSlash(SystemHelpers.isRunningWindows() ? System.getenv("APPDATA") : System.getProperty("user.home"));
    }

    public static String getApplicationDataDirectory(String product) {
        String string2 = SystemHelpers.getApplicationDataDirectory();
        String string3 = SystemHelpers.isRunningWindows() ? "" : ".";
        String string4 = String.valueOf(File.separator);
        String string5 = String.valueOf(File.separator);
        return new StringBuilder(8 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(product).length() + String.valueOf(string5).length()).append(string2).append(string3).append("zynamics").append(string4).append(product).append(string5).toString();
    }

    public static String getTempDirectory() {
        return FileUtils.ensureTrailingSlash(System.getProperty("java.io.tmpdir"));
    }

    public static String getTempDirectory(String product) {
        String string2 = SystemHelpers.getTempDirectory();
        String string3 = String.valueOf(File.separator);
        String string4 = String.valueOf(File.separator);
        return new StringBuilder(8 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(product).length() + String.valueOf(string4).length()).append(string2).append("zynamics").append(string3).append(product).append(string4).toString();
    }

    public static String getUserDirectory() {
        return FileUtils.ensureTrailingSlash(System.getProperty("user.home"));
    }

    public static boolean isRunningLinux() {
        return System.getProperty("os.name").startsWith("Linux");
    }

    public static boolean isRunningMacOSX() {
        return System.getProperty("os.name").startsWith("Mac");
    }

    public static boolean isRunningWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static boolean is64BitArchitecture() {
        if (SystemHelpers.isRunningWindows()) {
            return "AMD64".equals(System.getenv("PROCESSOR_ARCHITECTURE")) || "AMD64".equals(System.getenv("PROCESSOR_ARCHITEW6432"));
        }
        throw new RuntimeException("Not implememted for Linux or Mac yet.");
    }
}

