/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.system;

import com.google.security.zynamics.zylib.system.IdaException;
import com.google.security.zynamics.zylib.system.SystemHelpers;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public final class IdaHelpers {
    public static final String IDA32_EXECUTABLE;
    public static final String IDA64_EXECUTABLE;

    public static Process createIdaProcess(String idaExe, File idcPath, String idbFileName, String outputDirectory) throws IdaException {
        String idcFileString = idcPath.getAbsolutePath();
        String sArgument = IdaHelpers.getSArgument(idcFileString, SystemHelpers.isRunningWindows());
        String[] stringArray = new String[5];
        stringArray[0] = idaExe;
        stringArray[1] = "-A";
        String string2 = String.valueOf(outputDirectory);
        stringArray[2] = string2.length() != 0 ? "-OExporterModule:".concat(string2) : new String("-OExporterModule:");
        stringArray[3] = sArgument;
        stringArray[4] = idbFileName;
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        try {
            Process processInfo = null;
            processBuilder.redirectErrorStream(true);
            processInfo = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(processInfo.getInputStream()));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException exception) {
                reader.close();
            }
            reader.close();
            return processInfo;
        }
        catch (Exception exception) {
            String string3 = String.valueOf(exception);
            throw new IdaException(new StringBuilder(51 + String.valueOf(string3).length()).append("Failed attempting to launch the importer with IDA: ").append(string3).toString(), exception);
        }
    }

    public static String getSArgument(String idcFile, boolean isRunningWindows) {
        return isRunningWindows ? new StringBuilder(6 + String.valueOf(idcFile).length()).append("-S\\\"").append(idcFile).append("\\\"").toString() : new StringBuilder(4 + String.valueOf(idcFile).length()).append("-S\"").append(idcFile).append("\"").toString();
    }

    static {
        if (SystemHelpers.isRunningWindows()) {
            IDA32_EXECUTABLE = "idaq.exe";
            IDA64_EXECUTABLE = "idaq64.exe";
        } else {
            IDA32_EXECUTABLE = "idaq";
            IDA64_EXECUTABLE = "idaq64";
        }
    }
}

