/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.plugins;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public final class JarResources {
    private final Hashtable<String, Integer> htSizes = new Hashtable();
    private final Hashtable<String, byte[]> htJarContents = new Hashtable();
    private final String jarFileName;
    public boolean debugOn = false;

    public JarResources(String jarFileName) {
        this.jarFileName = jarFileName;
        this.init();
    }

    private String dumpZipEntry(ZipEntry ze) {
        StringBuffer sb = new StringBuffer();
        if (ze.isDirectory()) {
            sb.append("d ");
        } else {
            sb.append("f ");
        }
        if (ze.getMethod() == 0) {
            sb.append("stored   ");
        } else {
            sb.append("defalted ");
        }
        sb.append(ze.getName());
        sb.append("\t");
        long l2 = ze.getSize();
        sb.append(new StringBuilder(20).append(l2).toString());
        if (ze.getMethod() == 8) {
            l2 = ze.getCompressedSize();
            sb.append(new StringBuilder(21).append("/").append(l2).toString());
        }
        return sb.toString();
    }

    private void init() {
        try {
            ZipFile zf = new ZipFile(this.jarFileName);
            Enumeration<? extends ZipEntry> e2 = zf.entries();
            while (e2.hasMoreElements()) {
                ZipEntry ze = e2.nextElement();
                if (this.debugOn) {
                    System.out.println(this.dumpZipEntry(ze));
                }
                this.htSizes.put(ze.getName(), (int)ze.getSize());
            }
            zf.close();
            FileInputStream fis = new FileInputStream(this.jarFileName);
            BufferedInputStream bis = new BufferedInputStream(fis);
            ZipInputStream zis = new ZipInputStream(bis);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                int size;
                if (ze.isDirectory()) continue;
                if (this.debugOn) {
                    String string2 = String.valueOf(ze.getName());
                    long l2 = ze.getSize();
                    System.out.println(new StringBuilder(44 + String.valueOf(string2).length()).append("ze.getName()=").append(string2).append(",").append("getSize()=").append(l2).toString());
                }
                if ((size = (int)ze.getSize()) == -1) {
                    size = this.htSizes.get(ze.getName());
                }
                byte[] b2 = new byte[size];
                int rb = 0;
                int chunk2 = 0;
                while (size - rb > 0 && (chunk2 = zis.read(b2, rb, size - rb)) != -1) {
                    rb += chunk2;
                }
                this.htJarContents.put(ze.getName(), b2);
                if (!this.debugOn) continue;
                String string3 = String.valueOf(ze.getName());
                int n2 = rb;
                int n3 = size;
                long l3 = ze.getCompressedSize();
                System.out.println(new StringBuilder(60 + String.valueOf(string3).length()).append(string3).append("  rb=").append(n2).append(",size=").append(n3).append(",csize=").append(l3).toString());
            }
            zis.close();
        }
        catch (NullPointerException e3) {
            System.out.println("done.");
        }
        catch (IOException e4) {
            e4.printStackTrace();
        }
    }

    public byte[] getResource(String name) {
        return this.htJarContents.get(name);
    }
}

