/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.io;

import com.google.security.zynamics.zylib.io.IDirectoryTraversalCallback;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;

public class DirUtils {
    public static void traverse(File directory, IDirectoryTraversalCallback callback) {
        DirUtils.traverse(directory, callback, true);
    }

    public static void traverse(File directory, IDirectoryTraversalCallback callback, boolean recurse) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        callback.entering(directory);
        for (File file : files) {
            if (file.isDirectory()) continue;
            callback.nextFile(file);
        }
        if (recurse) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                DirUtils.traverse(file, callback);
            }
        }
        callback.leaving(directory);
    }

    public static void traverse(File directory, IDirectoryTraversalCallback callback, Comparator<File> sorter) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        Arrays.sort(files, sorter);
        callback.entering(directory);
        for (File file : files) {
            if (file.isDirectory()) continue;
            callback.nextFile(file);
        }
        for (File file : files) {
            if (!file.isDirectory()) continue;
            DirUtils.traverse(file, callback);
        }
        callback.leaving(directory);
    }
}

