/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.wrappers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.types.graphs.IGraphNode;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ViewNodeAdapter
implements IGraphNode<ViewNodeAdapter> {
    private final IViewNode<?> m_viewNode;

    public ViewNodeAdapter(IViewNode<?> viewNode) {
        Preconditions.checkNotNull(viewNode, "Error: View node argument can not be null");
        this.m_viewNode = viewNode;
    }

    private static <NodeType extends ZyGraphNode<? extends IViewNode<?>>> Collection<NodeType> convert(AbstractZyGraph<NodeType, ?> graph, Collection<? extends IViewNode<?>> nodes) {
        ArrayList<NodeType> list = new ArrayList<NodeType>();
        for (IViewNode<?> node : nodes) {
            list.add(graph.getNode(node));
        }
        return list;
    }

    public static <NodeType extends ZyGraphNode<? extends IViewNode<?>>> Collection<NodeType> unwrap(AbstractZyGraph<NodeType, ?> graph, Collection<ViewNodeAdapter> successors) {
        FilledList nodes = new FilledList();
        for (ViewNodeAdapter fooWrapper : successors) {
            nodes.add(fooWrapper.getNode());
        }
        return ViewNodeAdapter.convert(graph, nodes);
    }

    public static List<ViewNodeAdapter> wrap(List<? extends IViewNode<?>> sel) {
        ArrayList<ViewNodeAdapter> l2 = new ArrayList<ViewNodeAdapter>();
        for (IViewNode<?> viewNode : sel) {
            l2.add(new ViewNodeAdapter(viewNode));
        }
        return l2;
    }

    public boolean equals(Object ohs) {
        return ohs instanceof ViewNodeAdapter && ((ViewNodeAdapter)ohs).getNode() == this.getNode();
    }

    @Override
    public List<ViewNodeAdapter> getChildren() {
        List<?> edges = this.m_viewNode.getOutgoingEdges();
        ArrayList nodes = new ArrayList();
        for (IViewEdge viewEdge : edges) {
            nodes.add(viewEdge.getTarget());
        }
        return ViewNodeAdapter.wrap(nodes);
    }

    public IViewNode<?> getNode() {
        return this.m_viewNode;
    }

    @Override
    public List<ViewNodeAdapter> getParents() {
        List<?> edges = this.m_viewNode.getIncomingEdges();
        ArrayList nodes = new ArrayList();
        for (IViewEdge viewEdge : edges) {
            nodes.add(viewEdge.getSource());
        }
        return ViewNodeAdapter.wrap(nodes);
    }

    public int hashCode() {
        return this.m_viewNode.hashCode();
    }
}

