/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.UndoHistroy;

import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyEditableObject;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.UndoHistroy.CUndoHistory;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.UndoHistroy.CUndoStateData;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import java.util.HashMap;
import java.util.Map;

public class CUndoManager {
    private final Map<ZyLabelContent, CUndoHistory> m_undoHistories = new HashMap<ZyLabelContent, CUndoHistory>();
    private ZyLabelContent m_labelContent = null;

    private CUndoHistory getUndoHistory() {
        if (this.m_labelContent == null) {
            return null;
        }
        CUndoHistory undoHistory = this.m_undoHistories.get(this.m_labelContent);
        if (undoHistory == null) {
            undoHistory = new CUndoHistory();
            this.m_undoHistories.put(this.m_labelContent, undoHistory);
        }
        return undoHistory;
    }

    public void addUndoState(ZyLabelContent labelContent, Object persistantModel, IZyEditableObject editableObject, String changedText, boolean isAboveLineComment, boolean isBehindLineComment, boolean isLabelComment, int caretStartX, int caretMousePressedX, int caretMousePressedY, int caretEndX, int caretMouseReleasedX, int caretMouseReleasedY) {
        if (persistantModel == null) {
            return;
        }
        CUndoHistory undoHistory = this.getUndoHistory();
        if (undoHistory != null) {
            CUndoStateData undoData = new CUndoStateData(labelContent, persistantModel, editableObject, changedText, isAboveLineComment, isBehindLineComment, isLabelComment, caretStartX, caretMousePressedX, caretMousePressedY, caretEndX, caretMouseReleasedX, caretMouseReleasedY);
            undoHistory.addState(undoData);
        }
    }

    public void redo() {
        CUndoHistory undoHistory = this.getUndoHistory();
        if (undoHistory != null) {
            undoHistory.redo();
        }
    }

    public void setLabelContent(ZyLabelContent labelContent) {
        this.m_labelContent = labelContent;
    }

    public void undo() {
        CUndoHistory undoHistory = this.getUndoHistory();
        if (undoHistory != null) {
            undoHistory.undo();
        }
    }
}

