/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.Tokenizer;

import com.google.common.base.Preconditions;

public class CMultiCommentLineTokenizer {
    private final String m_text;
    private final String m_delimiter;
    private int m_pointer = 0;

    public CMultiCommentLineTokenizer(String text2, String delimiter) {
        this.m_delimiter = Preconditions.checkNotNull(delimiter, "Error: Text delimiter can't be null.");
        Preconditions.checkArgument(!"".equals(delimiter), "Error: Text delimiter can't be empty.");
        this.m_text = Preconditions.checkNotNull(text2, "Error: Text can't be null.");
    }

    public boolean hasMoreTokens() {
        return this.m_pointer < this.m_text.length();
    }

    public String nextToken() {
        if (this.m_pointer >= this.m_text.length()) {
            return null;
        }
        int startPointer = this.m_pointer;
        int endPointer = this.m_text.indexOf(this.m_delimiter, startPointer) + 1;
        if (endPointer == 0) {
            endPointer = this.m_text.length();
        }
        this.m_pointer = endPointer;
        String token2 = this.m_text.substring(startPointer, endPointer);
        if (!(this.hasMoreTokens() || token2.isEmpty() || token2.endsWith("\r"))) {
            token2 = String.valueOf(token2).concat("\r");
        }
        return token2;
    }
}

