/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours;

import com.google.security.zynamics.zylib.general.ClipboardHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyEditableObject;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CAbstractKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.UndoHistroy.CUndoManager;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import java.awt.Point;

public class CInsertKeyBehavior
extends CAbstractKeyBehavior {
    private int m_caretX = 0;
    private int m_caretY = 0;
    private boolean m_isAboveComment;
    private boolean m_isBehindComment;
    private boolean m_isLabelComment;
    private boolean m_wasUneditableSelection;
    private IZyEditableObject m_editableObject;

    public CInsertKeyBehavior(CUndoManager undoManager) {
        super(undoManager);
    }

    private boolean isCopy() {
        return this.isCtrlPressed() && !this.isShiftPressed() && !this.isAltPressed();
    }

    private boolean isPaste() {
        return !this.isCtrlPressed() && this.isShiftPressed() && !this.isAltPressed();
    }

    @Override
    protected void initUndoHistory() {
        if (this.isPaste()) {
            int x2 = this.getCaretEndPosX();
            int y2 = this.getCaretMouseReleasedY();
            ZyLineContent lineContent = this.getLineContent(y2);
            IZyEditableObject lineFragmentObject = lineContent.getLineFragmentObjectAt(x2);
            boolean isNewBehindLineComment = false;
            String text2 = "";
            this.m_isAboveComment = this.isAboveLineComment(y2);
            this.m_isLabelComment = this.isLabelComment(y2);
            if (x2 == lineContent.getText().length() && !this.isComment(x2, y2)) {
                this.m_isBehindComment = true;
                isNewBehindLineComment = true;
                lineFragmentObject = lineContent.getLineObject();
            } else {
                this.m_isBehindComment = this.isBehindLineComment(x2, y2);
            }
            this.m_editableObject = lineFragmentObject;
            if (lineFragmentObject != null) {
                if (!isNewBehindLineComment) {
                    text2 = lineContent.getText().substring(lineFragmentObject.getStart(), lineFragmentObject.getEnd());
                    if (this.isComment(x2, y2)) {
                        text2 = this.getMultiLineComment(y2);
                    }
                }
                this.udpateUndolist(this.getLabelContent(), lineContent.getLineObject().getPersistentModel(), lineFragmentObject, text2, this.m_isAboveComment, this.m_isBehindComment, this.m_isLabelComment, this.getCaretStartPosX(), this.getCaretMousePressedX(), this.getCaretMousePressedY(), this.getCaretEndPosX(), this.getCaretMouseReleasedX(), this.getCaretMouseReleasedY());
            }
        }
    }

    @Override
    protected void updateCaret() {
        if (this.isCopy() || this.isPaste()) {
            this.setCaret(this.m_caretX, this.m_caretX, this.m_caretY, this.m_caretX, this.m_caretX, this.m_caretY);
        }
    }

    @Override
    protected void updateClipboard() {
        if (this.isCopy()) {
            String clipboardText = this.getSelectedText();
            ClipboardHelpers.copyToClipboard(clipboardText);
        }
    }

    @Override
    protected void updateLabelContent() {
        if (this.isPaste()) {
            if (this.m_wasUneditableSelection) {
                this.m_caretX = this.getCaretEndPosX();
                this.m_caretY = this.getCaretMouseReleasedY();
                return;
            }
            Point caretPos = this.pasteClipboardText();
            this.m_caretX = caretPos.x;
            this.m_caretY = caretPos.y;
        }
    }

    @Override
    protected void updateSelection() {
        if (this.isPaste()) {
            this.m_wasUneditableSelection = !this.isDeleteableSelection() && this.isSelection();
            this.deleteSelection();
        }
    }

    @Override
    protected void updateUndoHistory() {
        if (this.isPaste() && this.m_editableObject != null) {
            int x2 = this.getCaretEndPosX();
            int y2 = this.getCaretMouseReleasedY();
            ZyLineContent lineContent = this.getLineContent(y2);
            IZyEditableObject lineFragmentObject = lineContent.getLineFragmentObjectAt(x2);
            if (lineFragmentObject != null) {
                String text2 = lineContent.getText().substring(lineFragmentObject.getStart(), lineFragmentObject.getEnd());
                if (this.isComment(x2, y2)) {
                    text2 = this.getMultiLineComment(y2);
                }
                this.udpateUndolist(this.getLabelContent(), lineContent.getLineObject().getPersistentModel(), lineFragmentObject, text2, this.m_isAboveComment, this.m_isBehindComment, this.m_isLabelComment, this.getCaretStartPosX(), this.getCaretMousePressedX(), this.getCaretMousePressedY(), this.getCaretEndPosX(), this.getCaretMouseReleasedX(), this.getCaretMouseReleasedY());
            }
        }
    }
}

