/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours;

import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CAbstractKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.UndoHistroy.CUndoManager;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;

public class CCursorKeyBehavior
extends CAbstractKeyBehavior {
    public CCursorKeyBehavior(CUndoManager undoManager) {
        super(undoManager);
    }

    private int getXdelta() {
        int delta = 0;
        if (this.getEvent().getKeyCode() == 37) {
            delta = -1;
        } else if (this.getEvent().getKeyCode() == 39) {
            delta = 1;
        }
        return delta;
    }

    private int getYdelta() {
        int delta = 0;
        if (this.getEvent().getKeyCode() == 38) {
            delta = -1;
        } else if (this.getEvent().getKeyCode() == 40) {
            delta = 1;
        }
        return delta;
    }

    protected void handleNotShiftAndCtrl(int xdelta, int ydelta) {
        ZyLabelContent labelContent = this.getLabelContent();
        int caretStartPos_X = this.getCaretStartPosX();
        int mousePressed_X = this.getCaretMousePressedX();
        int mousePressed_Y = this.getCaretMousePressedY();
        int caretEndPos_X = this.getCaretEndPosX();
        int mouseReleased_X = this.getCaretMouseReleasedX();
        int mouseReleased_Y = this.getCaretMouseReleasedY();
        if (xdelta != 0) {
            ZyLineContent lineContent = labelContent.getLineContent(mouseReleased_Y);
            String s2 = String.valueOf(lineContent.getText()).concat(" ");
            if (xdelta > 0) {
                boolean firstIsSpace = s2.charAt(caretEndPos_X) == ' ';
                int endindex = 0;
                for (int i2 = caretEndPos_X; i2 < s2.length(); ++i2) {
                    endindex = i2;
                    if (firstIsSpace ? s2.charAt(i2) != ' ' : s2.charAt(i2) == ' ') break;
                }
                if ((lineContent.getText().endsWith("\n") || lineContent.getText().endsWith("\r")) && lineContent.getText().length() == endindex) {
                    --endindex;
                }
                caretStartPos_X = endindex;
                mousePressed_X = endindex;
                mouseReleased_X = endindex;
                caretEndPos_X = endindex;
            } else if (xdelta < 0) {
                if (caretEndPos_X == 0) {
                    return;
                }
                boolean firstIsSpace = s2.charAt(caretEndPos_X - 1) == ' ';
                int startindex = caretEndPos_X - 1;
                int i3 = caretEndPos_X - 1;
                while (i3 >= 0 && !(firstIsSpace ? s2.charAt(i3) != ' ' : s2.charAt(i3) == ' ')) {
                    startindex = i3--;
                }
                caretStartPos_X = startindex;
                mousePressed_X = startindex;
                mouseReleased_X = startindex;
                caretEndPos_X = startindex;
            }
            mouseReleased_X = this.correctMouseReleasedX(mouseReleased_X, mouseReleased_Y, mousePressed_Y);
            this.setCaret(caretStartPos_X, mousePressed_X, mousePressed_Y, caretEndPos_X, mouseReleased_X, mouseReleased_Y);
        } else if (ydelta != 0) {
            this.handleNotShiftAndNotCtrl(0, ydelta);
        }
    }

    protected void handleNotShiftAndNotCtrl(int xdelta, int ydelta) {
        ZyLabelContent labelContent = this.getLabelContent();
        int caretStartPos_X = this.getCaretStartPosX();
        int mousePressed_X = this.getCaretMousePressedX();
        int mousePressed_Y = this.getCaretMousePressedY();
        int caretEndPos_X = this.getCaretEndPosX();
        int mouseReleased_X = this.getCaretMouseReleasedX();
        int mouseReleased_Y = this.getCaretMouseReleasedY();
        if (this.isSelection() && xdelta != 0 && ydelta == 0) {
            if (mousePressed_Y <= mouseReleased_Y && mousePressed_X <= mouseReleased_X) {
                if (xdelta < 0) {
                    mouseReleased_X = mousePressed_X;
                    caretEndPos_X = caretStartPos_X;
                    mouseReleased_Y = mousePressed_Y;
                } else {
                    mousePressed_X = mouseReleased_X;
                    caretStartPos_X = mouseReleased_X;
                    mousePressed_Y = mouseReleased_Y;
                }
            } else if (xdelta > 0) {
                mouseReleased_X = mousePressed_X;
                caretEndPos_X = caretStartPos_X;
                mouseReleased_Y = mousePressed_Y;
            } else {
                mousePressed_X = mouseReleased_X;
                caretStartPos_X = mouseReleased_X;
                mousePressed_Y = mouseReleased_Y;
            }
        } else {
            mousePressed_X = mouseReleased_X;
            mousePressed_Y = mouseReleased_Y;
            if ((mousePressed_Y += ydelta) < 0) {
                mousePressed_Y = 0;
            }
            if (mousePressed_Y > labelContent.getLineCount() - 1) {
                mousePressed_Y = labelContent.getLineCount() - 1;
            }
            mouseReleased_Y = mousePressed_Y;
            if ((mousePressed_X += xdelta) < 0) {
                mousePressed_X = 0;
            }
            if (mousePressed_X > labelContent.getLineContent(mouseReleased_Y).getTextLayout().getCharacterCount() - 1) {
                mousePressed_X = labelContent.getLineContent(mouseReleased_Y).getTextLayout().getCharacterCount();
            }
            caretEndPos_X = mousePressed_X;
            mouseReleased_X = mousePressed_X;
            caretStartPos_X = caretEndPos_X;
        }
        mouseReleased_X = this.correctMouseReleasedX(mouseReleased_X, mouseReleased_Y, mousePressed_Y);
        this.setCaret(caretStartPos_X, mousePressed_X, mousePressed_Y, caretEndPos_X, mouseReleased_X, mouseReleased_Y);
    }

    protected void handleShiftAndCtrl(int xdelta, int ydelta) {
        if (ydelta != 0) {
            this.handleShiftAndNotCtrl(0, ydelta);
        } else if (xdelta != 0) {
            ZyLabelContent labelContent = this.getLabelContent();
            ZyLineContent lineContent = labelContent.getLineContent(this.getCaretMouseReleasedY());
            int caretStartPos_X = this.getCaretStartPosX();
            int mousePressed_X = this.getCaretMousePressedX();
            int mousePressed_Y = this.getCaretMousePressedY();
            int caretEndPos_X = this.getCaretEndPosX();
            int mouseReleased_X = this.getCaretMouseReleasedX();
            int mouseReleased_Y = this.getCaretMouseReleasedY();
            String s2 = String.valueOf(lineContent.getText()).concat(" ");
            if (xdelta > 0) {
                boolean withCReturn;
                boolean firstIsSpace = s2.charAt(caretEndPos_X) == ' ';
                int endindex = 0;
                for (int i2 = caretEndPos_X; i2 < s2.length(); ++i2) {
                    endindex = i2;
                    if (firstIsSpace ? s2.charAt(i2) != ' ' : s2.charAt(i2) == ' ') break;
                }
                if ((lineContent.getText().endsWith("\n") || lineContent.getText().endsWith("\r")) && lineContent.getText().length() == endindex) {
                    --endindex;
                }
                caretStartPos_X = mousePressed_X;
                mouseReleased_X = endindex;
                caretEndPos_X = endindex;
                boolean noReturn = this.getCaretEndPosX() == lineContent.getText().length();
                boolean withReturn = lineContent.getText().endsWith("\n") && this.getCaretEndPosX() == lineContent.getText().length() - 1;
                boolean bl2 = withCReturn = lineContent.getText().endsWith("\r") && this.getCaretEndPosX() == lineContent.getText().length() - 1;
                if (noReturn || withReturn || withCReturn) {
                    mouseReleased_X = this.getMaxLineLength(this.getCaretMousePressedY(), this.getCaretMouseReleasedY());
                }
            } else if (xdelta < 0) {
                if (caretEndPos_X == 0) {
                    return;
                }
                boolean firstIsSpace = s2.charAt(caretEndPos_X - 1) == ' ';
                int startindex = caretEndPos_X - 1;
                int i3 = caretEndPos_X - 1;
                while (i3 >= 0 && !(firstIsSpace ? s2.charAt(i3) != ' ' : s2.charAt(i3) == ' ')) {
                    startindex = i3--;
                }
                caretStartPos_X = mousePressed_X;
                mouseReleased_X = startindex;
                caretEndPos_X = startindex;
            }
            mouseReleased_X = this.correctMouseReleasedX(mouseReleased_X, mouseReleased_Y, mousePressed_Y);
            this.setCaret(caretStartPos_X, mousePressed_X, mousePressed_Y, caretEndPos_X, mouseReleased_X, mouseReleased_Y);
        }
    }

    protected void handleShiftAndNotCtrl(int xDelta, int yDelta) {
        ZyLabelContent labelContent = this.getLabelContent();
        int caretStartPos_X = this.getCaretStartPosX();
        int mousePressed_X = this.getCaretMousePressedX();
        int mousePressed_Y = this.getCaretMousePressedY();
        int caretEndPos_X = this.getCaretEndPosX();
        int mouseReleased_X = this.getCaretMouseReleasedX();
        int mouseReleased_Y = this.getCaretMouseReleasedY();
        int linecount = labelContent.getLineCount();
        if (xDelta != 0 || yDelta != 0) {
            int lr;
            int lp;
            if ((mouseReleased_Y += yDelta) < 0) {
                mouseReleased_Y = 0;
            }
            if (mouseReleased_Y > linecount - 1) {
                mouseReleased_Y = linecount - 1;
            }
            if ((mouseReleased_X += xDelta) < 0) {
                mouseReleased_X = 0;
            }
            if ((lp = mousePressed_Y) > (lr = mouseReleased_Y)) {
                lp = mouseReleased_Y;
                lr = mousePressed_Y;
            }
            int maxlength = 0;
            for (int y2 = lp; y2 <= lr; ++y2) {
                maxlength = Math.max(maxlength, labelContent.getLineContent(y2).getText().length());
            }
            if (mouseReleased_X > maxlength) {
                mouseReleased_X = maxlength;
            }
            caretEndPos_X = mouseReleased_X <= labelContent.getLineContent(mouseReleased_Y).getTextLayout().getCharacterCount() ? mouseReleased_X : labelContent.getLineContent(mouseReleased_Y).getTextLayout().getCharacterCount();
            caretStartPos_X = mousePressed_X;
        }
        mouseReleased_X = this.correctMouseReleasedX(mouseReleased_X, mouseReleased_Y, mousePressed_Y);
        this.setCaret(caretStartPos_X, mousePressed_X, mousePressed_Y, caretEndPos_X, mouseReleased_X, mouseReleased_Y);
    }

    @Override
    protected void initUndoHistory() {
    }

    @Override
    protected void updateCaret() {
        int xDelta = this.getXdelta();
        int yDelta = this.getYdelta();
        if (!this.isShiftPressed() && !this.isCtrlPressed()) {
            this.handleNotShiftAndNotCtrl(xDelta, yDelta);
        } else if (this.isShiftPressed() && !this.isCtrlPressed()) {
            this.handleShiftAndNotCtrl(xDelta, yDelta);
        } else if (!this.isShiftPressed() && this.isCtrlPressed()) {
            this.handleNotShiftAndCtrl(xDelta, yDelta);
        } else if (this.isShiftPressed() && this.isCtrlPressed()) {
            this.handleShiftAndCtrl(xDelta, yDelta);
        }
    }

    @Override
    protected void updateClipboard() {
    }

    @Override
    protected void updateLabelContent() {
    }

    @Override
    protected void updateSelection() {
    }

    @Override
    protected void updateUndoHistory() {
    }
}

