/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours;

import com.google.security.zynamics.zylib.gui.zygraph.realizers.ECommentPlacement;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyEditableObject;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CAbstractKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.UndoHistroy.CUndoManager;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;

public class CCharKeyBehavior
extends CAbstractKeyBehavior {
    private int m_caretX;
    private IZyEditableObject m_editableObject = null;
    private boolean m_isLabelComment = false;
    private boolean m_isAboveComment = false;
    private boolean m_isBehindComment = false;
    private boolean m_wasUneditableSelection;

    public CCharKeyBehavior(CUndoManager undoManager) {
        super(undoManager);
    }

    @Override
    protected void initUndoHistory() {
        int x2 = this.getCaretEndPosX();
        int y2 = this.getCaretMouseReleasedY();
        ZyLineContent lineContent = this.getLineContent(y2);
        IZyEditableObject editableObject = lineContent.getLineFragmentObjectAt(x2);
        this.m_isAboveComment = this.isAboveLineComment(y2);
        this.m_isBehindComment = this.isBehindLineComment(x2, y2);
        this.m_isLabelComment = this.isLabelComment(y2);
        boolean isNewBehindLineComment = false;
        if (x2 == lineContent.getText().length() && !this.isComment(x2, y2)) {
            this.m_isBehindComment = true;
            isNewBehindLineComment = true;
            editableObject = lineContent.getLineObject();
        }
        this.m_editableObject = editableObject;
        String text2 = "";
        if (editableObject != null) {
            if (!isNewBehindLineComment) {
                text2 = lineContent.getText().substring(editableObject.getStart(), editableObject.getEnd());
                if (this.isComment(x2, y2)) {
                    text2 = this.getMultiLineComment(y2);
                }
            }
            this.udpateUndolist(this.getLabelContent(), lineContent.getLineObject().getPersistentModel(), editableObject, text2, this.m_isAboveComment, this.m_isBehindComment, this.m_isLabelComment, this.getCaretStartPosX(), this.getCaretMousePressedX(), this.getCaretMousePressedY(), this.getCaretEndPosX(), this.getCaretMouseReleasedX(), this.getCaretMouseReleasedY());
        }
    }

    @Override
    protected void updateCaret() {
        int y2 = this.getCaretMouseReleasedY();
        this.setCaret(this.m_caretX, this.m_caretX, y2, this.m_caretX, this.m_caretX, y2);
    }

    @Override
    protected void updateClipboard() {
    }

    @Override
    protected void updateLabelContent() {
        if (this.m_wasUneditableSelection) {
            this.m_caretX = this.getCaretEndPosX();
            return;
        }
        int x2 = this.getCaretEndPosX();
        int y2 = this.getCaretMouseReleasedY();
        this.m_caretX = x2;
        if (this.isComment(x2, y2)) {
            ++this.m_caretX;
            ZyLineContent lineContent = this.getLineContent(y2);
            IZyEditableObject editableObject = lineContent.getLineFragmentObjectAt(x2);
            if (editableObject == null || editableObject.isCommentDelimiter()) {
                return;
            }
            int textCursor = x2 - editableObject.getStart();
            String text2 = lineContent.getText().substring(editableObject.getStart(), editableObject.getEnd());
            String chr = String.valueOf(this.getEvent().getKeyChar());
            String changedText = String.format("%s%s%s", text2.substring(0, textCursor), chr, text2.substring(textCursor));
            if (this.isComment(x2, y2)) {
                changedText = this.getMultilineComment(y2, changedText);
            }
            editableObject.update(changedText);
            this.getLabelContent().getLineEditor().recreateLabelLines(this.getLabelContent(), editableObject.getPersistentModel());
        } else {
            if (this.isEditable(x2, y2)) {
                throw new RuntimeException("Not implemented yet.");
            }
            ZyLineContent lineContent = this.getLineContent(y2);
            if (x2 == lineContent.getText().length() && lineContent.getLineObject() != null) {
                lineContent.getLineObject().updateComment(Character.toString(this.getEvent().getKeyChar()), ECommentPlacement.BEHIND_LINE);
                this.getLabelContent().getLineEditor().recreateLabelLines(this.getLabelContent(), lineContent.getLineObject().getPersistentModel());
                this.m_caretX = this.getLineContent(y2).getText().length();
            }
        }
    }

    @Override
    protected void updateSelection() {
        this.m_wasUneditableSelection = !this.isDeleteableSelection() && this.isSelection();
        this.deleteSelection();
    }

    @Override
    protected void updateUndoHistory() {
        if (this.m_editableObject != null) {
            int x2 = this.getCaretEndPosX();
            int y2 = this.getCaretMouseReleasedY();
            ZyLineContent lineContent = this.getLineContent(y2);
            IZyEditableObject editableObject = lineContent.getLineFragmentObjectAt(x2);
            if (editableObject != null) {
                String text2 = lineContent.getText().substring(editableObject.getStart(), editableObject.getEnd());
                if (this.isComment(x2, y2)) {
                    text2 = this.getMultiLineComment(y2);
                }
                this.udpateUndolist(this.getLabelContent(), lineContent.getLineObject().getPersistentModel(), editableObject, text2, this.m_isAboveComment, this.m_isBehindComment, this.m_isLabelComment, this.getCaretStartPosX(), this.getCaretMousePressedX(), this.getCaretMousePressedY(), this.getCaretEndPosX(), this.getCaretMouseReleasedX(), this.getCaretMouseReleasedY());
            }
        }
    }
}

