/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours;

import com.google.security.zynamics.zylib.gui.zygraph.realizers.ECommentPlacement;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyEditableObject;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CAbstractKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.UndoHistroy.CUndoManager;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import java.util.List;

public class CBackspaceKeyBehavior
extends CAbstractKeyBehavior {
    private int m_caretX;
    private int m_caretY;
    private boolean m_wasSelection = false;
    private boolean m_isBehindComment = false;
    private boolean m_isAboveComment = false;
    private boolean m_isLabelComment = false;
    private IZyEditableObject m_editableObject = null;
    private IZyEditableObject m_lineModel = null;
    private boolean m_wasEditablePosition = false;

    public CBackspaceKeyBehavior(CUndoManager undoManager) {
        super(undoManager);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleLineComments() {
        int x2 = this.getCaretEndPosX();
        int y2 = this.getCaretMouseReleasedY();
        ZyLineContent lineContent = this.getLineContent(y2);
        if (this.m_editableObject == null) {
            return;
        }
        int firstModelLine = this.getLabelContent().getFirstLineIndexOfModelAt(y2);
        int nonCommentLine = this.getLabelContent().getNonPureCommentLineIndexOfModelAt(y2);
        int firstCommentLine = nonCommentLine != -1 && this.m_isBehindComment ? nonCommentLine : firstModelLine;
        String lineText = lineContent.getText();
        String changedText = "";
        if (!this.isCommentDelimiter(x2, y2)) {
            char lastChar;
            if (lineText.length() > 0 && lineText.length() == this.m_editableObject.getEnd() && x2 == lineText.length() && ((lastChar = lineText.charAt(lineText.length() - 1)) == '\n' || lastChar == '\r')) {
                x2 = -1;
            }
            changedText = String.format("%s%s", lineText.substring(this.m_editableObject.getStart(), x2 - 1), lineText.substring(x2, this.m_editableObject.getEnd()));
            this.m_caretY = y2;
            this.m_caretX = x2 - 1;
            changedText = this.getMultilineComment(this.m_caretY, changedText);
        } else {
            List<IZyEditableObject> editableObjectList = lineContent.getLineFragmentObjectList();
            this.m_editableObject = editableObjectList.get(editableObjectList.size() - 1);
            if (firstCommentLine == y2) {
                if (this.m_editableObject.getLength() != 1) {
                    this.m_caretX = this.getCaretEndPosX();
                    this.m_caretY = this.getCaretMouseReleasedY();
                    return;
                }
                if (y2 > 0) {
                    this.m_caretY = y2 - 1;
                    ZyLineContent prevLineContent = this.getLineContent(this.m_caretY);
                    this.m_caretX = prevLineContent.getText().length();
                }
                changedText = this.getMultilineComment(y2, changedText);
            } else {
                ZyLineContent prevLineContent = this.getLineContent(y2 - 1);
                String prevLineText = prevLineContent.getText();
                if (!prevLineText.isEmpty() && !prevLineContent.getLineObject().isPlaceholder()) {
                    IZyEditableObject prevLineFragmentObject = prevLineContent.getLineFragmentObjectAt(prevLineText.length() - 1);
                    changedText = prevLineText.substring(prevLineFragmentObject.getStart(), prevLineFragmentObject.getEnd() - 1);
                    this.m_caretY = y2 - 1;
                    this.m_caretX = prevLineText.length() - 1;
                    changedText = this.getMultilineComment(this.m_caretY, changedText);
                } else {
                    this.m_caretY = y2 - 1;
                    this.m_caretX = 0;
                }
            }
        }
        if (changedText.endsWith("\n")) {
            changedText = String.valueOf(changedText.substring(0, changedText.length() - 1)).concat("\r");
        }
        if (this.m_isAboveComment) {
            this.m_editableObject.updateComment(changedText, ECommentPlacement.ABOVE_LINE);
        } else if (this.m_isBehindComment) {
            this.m_editableObject.updateComment(changedText, ECommentPlacement.BEHIND_LINE);
        } else if (this.m_isLabelComment) {
            this.m_editableObject.update(changedText);
        }
        this.getLabelContent().getLineEditor().recreateLabelLines(this.getLabelContent(), this.m_editableObject.getPersistentModel());
    }

    private void handleTextFragment() {
        throw new RuntimeException("Not implemneted yet");
    }

    private boolean isCommentDelimiter(int x2, int y2) {
        IZyEditableObject leftNeighbourFragment;
        ZyLineContent lineContent = this.getLineContent(y2);
        IZyEditableObject fragment = lineContent.getLineFragmentObjectAt(x2);
        leftNeighbourFragment = x2 > 0 ? (leftNeighbourFragment = lineContent.getLineFragmentObjectAt(x2 - 1)) : null;
        return fragment != null && fragment.isCommentDelimiter() || leftNeighbourFragment != null && leftNeighbourFragment.isCommentDelimiter();
    }

    @Override
    protected void initUndoHistory() {
        int x2 = this.getCaretEndPosX();
        int y2 = this.getCaretMouseReleasedY();
        ZyLineContent lineContent = this.getLineContent(y2);
        this.m_editableObject = lineContent.getLineFragmentObjectAt(x2);
        this.m_lineModel = lineContent.getLineObject();
        if (this.m_editableObject != null) {
            this.m_wasEditablePosition = true;
            String text2 = lineContent.getText().substring(this.m_editableObject.getStart(), this.m_editableObject.getEnd());
            this.m_isAboveComment = this.isAboveLineComment(y2);
            this.m_isBehindComment = this.isBehindLineComment(x2, y2);
            this.m_isLabelComment = this.isLabelComment(y2);
            if (this.isComment(x2, y2)) {
                text2 = this.getMultiLineComment(y2);
            }
            this.udpateUndolist(this.getLabelContent(), this.m_lineModel.getPersistentModel(), this.m_editableObject, text2, this.m_isAboveComment, this.m_isBehindComment, this.m_isLabelComment, this.getCaretStartPosX(), this.getCaretMousePressedX(), this.getCaretMousePressedY(), this.getCaretEndPosX(), this.getCaretMouseReleasedX(), this.getCaretMouseReleasedY());
        }
    }

    @Override
    protected void updateCaret() {
        this.setCaret(this.m_caretX, this.m_caretX, this.m_caretY, this.m_caretX, this.m_caretX, this.m_caretY);
        this.m_wasSelection = false;
    }

    @Override
    protected void updateClipboard() {
    }

    @Override
    protected void updateLabelContent() {
        this.m_caretX = this.getCaretEndPosX();
        this.m_caretY = this.getCaretMouseReleasedY();
        if (!this.m_wasSelection) {
            if (this.isComment(this.m_caretX, this.m_caretY)) {
                this.handleLineComments();
            } else if (this.getLineContent(this.m_caretY).getLineFragmentObjectAt(this.m_caretX) != null) {
                this.handleTextFragment();
            }
        }
    }

    @Override
    protected void updateSelection() {
        this.m_wasSelection = this.isSelection();
        this.deleteSelection();
    }

    @Override
    protected void updateUndoHistory() {
        if (!this.m_wasEditablePosition) {
            return;
        }
        this.m_wasEditablePosition = false;
        int x2 = this.getCaretEndPosX();
        int y2 = this.getCaretMouseReleasedY();
        ZyLineContent lineContent = this.getLineContent(y2);
        String text2 = "";
        if (lineContent == null || lineContent.getLineObject() == null || this.m_lineModel.getPersistentModel() != lineContent.getLineObject().getPersistentModel()) {
            if (!this.m_isLabelComment) {
                int offset = 0;
                if (y2 + 1 < this.getLabelContent().getLineCount()) {
                    offset = 1;
                    lineContent = this.getLineContent(y2 + offset);
                }
                if (this.m_lineModel.getPersistentModel() != lineContent.getLineObject().getPersistentModel() && y2 > 0) {
                    offset = -1;
                    lineContent = this.getLineContent(y2 + offset);
                }
                y2 += offset;
            }
        } else if (this.isComment(x2, y2)) {
            text2 = this.getMultiLineComment(y2);
        }
        this.udpateUndolist(this.getLabelContent(), this.m_lineModel.getPersistentModel(), this.m_lineModel, text2, this.m_isAboveComment, this.m_isBehindComment, this.m_isLabelComment, this.getCaretStartPosX(), this.getCaretMousePressedX(), this.getCaretMousePressedY(), this.getCaretEndPosX(), this.getCaretMouseReleasedX(), this.getCaretMouseReleasedY());
    }
}

