/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.proximity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphConverters;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IGroupNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.ITextNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.NodeHelpers;
import com.google.security.zynamics.zylib.gui.zygraph.wrappers.ViewNodeAdapter;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class ProximityRangeCalculator {
    private static Set<ViewNodeAdapter> getGroupMembers(IGroupNode<?, ?> node) {
        HashSet<ViewNodeAdapter> groupMembers = new HashSet<ViewNodeAdapter>();
        for (IViewNode member : node.getElements()) {
            groupMembers.add(new ViewNodeAdapter(member));
        }
        return groupMembers;
    }

    private static <NodeType extends ZyGraphNode<? extends IViewNode<?>>> Set<ViewNodeAdapter> getParentGroups(NodeType node) {
        HashSet<ViewNodeAdapter> parentGroups = new HashSet<ViewNodeAdapter>();
        for (IGroupNode<?, ?> parentGroup = node.getRawNode().getParentGroup(); parentGroup != null; parentGroup = parentGroup.getParentGroup()) {
            parentGroups.add(new ViewNodeAdapter(parentGroup));
        }
        return parentGroups;
    }

    private static List<ViewNodeAdapter> getPredecessors(Iterable<ViewNodeAdapter> selectedNodes, int depth) {
        ArrayList<ViewNodeAdapter> nodes = new ArrayList<ViewNodeAdapter>();
        for (ViewNodeAdapter node : selectedNodes) {
            nodes.addAll(ProximityRangeCalculator.getPredecessors(node, depth));
        }
        return nodes;
    }

    private static Set<ViewNodeAdapter> getPredecessors(ViewNodeAdapter node, int depth) {
        HashSet<ViewNodeAdapter> nodes = new HashSet<ViewNodeAdapter>();
        ProximityRangeCalculator.getPredecessorsInternal(node, depth, nodes, new HashSet<ViewNodeAdapter>());
        return nodes;
    }

    private static void getPredecessorsInternal(ViewNodeAdapter node, int depth, Set<ViewNodeAdapter> nodes, Set<ViewNodeAdapter> visited) {
        for (ViewNodeAdapter parent : node.getParents()) {
            if (depth <= 0 && !(parent.getNode() instanceof ITextNode)) continue;
            if (parent.getNode().getParentGroup() != null) {
                IGroupNode<?, ?> previousNode = parent.getNode().getParentGroup();
                while (previousNode != null) {
                    if (!ProximityRangeCalculator.visited(visited, previousNode)) {
                        ViewNodeAdapter groupNodeAdapter = new ViewNodeAdapter(previousNode);
                        visited.add(groupNodeAdapter);
                        nodes.add(groupNodeAdapter);
                        previousNode = previousNode.getParentGroup();
                        continue;
                    }
                    previousNode = null;
                }
            }
            visited.add(parent);
            nodes.add(parent);
            ProximityRangeCalculator.getSuccessorsInternal(parent, -1, nodes, new HashSet<ViewNodeAdapter>());
            ProximityRangeCalculator.getPredecessorsInternal(parent, depth - 1, nodes, visited);
        }
    }

    private static int getRealDepth(int depth) {
        return depth == -1 ? Integer.MAX_VALUE : depth;
    }

    private static List<ViewNodeAdapter> getSuccessors(Iterable<ViewNodeAdapter> selectedNodes, int depth) {
        ArrayList<ViewNodeAdapter> nodes = new ArrayList<ViewNodeAdapter>();
        for (ViewNodeAdapter node : selectedNodes) {
            nodes.addAll(ProximityRangeCalculator.getSuccessors(node, depth));
        }
        return nodes;
    }

    private static Set<ViewNodeAdapter> getSuccessors(ViewNodeAdapter node, int depth) {
        HashSet<ViewNodeAdapter> nodes = new HashSet<ViewNodeAdapter>();
        ProximityRangeCalculator.getSuccessorsInternal(node, depth, nodes, new HashSet<ViewNodeAdapter>());
        return nodes;
    }

    private static void getSuccessorsInternal(ViewNodeAdapter node, int depth, Set<ViewNodeAdapter> nodes, HashSet<ViewNodeAdapter> visited) {
        for (ViewNodeAdapter child : node.getChildren()) {
            if (depth <= 0 && !(child.getNode() instanceof ITextNode)) continue;
            if (child.getNode().getParentGroup() != null) {
                IGroupNode<?, ?> previousNode = child.getNode().getParentGroup();
                while (previousNode != null) {
                    if (!ProximityRangeCalculator.visited(visited, previousNode)) {
                        ViewNodeAdapter groupNodeAdapter = new ViewNodeAdapter(previousNode);
                        visited.add(groupNodeAdapter);
                        nodes.add(groupNodeAdapter);
                        previousNode = previousNode.getParentGroup();
                        continue;
                    }
                    previousNode = null;
                }
            }
            if (NodeHelpers.getVisibleNode(child.getNode()) != child.getNode()) continue;
            visited.add(child);
            nodes.add(child);
            ProximityRangeCalculator.getPredecessorsInternal(child, -1, nodes, new HashSet<ViewNodeAdapter>());
            ProximityRangeCalculator.getSuccessorsInternal(child, depth - 1, nodes, visited);
        }
    }

    private static boolean visited(Set<ViewNodeAdapter> visited, final IGroupNode<?, ?> parentGroup) {
        return CollectionHelpers.any(visited, new ICollectionFilter<ViewNodeAdapter>(){

            @Override
            public boolean qualifies(ViewNodeAdapter adapter) {
                return adapter.getNode() == parentGroup;
            }
        });
    }

    public static <NodeType extends ZyGraphNode<? extends IViewNode<?>>> Set<NodeType> getNeighbors(AbstractZyGraph<NodeType, ?> graph, Collection<NodeType> nodes, int childDepth, int parentDepth) {
        Preconditions.checkNotNull(graph, "Graph argument can not be null");
        Preconditions.checkNotNull(nodes, "Nodes argument can not be null");
        LinkedHashSet<NodeType> all = new LinkedHashSet<NodeType>(nodes);
        for (ZyGraphNode node : nodes) {
            ArrayList<ZyGraphNode> nodeList = new ArrayList<ZyGraphNode>();
            nodeList.add(node);
            List converted = GraphConverters.convert(nodeList);
            List<ViewNodeAdapter> wrapped = ViewNodeAdapter.wrap(Lists.newArrayList(converted));
            List<ViewNodeAdapter> preds = ProximityRangeCalculator.getPredecessors(wrapped, ProximityRangeCalculator.getRealDepth(parentDepth));
            List<ViewNodeAdapter> succs = ProximityRangeCalculator.getSuccessors(wrapped, ProximityRangeCalculator.getRealDepth(childDepth));
            all.addAll(ViewNodeAdapter.unwrap(graph, ProximityRangeCalculator.getParentGroups(node)));
            if (node.getRawNode() instanceof IGroupNode && node.isSelected()) {
                all.addAll(ViewNodeAdapter.unwrap(graph, ProximityRangeCalculator.getGroupMembers((IGroupNode)node.getRawNode())));
            }
            all.addAll(ViewNodeAdapter.unwrap(graph, preds));
            all.addAll(ViewNodeAdapter.unwrap(graph, succs));
        }
        return all;
    }
}

