/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.proximity;

import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IEdgeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IGroupNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.types.common.IterationMode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import java.util.HashSet;

public class MultiEdgeHider {
    public static <NodeType extends ZyGraphNode<? extends IViewNode<?>>> void hideMultipleEdgesInternal(AbstractZyGraph<NodeType, ?> graph) {
        graph.iterate(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType node) {
                MultiEdgeHider.hideMultipleEdgesInternal(node);
                return IterationMode.CONTINUE;
            }
        });
    }

    public static <NodeType extends ZyGraphNode<? extends IViewNode<?>>> void hideMultipleEdgesInternal(NodeType node) {
        if (!node.isVisible() || node.getRawNode() instanceof IGroupNode) {
            return;
        }
        HashSet targets = new HashSet();
        for (IViewEdge edge : node.getRawNode().getOutgoingEdges()) {
            Object target = edge.getTarget();
            if (targets.contains(target)) {
                edge.setVisible(false);
                continue;
            }
            targets.add(target);
        }
        HashSet sources = new HashSet();
        for (IViewEdge edge : node.getRawNode().getIncomingEdges()) {
            if (sources.contains(edge.getSource())) {
                edge.setVisible(false);
                continue;
            }
            sources.add(edge.getSource());
        }
    }

    public static <NodeType extends ZyGraphNode<? extends IViewNode<?>>, EdgeType extends ZyGraphEdge<NodeType, EdgeType, ? extends IViewEdge<?>>> void unhideMultipleEdgesInternal(AbstractZyGraph<NodeType, EdgeType> graph) {
        graph.iterateEdges(new IEdgeCallback<EdgeType>(){

            @Override
            public IterationMode nextEdge(EdgeType edge) {
                ((ZyGraphEdge)edge).getRawEdge().setVisible(((ZyGraphNode)((ZyGraphEdge)edge).getSource()).isVisible() && ((ZyGraphNode)((ZyGraphEdge)edge).getTarget()).isVisible());
                return IterationMode.CONTINUE;
            }
        });
    }
}

