/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.nodes;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNode;
import com.google.security.zynamics.zylib.gui.zygraph.nodes.IViewNodeListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public abstract class CViewNode<EdgeType extends IViewEdge<? extends IViewNode<?>>>
implements IViewNode<EdgeType> {
    private int m_id;
    private double m_x;
    private double m_y;
    private Color m_color;
    private Color m_borderColor;
    private boolean m_selected;
    private boolean m_visible;
    private final List<EdgeType> m_incomingEdges = new ArrayList<EdgeType>();
    private final List<EdgeType> m_outgoingEdges = new ArrayList<EdgeType>();
    private final ListenerProvider<IViewNodeListener> m_listeners = new ListenerProvider();
    private double m_height;
    private double m_width;

    public CViewNode(int id, double x2, double y2, double width, double height, Color color, Color borderColor, boolean selected, boolean visible) {
        Preconditions.checkArgument(id >= -1, "Error: Node ID must be positive or -1 for unsaved nodes.");
        Preconditions.checkNotNull(color, "Error: Color argument can't be null");
        Preconditions.checkNotNull(borderColor, "Error: Border color argument can't be null");
        this.m_id = id;
        this.m_x = x2;
        this.m_y = y2;
        this.m_height = height;
        this.m_width = width;
        this.m_color = color;
        this.m_borderColor = borderColor;
        this.m_selected = selected;
        this.m_visible = visible;
    }

    protected ListenerProvider<IViewNodeListener> getListeners() {
        return this.m_listeners;
    }

    public void addIncomingEdge(EdgeType edge) {
        Preconditions.checkNotNull(edge, "Error: Edge argument can't be null");
        this.m_incomingEdges.add(edge);
    }

    @Override
    public void addListener(IViewNodeListener listener) {
        this.m_listeners.addListener(listener);
    }

    public void addOutgoingEdge(EdgeType edge) {
        Preconditions.checkNotNull(edge, "Error: Edge argument can not be null");
        Preconditions.checkArgument(!this.m_outgoingEdges.contains(edge), "Error: Outgoing edge was added before");
        this.m_outgoingEdges.add(edge);
    }

    @Override
    public Color getBorderColor() {
        return new Color(this.m_borderColor.getRGB());
    }

    @Override
    public Color getColor() {
        return new Color(this.m_color.getRGB());
    }

    @Override
    public double getHeight() {
        return this.m_height;
    }

    @Override
    public int getId() {
        return this.m_id;
    }

    @Override
    public List<EdgeType> getIncomingEdges() {
        return new ArrayList<EdgeType>(this.m_incomingEdges);
    }

    @Override
    public List<EdgeType> getOutgoingEdges() {
        return new ArrayList<EdgeType>(this.m_outgoingEdges);
    }

    @Override
    public double getWidth() {
        return this.m_width;
    }

    @Override
    public double getX() {
        return this.m_x;
    }

    @Override
    public double getY() {
        return this.m_y;
    }

    @Override
    public boolean isSelected() {
        return this.m_selected;
    }

    @Override
    public boolean isVisible() {
        return this.m_visible;
    }

    public void removeAllListeners() {
        ArrayList<IViewNodeListener> listeners = new ArrayList<IViewNodeListener>();
        for (IViewNodeListener listener : this.m_listeners) {
            listeners.add(listener);
        }
        for (IViewNodeListener listener : listeners) {
            this.m_listeners.removeListener(listener);
        }
    }

    public void removeIncomingEdge(EdgeType edge) {
        Preconditions.checkNotNull(edge, "Error: Edge argument can not be null");
        this.m_incomingEdges.remove(edge);
    }

    @Override
    public void removeListener(IViewNodeListener listener) {
        Preconditions.checkNotNull(listener, "Error: Listener argument can not be null");
        this.m_listeners.removeListener(listener);
    }

    public void removeOutgoingEdge(EdgeType edge) {
        Preconditions.checkNotNull(edge, "Error: Edge argument can not be null");
        this.m_outgoingEdges.remove(edge);
    }

    @Override
    public void setBorderColor(Color color) {
        Preconditions.checkNotNull(color, "Error: Color argument can not be null");
        if (this.m_borderColor.equals(color)) {
            return;
        }
        this.m_borderColor = color;
        for (IViewNodeListener listener : this.m_listeners) {
            try {
                listener.changedBorderColor(this, color);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void setColor(Color color) {
        Preconditions.checkNotNull(color, "Error: Color argument can not be null");
        if (this.m_color.equals(color)) {
            return;
        }
        this.m_color = color;
        for (IViewNodeListener listener : this.m_listeners) {
            try {
                listener.changedColor(this, color);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void setHeight(double height) {
        if (this.m_height == height) {
            return;
        }
        this.m_height = height;
        for (IViewNodeListener listener : this.m_listeners) {
            try {
                listener.heightChanged(this, height);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void setId(int id) {
        this.m_id = id;
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected == this.m_selected) {
            return;
        }
        this.m_selected = selected;
        for (IViewNodeListener listener : this.m_listeners) {
            try {
                listener.changedSelection(this, selected);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible == this.m_visible) {
            return;
        }
        this.m_visible = visible;
        for (IViewNodeListener listener : this.m_listeners) {
            try {
                listener.changedVisibility(this, this.isVisible());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void setWidth(double width) {
        if (this.m_width == width) {
            return;
        }
        this.m_width = width;
        for (IViewNodeListener listener : this.m_listeners) {
            try {
                listener.widthChanged(this, width);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void setX(double xpos) {
        if (this.m_x == xpos) {
            return;
        }
        this.m_x = xpos;
        for (IViewNodeListener listener : this.m_listeners) {
            try {
                listener.xposChanged(this, xpos);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void setY(double ypos) {
        if (this.m_y == ypos) {
            return;
        }
        this.m_y = ypos;
        for (IViewNodeListener listener : this.m_listeners) {
            try {
                listener.yposChanged(this, ypos);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

