/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.helpers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeFilter;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.ISelectableNode;
import com.google.security.zynamics.zylib.gui.zygraph.proximity.CProximityNode;

public class StandardFilters {
    public static <NodeType extends ISelectableNode> INodeFilter<NodeType> getDeselectedFilter() {
        INodeFilter<NodeType> selectedFilter = StandardFilters.getSelectedFilter();
        return StandardFilters.getNegatedFilter(selectedFilter);
    }

    public static <NodeType> INodeFilter<NodeType> getInfoNodeFilter() {
        return new INodeFilter<NodeType>(){

            @Override
            public boolean qualifies(NodeType node) {
                return node instanceof CProximityNode;
            }
        };
    }

    public static <NodeType> INodeFilter<NodeType> getNegatedFilter(final INodeFilter<NodeType> filter) {
        Preconditions.checkNotNull(filter, "Error: Filter argument can't be null");
        return new INodeFilter<NodeType>(){

            @Override
            public boolean qualifies(NodeType node) {
                return !filter.qualifies(node);
            }
        };
    }

    public static <NodeType extends ISelectableNode> INodeFilter<NodeType> getSelectedFilter() {
        return new INodeFilter<NodeType>(){

            @Override
            public boolean qualifies(NodeType node) {
                return node.isSelected();
            }
        };
    }

    public static <NodeType> INodeFilter<NodeType> getTrueFilter() {
        return new INodeFilter<NodeType>(){

            @Override
            public boolean qualifies(NodeType node) {
                return true;
            }
        };
    }
}

