/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.helpers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.functions.IteratorFunctions;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IEdgeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IEdgeIterableGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IIterableGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeFilter;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.ISelectableGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.ISelectableNode;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IViewableGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IViewableNode;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IZoomableGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.StandardFilters;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLineContent;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import com.google.security.zynamics.zylib.types.common.IFilteredItemCallback;
import com.google.security.zynamics.zylib.types.common.IIterableCollection;
import com.google.security.zynamics.zylib.types.common.IterationMode;
import com.google.security.zynamics.zylib.types.graphs.GraphAlgorithms;
import com.google.security.zynamics.zylib.types.graphs.IGraphNode;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.realizers.IZyNodeRealizer;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GraphHelpers {
    public static <NodeType> boolean any(IIterableGraph<NodeType> graph, final INodeFilter<NodeType> filter) {
        final ArrayList lameHack = new ArrayList();
        graph.iterate(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType item) {
                if (filter.qualifies(item)) {
                    lameHack.add(item);
                    return IterationMode.STOP;
                }
                return IterationMode.CONTINUE;
            }
        });
        return lameHack.size() != 0;
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> boolean areAllChildrenDeselected(NodeType node) {
        INodeFilter filter = StandardFilters.getSelectedFilter();
        return GraphAlgorithms.collectChildren(node, filter).size() == 0;
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> boolean areAllParentsDeselected(NodeType node) {
        INodeFilter filter = StandardFilters.getSelectedFilter();
        return GraphAlgorithms.collectParents(node, filter).size() == 0;
    }

    public static <NodeType extends IViewableNode> Rectangle2D calculateBoundingBox(Collection<NodeType> nodes) {
        Preconditions.checkNotNull(nodes, "Node list argument can't be null");
        Preconditions.checkArgument(nodes.size() != 0, "Node list argument can't be empty");
        Rectangle2D.Double box = new Rectangle2D.Double();
        for (IViewableNode node : nodes) {
            node.calcUnionRect(box);
        }
        return box;
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> void expandSelectionDown(ISelectableGraph<NodeType> graph) {
        Preconditions.checkNotNull(graph, "Error: Graph argument can't be null");
        final ArrayList toSelect = new ArrayList();
        final INodeFilter deselectedFilter = StandardFilters.getDeselectedFilter();
        graph.iterateSelected(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType node) {
                toSelect.addAll(GraphAlgorithms.collectChildren(node, deselectedFilter));
                return IterationMode.CONTINUE;
            }
        });
        graph.selectNodes(toSelect, true);
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> void expandSelectionUp(ISelectableGraph<NodeType> graph) {
        Preconditions.checkNotNull(graph, "Error: Graph argument can't be null");
        final ArrayList toSelect = new ArrayList();
        final INodeFilter deselectedFilter = StandardFilters.getDeselectedFilter();
        graph.iterateSelected(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType node) {
                toSelect.addAll(GraphAlgorithms.collectParents(node, deselectedFilter));
                return IterationMode.CONTINUE;
            }
        });
        graph.selectNodes(toSelect, true);
    }

    public static <NodeType> List<NodeType> filter(IIterableCollection<INodeCallback<NodeType>> graph, final ICollectionFilter<NodeType> filter) {
        final ArrayList items = new ArrayList();
        graph.iterate(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType node) {
                if (filter.qualifies(node)) {
                    items.add(node);
                }
                return IterationMode.CONTINUE;
            }
        });
        return items;
    }

    public static <EdgeType> List<EdgeType> getEdges(IEdgeIterableGraph<EdgeType> graph) {
        INodeFilter trueFilter = StandardFilters.getTrueFilter();
        return GraphHelpers.getEdges(graph, trueFilter);
    }

    public static <EdgeType> List<EdgeType> getEdges(IEdgeIterableGraph<EdgeType> graph, final INodeFilter<EdgeType> filter) {
        Preconditions.checkNotNull(graph, "Error: Graph argument can't be null");
        Preconditions.checkNotNull(filter, "Error: Filter argument can't be null");
        final ArrayList nodes = new ArrayList();
        graph.iterateEdges(new IEdgeCallback<EdgeType>(){

            @Override
            public IterationMode nextEdge(EdgeType node) {
                if (filter.qualifies(node)) {
                    nodes.add(node);
                }
                return IterationMode.CONTINUE;
            }
        });
        return nodes;
    }

    public static <NodeType extends ISelectableNode> List<NodeType> getInvisibleNodes(IViewableGraph<NodeType> graph) {
        final ArrayList nodes = new ArrayList();
        graph.iterateInvisible(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType node) {
                nodes.add(node);
                return IterationMode.CONTINUE;
            }
        });
        return nodes;
    }

    public static <NodeType> List<NodeType> getNodes(IIterableGraph<NodeType> graph) {
        INodeFilter trueFilter = StandardFilters.getTrueFilter();
        return GraphHelpers.getNodes(graph, trueFilter);
    }

    public static <NodeType> List<NodeType> getNodes(IIterableGraph<NodeType> graph, final INodeFilter<NodeType> filter) {
        Preconditions.checkNotNull(graph, "Error: Graph argument can't be null");
        Preconditions.checkNotNull(filter, "Error: Filter argument can't be null");
        final ArrayList nodes = new ArrayList();
        graph.iterate(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType node) {
                if (filter.qualifies(node)) {
                    nodes.add(node);
                }
                return IterationMode.CONTINUE;
            }
        });
        return nodes;
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> Collection<NodeType> getPredecessorsOfSelection(ISelectableGraph<NodeType> graph) {
        return GraphAlgorithms.getPredecessors(GraphHelpers.getSelectedNodes(graph));
    }

    public static <NodeType extends ZyGraphNode<?>> String getSelectedContent(AbstractZyGraph<NodeType, ?> graph) {
        final StringBuilder selection = new StringBuilder();
        IteratorFunctions.iterateSelected(graph, new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType node) {
                IZyNodeRealizer realizer = ((ZyGraphNode)node).getRealizer();
                ZyLabelContent content = realizer.getNodeContent();
                for (ZyLineContent line : content) {
                    selection.append(line.getText());
                    selection.append("\n");
                }
                selection.append("\n");
                return IterationMode.CONTINUE;
            }
        });
        return selection.toString();
    }

    @Deprecated
    public static <NodeType extends ISelectableNode> IFilledList<NodeType> getSelectedNodes(ISelectableGraph<NodeType> graph) {
        Preconditions.checkNotNull(graph, "Error: Graph argument can't be null");
        final FilledList nodes = new FilledList();
        graph.iterateSelected(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType node) {
                nodes.add(node);
                return IterationMode.CONTINUE;
            }
        });
        return nodes;
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> Collection<NodeType> getSuccessors(NodeType node) {
        ArrayList<NodeType> nodes = new ArrayList<NodeType>();
        nodes.add(node);
        return GraphAlgorithms.getSuccessors(nodes);
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> Collection<NodeType> getSuccessorsOfSelection(ISelectableGraph<NodeType> graph) {
        return GraphAlgorithms.getSuccessors(GraphHelpers.getSelectedNodes(graph));
    }

    public static <NodeType extends ISelectableNode> List<NodeType> getUnselectedNodes(IIterableGraph<NodeType> graph) {
        Preconditions.checkNotNull(graph, "Error: Graph argument can't be null");
        final ArrayList nodes = new ArrayList();
        graph.iterate(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType node) {
                if (!node.isSelected()) {
                    nodes.add(node);
                }
                return IterationMode.CONTINUE;
            }
        });
        return nodes;
    }

    public static <NodeType extends ISelectableNode> Set<NodeType> getVisibleNodes(IViewableGraph<NodeType> graph) {
        final HashSet nodes = new HashSet();
        graph.iterateVisible(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType node) {
                nodes.add(node);
                return IterationMode.CONTINUE;
            }
        });
        return nodes;
    }

    public static <ItemType, CollectionType extends IIterableCollection<INodeCallback<ItemType>>> void iterate(CollectionType collection, final IFilteredItemCallback<ItemType> callback) {
        collection.iterate(new INodeCallback<ItemType>(){

            @Override
            public IterationMode next(ItemType node) {
                if (callback.qualifies(node)) {
                    return callback.next(node);
                }
                return IterationMode.CONTINUE;
            }
        });
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> void selectPredecessors(ISelectableGraph<NodeType> graph, NodeType node) {
        graph.selectNodes(GraphAlgorithms.getPredecessors(node), true);
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> void selectPredecessorsOfSelection(ISelectableGraph<NodeType> graph) {
        graph.selectNodes(GraphHelpers.getPredecessorsOfSelection(graph), true);
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode, GraphType extends ISelectableGraph<NodeType>> void selectSuccessors(GraphType graph, NodeType node) {
        graph.selectNodes(GraphAlgorithms.getSuccessors(node), true);
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> void selectSuccessorsOfSelection(ISelectableGraph<NodeType> graph) {
        graph.selectNodes(GraphHelpers.getSuccessorsOfSelection(graph), true);
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> void shrinkSelectionDown(ISelectableGraph<NodeType> graph) {
        final ArrayList deselect = new ArrayList();
        graph.iterateSelected(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType node) {
                if (GraphHelpers.areAllParentsDeselected(node) && !deselect.contains(node)) {
                    deselect.add(node);
                }
                return IterationMode.CONTINUE;
            }
        });
        graph.selectNodes(deselect, false);
    }

    public static <NodeType extends IGraphNode<NodeType> & ISelectableNode> void shrinkSelectionUp(ISelectableGraph<NodeType> graph) {
        final ArrayList deselect = new ArrayList();
        graph.iterateSelected(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType node) {
                if (GraphHelpers.areAllChildrenDeselected(node) && !deselect.contains(node)) {
                    deselect.add(node);
                }
                return IterationMode.CONTINUE;
            }
        });
        graph.selectNodes(deselect, false);
    }

    public static <NodeType extends ISelectableNode, GraphType extends ISelectableGraph<NodeType> & IZoomableGraph<NodeType>> void zoomToSelected(GraphType graph) {
        IFilledList<NodeType> selectedNodes = GraphHelpers.getSelectedNodes(graph);
        if (selectedNodes.size() == 0) {
            throw new IllegalStateException("Error: There are no selected nodes");
        }
        ((IZoomableGraph<NodeType>)graph).zoomToNodes(selectedNodes);
    }
}

