/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.functions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.zygraph.IRawNodeAccessible;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IEdgeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.IViewableNode;
import com.google.security.zynamics.zylib.types.common.IterationMode;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.edges.ZyGraphEdge;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.nodes.ZyGraphNode;

public class IteratorFunctions {
    public static <EdgeType extends ZyGraphEdge<?, ?, ?> & IViewableNode & IRawNodeAccessible> void iterateInvisible(AbstractZyGraph<?, EdgeType> graph, final IEdgeCallback<EdgeType> callback) {
        Preconditions.checkNotNull(callback, "Error: Callback argument can't be null");
        graph.iterateEdges(new IEdgeCallback<EdgeType>(){

            @Override
            public IterationMode nextEdge(EdgeType edge) {
                if (((ZyGraphEdge)edge).isVisible()) {
                    return IterationMode.CONTINUE;
                }
                return callback.nextEdge(edge);
            }
        });
    }

    public static <NodeType extends ZyGraphNode<?> & IViewableNode & IRawNodeAccessible> void iterateInvisible(AbstractZyGraph<NodeType, ?> graph, final INodeCallback<NodeType> callback) {
        Preconditions.checkNotNull(callback, "Error: Callback argument can't be null");
        graph.iterate(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType node) {
                if (((ZyGraphNode)node).isVisible()) {
                    return IterationMode.CONTINUE;
                }
                return callback.next(node);
            }
        });
    }

    public static <NodeType extends ZyGraphNode<?> & IViewableNode & IRawNodeAccessible> void iterateSelected(AbstractZyGraph<NodeType, ?> graph, final INodeCallback<NodeType> callback) {
        Preconditions.checkNotNull(callback, "Error: Callback argument can't be null");
        graph.iterate(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType node) {
                if (!((ZyGraphNode)node).isSelected()) {
                    return IterationMode.CONTINUE;
                }
                return callback.next(node);
            }
        });
    }

    public static <EdgeType extends ZyGraphEdge<?, ?, ?> & IViewableNode & IRawNodeAccessible> void iterateVisible(AbstractZyGraph<?, EdgeType> graph, final IEdgeCallback<EdgeType> callback) {
        Preconditions.checkNotNull(callback, "Error: Callback argument can't be null");
        graph.iterateEdges(new IEdgeCallback<EdgeType>(){

            @Override
            public IterationMode nextEdge(EdgeType edge) {
                if (!((ZyGraphEdge)edge).isVisible()) {
                    return IterationMode.CONTINUE;
                }
                return callback.nextEdge(edge);
            }
        });
    }

    public static <NodeType extends ZyGraphNode<?> & IViewableNode & IRawNodeAccessible> void iterateVisible(AbstractZyGraph<NodeType, ?> graph, final INodeCallback<NodeType> callback) {
        Preconditions.checkNotNull(callback, "Error: Callback argument can't be null");
        graph.iterate(new INodeCallback<NodeType>(){

            @Override
            public IterationMode next(NodeType node) {
                if (!((ZyGraphNode)node).isVisible()) {
                    return IterationMode.CONTINUE;
                }
                return callback.next(node);
            }
        });
    }
}

