/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.edges;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.edges.CBend;
import com.google.security.zynamics.zylib.gui.zygraph.edges.EdgeType;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdge;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IViewEdgeListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class CViewEdge<NodeType>
implements IViewEdge<NodeType> {
    private final NodeType m_sourceNode;
    private final NodeType m_targetNode;
    private EdgeType m_type;
    private double m_x1;
    private double m_y1;
    private double m_x2;
    private double m_y2;
    private Color m_color;
    private boolean m_visible;
    private boolean m_selected;
    private int m_id;
    private final List<CBend> m_paths;
    protected final ListenerProvider<IViewEdgeListener> m_listeners = new ListenerProvider();

    public CViewEdge(int id, NodeType sourceNode, NodeType targetNode, EdgeType type, double x1, double y1, double x2, double y2, Color color, boolean selected, boolean visible, List<CBend> edgePaths) {
        this.m_sourceNode = Preconditions.checkNotNull(sourceNode, "Error: Source node argument can't be null");
        this.m_targetNode = Preconditions.checkNotNull(targetNode, "Error: Target node argument can't be null");
        this.m_id = id;
        this.m_type = type;
        this.m_x1 = x1;
        this.m_y1 = y1;
        this.m_x2 = x2;
        this.m_y2 = y2;
        this.m_color = color;
        this.m_visible = visible;
        this.m_selected = selected;
        this.m_paths = edgePaths;
    }

    @Override
    public void addBend(double x2, double y2) {
        CBend path = new CBend(x2, y2);
        this.m_paths.add(path);
        for (IViewEdgeListener listener : this.m_listeners) {
            try {
                listener.addedBend(this, path);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void addListener(IViewEdgeListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public void clearBends() {
        this.m_paths.clear();
        for (IViewEdgeListener listener : this.m_listeners) {
            try {
                listener.clearedBends(this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public int getBendCount() {
        return this.m_paths.size();
    }

    @Override
    public List<CBend> getBends() {
        return new ArrayList<CBend>(this.m_paths);
    }

    @Override
    public Color getColor() {
        return this.m_color;
    }

    @Override
    public int getId() {
        return this.m_id;
    }

    @Override
    public NodeType getSource() {
        return this.m_sourceNode;
    }

    @Override
    public NodeType getTarget() {
        return this.m_targetNode;
    }

    @Override
    public EdgeType getType() {
        return this.m_type;
    }

    @Override
    public double getX1() {
        return this.m_x1;
    }

    @Override
    public double getX2() {
        return this.m_x2;
    }

    @Override
    public double getY1() {
        return this.m_y1;
    }

    @Override
    public double getY2() {
        return this.m_y2;
    }

    @Override
    public void insertBend(int index, double x2, double y2) {
        CBend path = new CBend(x2, y2);
        this.m_paths.add(index, path);
        for (IViewEdgeListener listener : this.m_listeners) {
            try {
                listener.insertedBend(this, index, path);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public boolean isSelected() {
        return this.m_selected;
    }

    @Override
    public boolean isVisible() {
        return this.m_visible;
    }

    public void removeAllListeners() {
        ArrayList<IViewEdgeListener> listeners = new ArrayList<IViewEdgeListener>();
        for (IViewEdgeListener listener : this.m_listeners) {
            listeners.add(listener);
        }
        for (IViewEdgeListener listener : listeners) {
            this.removeListener(listener);
        }
    }

    @Override
    public void removeBend(int index) {
        CBend path = this.m_paths.get(index);
        this.m_paths.remove(index);
        for (IViewEdgeListener listener : this.m_listeners) {
            listener.removedBend(this, index, path);
        }
    }

    @Override
    public void removeListener(IViewEdgeListener listener) {
        this.m_listeners.removeListener(listener);
    }

    @Override
    public void setColor(Color color) {
        Preconditions.checkNotNull(color, "Error: Color argument can not be null");
        if (this.m_color.equals(color)) {
            return;
        }
        this.m_color = color;
        for (IViewEdgeListener listener : this.m_listeners) {
            listener.changedColor(this, color);
        }
    }

    @Override
    public void setEdgeType(EdgeType type) {
        Preconditions.checkNotNull(type, "Error: Type argument can't be null");
        if (type == this.m_type) {
            return;
        }
        this.m_type = type;
        for (IViewEdgeListener listener : this.m_listeners) {
            listener.changedType(this, type);
        }
    }

    @Override
    public void setId(int id) {
        this.m_id = id;
    }

    @Override
    public void setSelected(boolean selected) {
        if (this.m_selected == selected) {
            return;
        }
        this.m_selected = selected;
        for (IViewEdgeListener listener : this.m_listeners) {
            listener.changedSelection(this, selected);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.m_visible == visible) {
            return;
        }
        this.m_visible = visible;
        for (IViewEdgeListener listener : this.m_listeners) {
            listener.changedVisibility(this, this.m_visible);
        }
    }

    @Override
    public void setX1(double x1) {
        if (Double.compare(this.m_x1, x1) == 0) {
            return;
        }
        this.m_x1 = x1;
        for (IViewEdgeListener listener : this.m_listeners) {
            listener.changedSourceX(this, x1);
        }
    }

    @Override
    public void setX2(double x2) {
        if (Double.compare(this.m_x2, x2) == 0) {
            return;
        }
        this.m_x2 = x2;
        for (IViewEdgeListener listener : this.m_listeners) {
            listener.changedTargetX(this, x2);
        }
    }

    @Override
    public void setY1(double y1) {
        if (Double.compare(this.m_y1, y1) == 0) {
            return;
        }
        this.m_y1 = y1;
        for (IViewEdgeListener listener : this.m_listeners) {
            listener.changedSourceY(this, y1);
        }
    }

    @Override
    public void setY2(double y2) {
        if (Double.compare(this.m_y2, y2) == 0) {
            return;
        }
        this.m_y2 = y2;
        for (IViewEdgeListener listener : this.m_listeners) {
            listener.changedTargetY(this, y2);
        }
    }
}

