/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph.edges;

import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.edges.IBendListener;

public class CBend {
    private double m_x;
    private double m_y;
    private final ListenerProvider<IBendListener> m_listeners = new ListenerProvider();

    public CBend(double x2, double y2) {
        this.m_x = x2;
        this.m_y = y2;
    }

    public void addListener(IBendListener listener) {
        this.m_listeners.addListener(listener);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CBend)) {
            return false;
        }
        CBend rhs = (CBend)object;
        return Double.compare(rhs.m_x, this.m_x) == 0 && Double.compare(rhs.m_y, this.m_y) == 0;
    }

    public double getX() {
        return this.m_x;
    }

    public double getY() {
        return this.m_y;
    }

    public void removeListener(IBendListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setX(double x2) {
        if (Double.compare(this.m_x, x2) == 0) {
            return;
        }
        this.m_x = x2;
        for (IBendListener listener : this.m_listeners) {
            listener.changedX(this, x2);
        }
    }

    public void setY(double y2) {
        if (Double.compare(this.m_y, y2) == 0) {
            return;
        }
        this.m_y = y2;
        for (IBendListener listener : this.m_listeners) {
            listener.changedY(this, y2);
        }
    }
}

