/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.zygraph;

import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.zygraph.ILabelEditableContentListener;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.IZyRegenerateableRealizer;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CAbstractKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CBackspaceKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CCharKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CCopyKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CCursorKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CCutKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CDelKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CEndKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CHomeKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CInsertKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CPasteKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CRedoKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CReturnKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CSelectAllKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CTabKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.CUndoKeyBehavior;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.KeyBehaviours.UndoHistroy.CUndoManager;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyCaret;
import com.google.security.zynamics.zylib.gui.zygraph.realizers.ZyLabelContent;
import com.google.security.zynamics.zylib.yfileswrap.gui.zygraph.AbstractZyGraph;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;

public class CDefaultLabelEventHandler
extends KeyAdapter {
    private final AbstractZyGraph<?, ?> m_graph;
    private final Map<Integer, CAbstractKeyBehavior> m_ctrlKeyBehaviourMap = new HashMap<Integer, CAbstractKeyBehavior>();
    private final Map<Integer, CAbstractKeyBehavior> m_keyBehaviourMap = new HashMap<Integer, CAbstractKeyBehavior>();
    private final CUndoManager m_undoManager = new CUndoManager();
    private ZyLabelContent m_activeLabelContent;
    private IZyRegenerateableRealizer m_activeRealizer;
    private final InternalFocusListener m_focusListener = new InternalFocusListener();
    private final ListenerProvider<ILabelEditableContentListener> m_editModeListener = new ListenerProvider();

    public CDefaultLabelEventHandler(AbstractZyGraph<?, ?> graph) {
        this.m_graph = graph;
        this.m_graph.addViewFocusListener(this.m_focusListener);
        this.init();
    }

    private String getContentSnippet(int yPos) {
        int lineIndex;
        String snippet = "";
        int firstLineIndex = this.getActiveLabelContent().getFirstLineIndexOfModelAt(yPos);
        int lastLineIndex = this.getActiveLabelContent().getLastLineIndexOfModelAt(yPos);
        for (lineIndex = firstLineIndex; lineIndex <= lastLineIndex; ++lineIndex) {
            String string2 = String.valueOf(snippet);
            String string3 = String.valueOf(this.getActiveLabelContent().getLineContent(lineIndex).getText());
            snippet = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        if (firstLineIndex > 0) {
            lastLineIndex = firstLineIndex - 1;
            firstLineIndex = this.getActiveLabelContent().getFirstLineIndexOfModelAt(lastLineIndex);
            String content = "";
            for (int lineIndex2 = firstLineIndex; lineIndex2 <= lastLineIndex; ++lineIndex2) {
                String string4 = String.valueOf(content);
                String string5 = String.valueOf(this.getActiveLabelContent().getLineContent(lineIndex2).getText());
                content = string5.length() != 0 ? string4.concat(string5) : new String(string4);
            }
            String string6 = String.valueOf(content);
            String string7 = String.valueOf(snippet);
            String string8 = snippet = string7.length() != 0 ? string6.concat(string7) : new String(string6);
        }
        if ((lastLineIndex = this.getActiveLabelContent().getLastLineIndexOfModelAt(yPos)) + 1 < this.getActiveLabelContent().getLineCount() - 1) {
            firstLineIndex = lastLineIndex + 1;
            lastLineIndex = this.getActiveLabelContent().getLastLineIndexOfModelAt(firstLineIndex);
            for (lineIndex = firstLineIndex; lineIndex <= lastLineIndex; ++lineIndex) {
                String string9 = String.valueOf(snippet);
                String string10 = String.valueOf(this.getActiveLabelContent().getLineContent(lineIndex).getText());
                snippet = string10.length() != 0 ? string9.concat(string10) : new String(string9);
            }
        }
        return snippet;
    }

    private void init() {
        this.m_keyBehaviourMap.put(38, new CCursorKeyBehavior(this.m_undoManager));
        this.m_keyBehaviourMap.put(40, new CCursorKeyBehavior(this.m_undoManager));
        this.m_keyBehaviourMap.put(37, new CCursorKeyBehavior(this.m_undoManager));
        this.m_keyBehaviourMap.put(39, new CCursorKeyBehavior(this.m_undoManager));
        this.m_keyBehaviourMap.put(9, new CTabKeyBehavior(this.m_undoManager));
        this.m_keyBehaviourMap.put(36, new CHomeKeyBehavior(this.m_undoManager));
        this.m_keyBehaviourMap.put(35, new CEndKeyBehavior(this.m_undoManager));
        this.m_keyBehaviourMap.put(155, new CInsertKeyBehavior(this.m_undoManager));
        this.m_keyBehaviourMap.put(127, new CDelKeyBehavior(this.m_undoManager));
        this.m_keyBehaviourMap.put(8, new CBackspaceKeyBehavior(this.m_undoManager));
        this.m_keyBehaviourMap.put(10, new CReturnKeyBehavior(this.m_undoManager));
        this.m_keyBehaviourMap.put(null, new CCharKeyBehavior(this.m_undoManager));
        this.m_ctrlKeyBehaviourMap.put(65, new CSelectAllKeyBehavior(this.m_undoManager));
        this.m_ctrlKeyBehaviourMap.put(88, new CCutKeyBehavior(this.m_undoManager));
        this.m_ctrlKeyBehaviourMap.put(67, new CCopyKeyBehavior(this.m_undoManager));
        this.m_ctrlKeyBehaviourMap.put(86, new CPasteKeyBehavior(this.m_undoManager));
        this.m_ctrlKeyBehaviourMap.put(89, new CRedoKeyBehavior(this.m_undoManager));
        this.m_ctrlKeyBehaviourMap.put(90, new CUndoKeyBehavior(this.m_undoManager));
    }

    protected AbstractZyGraph<?, ?> getGraph() {
        return this.m_graph;
    }

    public void activateLabelContent(ZyLabelContent labelContent, IZyRegenerateableRealizer activeRealizer) {
        if (labelContent == null || activeRealizer == null) {
            return;
        }
        this.unregisterListener();
        if (this.getActiveLabelContent() != null && labelContent != this.getActiveLabelContent() && this.getActiveLabelContent().isSelectable()) {
            this.getActiveLabelContent().showCaret(false);
            this.m_graph.updateViews();
        }
        this.setActiveLabelContent(labelContent);
        this.m_activeRealizer = activeRealizer;
        this.getActiveLabelContent().showCaret(this.getActiveLabelContent().isSelectable());
        this.m_undoManager.setLabelContent(this.getActiveLabelContent());
        this.registerListener();
    }

    public void addEditModeListener(ILabelEditableContentListener listener) {
        this.m_editModeListener.addListener(listener);
    }

    public void addKeyBehaviour(Integer keyCode, CAbstractKeyBehavior behaviour, boolean ctrl) {
        if (ctrl) {
            this.m_ctrlKeyBehaviourMap.put(keyCode, behaviour);
        } else {
            this.m_keyBehaviourMap.put(keyCode, behaviour);
        }
    }

    public void deactivateLabelContent() {
        this.unregisterListener();
        if (this.getActiveLabelContent() != null && this.getActiveLabelContent().isSelectable()) {
            this.getActiveLabelContent().showCaret(false);
            this.setActiveLabelContent(null);
            this.m_activeRealizer = null;
        }
        this.m_graph.updateViews();
        this.m_undoManager.setLabelContent(this.getActiveLabelContent());
        this.registerListener();
    }

    public void dispose() {
        this.m_graph.removeViewFocusListener(this.m_focusListener);
    }

    public void handleMouseDraggedEvent(double labelParentX, double labelParentY, double mouseX, double mouseY, double zoomFactor) {
        ZyCaret caret = this.getActiveLabelContent().getCaret();
        int oldlr = caret.getYmouseReleased();
        int oldpr = caret.getXmouseReleased();
        caret.setCaretEnd(labelParentX, labelParentY, mouseX, mouseY, zoomFactor);
        if (caret.getYmouseReleased() != oldlr || caret.getXmouseReleased() != oldpr) {
            this.m_activeRealizer.repaint();
        }
    }

    public void handleMousePressedEvent(double labelParentX, double labelParentY, double mouseX, double mouseY, double zoomFactor) {
        ZyCaret caret = this.getActiveLabelContent().getCaret();
        caret.setCaretStart(labelParentX, labelParentY, mouseX, mouseY, zoomFactor);
        caret.setCaretEnd(labelParentX, labelParentY, mouseX, mouseY, zoomFactor);
        this.m_activeRealizer.repaint();
    }

    public void handleMouseReleasedEvent(double labelParentX, double labelParentY, double mouseX, double mouseY, double zoomFactor, int clickCount) {
        ZyCaret caret = this.getActiveLabelContent().getCaret();
        switch (clickCount) {
            case 1: {
                caret.setCaretEnd(labelParentX, labelParentY, mouseX, mouseY, zoomFactor);
                break;
            }
            case 2: {
                caret.selectWord(labelParentX, labelParentY, mouseX, mouseY, zoomFactor);
                break;
            }
            case 3: {
                caret.selectLine(labelParentY, mouseY);
                break;
            }
            case 4: {
                caret.selectAll();
            }
        }
        this.m_activeRealizer.repaint();
    }

    public boolean hasEmptySelection() {
        return this.getActiveLabelContent().getSelectedText().equals("");
    }

    public boolean isActive() {
        return this.getActiveLabelContent() != null;
    }

    public boolean isActiveLabel(ZyLabelContent labelContent) {
        return labelContent != null && labelContent == this.getActiveLabelContent();
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (!this.isActive()) {
            return;
        }
        if (event.getKeyCode() == 27) {
            this.deactivateLabelContent();
            return;
        }
        if (event.getKeyCode() == 9 && event.getModifiers() != 0 && event.getModifiers() != 64) {
            return;
        }
        if (!this.getActiveLabelContent().isSelectable()) {
            return;
        }
        CAbstractKeyBehavior behaviour = null;
        char keyText = KeyEvent.getKeyText(event.getKeyCode()).charAt(0);
        if (event.isControlDown() && keyText >= 'A' && keyText <= 'Z') {
            behaviour = this.m_ctrlKeyBehaviourMap.get(event.getKeyCode());
        }
        if (behaviour == null && (behaviour = this.m_keyBehaviourMap.get(event.getKeyCode())) == null && event.getKeyChar() != '\uffff' && !event.isControlDown() && this.getActiveLabelContent().isEditable()) {
            behaviour = this.m_keyBehaviourMap.get(null);
        }
        if (behaviour != null) {
            String newContent;
            int y2 = -1;
            String oldContent = "";
            if (this.getActiveLabelContent().isEditable()) {
                y2 = this.getActiveLabelContent().getCaret().getYmouseReleased();
                oldContent = this.getContentSnippet(y2);
            }
            behaviour.keyPressed(this.getActiveLabelContent(), event);
            if (y2 > -1 && !oldContent.equals(newContent = this.getContentSnippet(y2)) && !oldContent.isEmpty()) {
                for (ILabelEditableContentListener listener : this.m_editModeListener) {
                    listener.editableContentChanged(this.getActiveLabelContent());
                }
            }
            this.m_activeRealizer.regenerate();
            this.m_activeRealizer.repaint();
            this.m_graph.updateViews();
        }
        event.consume();
    }

    public void registerListener() {
        if (this.isActive()) {
            this.m_graph.addViewCanvasKeyListener(this);
        }
    }

    public void removeEditModeListener(ILabelEditableContentListener listener) {
        this.m_editModeListener.removeListener(listener);
    }

    public void unregisterListener() {
        if (this.isActive()) {
            this.m_graph.removeViewCanvasKeyListener(this);
        }
    }

    private ZyLabelContent getActiveLabelContent() {
        return this.m_activeLabelContent;
    }

    private void setActiveLabelContent(ZyLabelContent m_activeLabelContent) {
        this.m_activeLabelContent = m_activeLabelContent;
    }

    private class InternalFocusListener
    implements FocusListener {
        private InternalFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e2) {
        }

        @Override
        public void focusLost(FocusEvent e2) {
            CDefaultLabelEventHandler.this.deactivateLabelContent();
        }
    }
}

