/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.tables;

import com.google.common.base.Strings;
import com.google.security.zynamics.zylib.general.ClipboardHelpers;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;

public class CopySelectionAction
extends AbstractAction {
    private final JTable table;

    public CopySelectionAction(JTable table) {
        super("Copy Selection");
        this.table = table;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int[] rows = this.table.getSelectedRows();
        int cols = this.table.getColumnCount();
        int[] maximums = new int[cols];
        for (int row : rows) {
            for (int i2 = 0; i2 < cols; ++i2) {
                int maximum;
                if (this.table.getValueAt(row, i2) == null || (maximum = this.table.getValueAt(row, i2).toString().length()) <= maximums[i2]) continue;
                maximums[i2] = maximum;
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int row : rows) {
            for (int i3 = 0; i3 < cols; ++i3) {
                if (this.table.getValueAt(row, i3) == null) continue;
                String value = this.table.getValueAt(row, i3).toString();
                int differenceToMaximum = maximums[i3] - value.length();
                sb.append(value);
                sb.append(Strings.repeat(" ", differenceToMaximum));
                if (i3 == cols - 1) continue;
                sb.append("  ");
            }
            sb.append("\n");
        }
        ClipboardHelpers.copyToClipboard(sb.toString());
    }
}

